/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import cn.qqtheme.framework.icons.ColorPickerIcon;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.widget.ColorPanelView;
import cn.qqtheme.framework.widget.StrokeTextView;
import java.util.Locale;

public class ColorPicker
extends ConfirmPopup<LinearLayout> {
    @IdRes
    private static final int MULTI_ID = 1;
    @IdRes
    private static final int BLACK_ID = 2;
    private int initColor = -1;
    private ColorPanelView multiColorView;
    private ColorPanelView blackColorView;
    private StrokeTextView hexValView;
    private OnColorPickListener onColorPickListener;

    public ColorPicker(Activity activity) {
        super(activity);
        this.setHalfScreen(true);
        this.setTitleView(this.createTitleView(activity));
    }

    private View createTitleView(Activity activity) {
        int margin;
        this.hexValView = new StrokeTextView((Context)activity, true);
        int height = ConvertUtils.toPx((Context)activity, 28.0f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, height);
        params.leftMargin = margin = ConvertUtils.toPx((Context)activity, this.topPadding);
        params.rightMargin = margin;
        params.addRule(14, -1);
        params.addRule(15, -1);
        this.hexValView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.hexValView.setGravity(17);
        this.hexValView.setBackgroundColor(this.initColor);
        this.hexValView.setBorderColor(ConvertUtils.toDarkenColor(this.initColor, 0.6f));
        this.hexValView.setTextColor(this.initColor);
        this.hexValView.setShadowLayer(3.0f, 0.0f, 2.0f, -1);
        this.hexValView.setMinEms(6);
        this.hexValView.setMaxEms(8);
        this.hexValView.setPadding(0, 0, 0, 0);
        this.hexValView.setSingleLine(true);
        this.hexValView.setEnabled(false);
        return this.hexValView;
    }

    @Override
    @NonNull
    protected LinearLayout makeCenterView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        this.multiColorView = new ColorPanelView((Context)this.activity);
        this.multiColorView.setId(1);
        this.multiColorView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        Drawable cursorTopDrawable = ConvertUtils.toDrawable(ColorPickerIcon.getCursorTop());
        this.multiColorView.setPointerDrawable(cursorTopDrawable);
        this.multiColorView.setOnColorChangedListener(new ColorPanelView.OnColorChangedListener(){

            @Override
            public void onColorChanged(ColorPanelView view, int color) {
                ColorPicker.this.updateCurrentColor(color);
            }
        });
        rootLayout.addView((View)this.multiColorView);
        this.blackColorView = new ColorPanelView((Context)this.activity);
        this.blackColorView.setId(2);
        this.blackColorView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ConvertUtils.toPx((Context)this.activity, 30.0f)));
        Drawable cursorBottomDrawable = ConvertUtils.toDrawable(ColorPickerIcon.getCursorBottom());
        this.blackColorView.setPointerDrawable(cursorBottomDrawable);
        this.blackColorView.setOnColorChangedListener(new ColorPanelView.OnColorChangedListener(){

            @Override
            public void onColorChanged(ColorPanelView view, int color) {
                ColorPicker.this.updateCurrentColor(color);
            }
        });
        rootLayout.addView((View)this.blackColorView);
        return rootLayout;
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        this.multiColorView.setColor(this.initColor);
        this.multiColorView.setBrightnessGradientView(this.blackColorView);
    }

    @Override
    protected void onSubmit() {
        if (this.onColorPickListener != null) {
            this.onColorPickListener.onColorPicked(this.getCurrentColor());
        }
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    @ColorInt
    public int getCurrentColor() {
        return Color.parseColor((String)("#" + this.hexValView.getText()));
    }

    private void updateCurrentColor(int color) {
        String hexColorString = ConvertUtils.toColorString(color, false).toUpperCase(Locale.getDefault());
        this.hexValView.setText(hexColorString);
        this.hexValView.setBorderColor(ConvertUtils.toDarkenColor(color, 0.6f));
        this.hexValView.setTextColor(color);
        this.hexValView.setBackgroundColor(color);
    }

    public void setInitColor(int initColor) {
        this.initColor = initColor;
    }

    public void setOnColorPickListener(OnColorPickListener onColorPickListener) {
        this.onColorPickListener = onColorPickListener;
    }

    public static interface OnColorPickListener {
        public void onColorPicked(@ColorInt int var1);
    }
}

