/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.cuid.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.speech.utils.MD5Util;
import com.baidu.speech.utils.cuid.security.AESUtil;
import com.baidu.speech.utils.cuid.security.Base64;
import com.baidu.speech.utils.cuid.security.SHA1Util;
import com.baidu.speech.utils.cuid.util.CuidCertStore;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeviceId {
    private static final String TAG = "DeviceId";
    private static final boolean DEBUG = false;
    private static final String KEY_DEVICE_ID = "com.baidu.deviceid";
    private static final String KEY_DEVICE_ID_V2 = "com.baidu.deviceid.v2";
    private static final String AES_KEY;
    private static final String OLD_EXT_DIR = "baidu";
    private static final String EXT_DIR = "backups/.SystemConfig";
    private static final String EXT_FILE = ".cuid";
    private static final String EXT_FILE_V2 = ".cuid2";
    private final Context mContext;
    private int mSaveMask = 0;
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PublicKey mPublicKey;
    private static final int STORAGE_SYSTEM_SETTING_V1 = 1;
    private static final int STORAGE_SYSTEM_SETTING_V2 = 2;
    private static final int STORAGE_SDCARD_V1 = 4;
    private static final int STORAGE_SDCARD_V2 = 8;
    private static final int STORAGE_SELF_FILE = 16;
    private static final String SELF_CUID_FILE = "libcuid.so";
    private static CUIDInfo sCachedCuidInfo;
    private static final String KEY_FLAG = "bd_setting_i";
    private static final String DEFAULT_TM_DEVICEID = "";
    private static final int SDK_ANDROID_M = 23;
    private static final boolean CONFIG_WRITE_V1_STORAGE = false;
    private static boolean sDataCuidInfoShable;
    private static final String sDEncoded = "ZGV2aWNlaWQ=";
    private static final String sIEncoded = "aW1laQ==";
    private static final String sVEncoded = "dmVy";
    private static final String ACTION_GLAXY_CUID = "com.baidu.intent.action.GALAXY";
    private static final String META_KEY_GLAXY_DATA = "galaxy_data";
    private static final String META_KEY_GALAXY_SF = "galaxy_sf";
    private static final int S_IRWXU = 448;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRWXG = 56;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IRWXO = 7;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private DeviceId(Context context) {
        this.mContext = context.getApplicationContext();
        this.initPublicKey();
    }

    private static String byte2hex(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String string = DEFAULT_TM_DEVICEID;
        String string2 = DEFAULT_TM_DEVICEID;
        for (int i = 0; i < byArray.length; ++i) {
            string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string2.length() == 1 ? string + "0" + string2 : string + string2;
        }
        return string.toLowerCase();
    }

    public static void setCuidDataShable(Context context, boolean bl) {
        File file = new File(context.getApplicationContext().getFilesDir(), SELF_CUID_FILE);
        Context context2 = context.getApplicationContext();
        if (file.exists()) {
            if (sCachedCuidInfo == null) {
                DeviceId.tryToModifyChmodForSelfFile(context2, bl);
            } else if (sDataCuidInfoShable != bl) {
                DeviceId.tryToModifyChmodForSelfFile(context2, bl);
            }
        }
        sDataCuidInfoShable = bl;
    }

    private String[] formatAndroidSigArray(Signature[] signatureArray) {
        String[] stringArray = new String[signatureArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = DeviceId.byte2hex(SHA1Util.sha1(signatureArray[i].toByteArray()));
        }
        return stringArray;
    }

    private static byte[] decryptByPublicKey(byte[] byArray, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initPublicKey() {
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(CuidCertStore.getCertBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        this.mPublicKey = certificate.getPublicKey();
        Object var5_5 = null;
        if (byteArrayInputStream == null) return;
        try {
            byteArrayInputStream.close();
            return;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return;
        {
            catch (Exception exception) {
                Object var5_6 = null;
                if (byteArrayInputStream == null) return;
                try {
                    byteArrayInputStream.close();
                    return;
                }
                catch (Exception exception2) {
                    DeviceId.handleThrowable(exception2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                DeviceId.handleThrowable(exception);
            }
            throw throwable;
        }
    }

    private List<CUIDBuddyInfo> collectBuddyInfos(Intent intent, boolean bl) {
        ArrayList<CUIDBuddyInfo> arrayList = new ArrayList<CUIDBuddyInfo>();
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) continue;
                try {
                    String string;
                    String string2;
                    ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name), 128);
                    Bundle bundle = activityInfo.metaData;
                    if (bundle == null || TextUtils.isEmpty((CharSequence)(string2 = bundle.getString(META_KEY_GLAXY_DATA)))) continue;
                    byte[] byArray = Base64.decode(string2.getBytes("utf-8"));
                    String string3 = new String(byArray);
                    JSONObject jSONObject = new JSONObject(string3);
                    CUIDBuddyInfo cUIDBuddyInfo = new CUIDBuddyInfo();
                    cUIDBuddyInfo.priority = jSONObject.getInt("priority");
                    cUIDBuddyInfo.appInfo = resolveInfo.activityInfo.applicationInfo;
                    if (this.mContext.getPackageName().equals(resolveInfo.activityInfo.applicationInfo.packageName)) {
                        cUIDBuddyInfo.isSelf = true;
                    }
                    if (bl && !TextUtils.isEmpty((CharSequence)(string = bundle.getString(META_KEY_GALAXY_SF)))) {
                        PackageInfo packageInfo = packageManager.getPackageInfo(resolveInfo.activityInfo.applicationInfo.packageName, 64);
                        JSONArray jSONArray = jSONObject.getJSONArray("sigs");
                        String[] stringArray = new String[jSONArray.length()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = jSONArray.getString(i);
                        }
                        String[] stringArray2 = this.formatAndroidSigArray(packageInfo.signatures);
                        if (this.isSigsEqual(stringArray, stringArray2)) {
                            boolean bl2;
                            byte[] byArray2 = DeviceId.decryptByPublicKey(Base64.decode(string.getBytes()), this.mPublicKey);
                            byte[] byArray3 = SHA1Util.sha1(byArray);
                            boolean bl3 = bl2 = byArray2 != null && Arrays.equals(byArray2, byArray3);
                            if (bl2) {
                                cUIDBuddyInfo.sigMatched = true;
                            }
                        }
                    }
                    arrayList.add(cUIDBuddyInfo);
                }
                catch (Exception exception) {}
            }
        }
        Collections.sort(arrayList, new Comparator<CUIDBuddyInfo>(){

            @Override
            public int compare(CUIDBuddyInfo cUIDBuddyInfo, CUIDBuddyInfo cUIDBuddyInfo2) {
                int n = cUIDBuddyInfo2.priority - cUIDBuddyInfo.priority;
                if (n == 0) {
                    if (cUIDBuddyInfo.isSelf && cUIDBuddyInfo2.isSelf) {
                        return 0;
                    }
                    if (cUIDBuddyInfo.isSelf) {
                        return -1;
                    }
                    if (cUIDBuddyInfo2.isSelf) {
                        return 1;
                    }
                }
                return n;
            }
        });
        return arrayList;
    }

    private boolean isSigsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        HashSet hashSet2 = new HashSet();
        for (String string : stringArray2) {
            hashSet2.add(string);
        }
        return hashSet.equals(hashSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressLint(value={"NewApi"})
    private boolean writeToCuidFile(String var1_1) {
        block14: {
            var2_2 = null;
            var3_3 = 0;
            var3_3 = DeviceId.sDataCuidInfoShable != false ? (Build.VERSION.SDK_INT >= 24 ? 0 : 1) : 0;
            try {
                var2_2 = this.mContext.openFileOutput("libcuid.so", var3_3);
                var2_2.write(var1_1.getBytes());
                var2_2.flush();
                var7_4 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var6_14) {
                var7_6 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var8_9) {
                        DeviceId.handleThrowable(var8_9);
                    }
                }
                throw var6_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (Exception var8_7) {
                    DeviceId.handleThrowable(var8_7);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (Exception var4_10) {
                    DeviceId.handleThrowable(var4_10);
                    var5_13 = false;
                    var7_5 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Exception var8_8) {
                            DeviceId.handleThrowable(var8_8);
                        }
                    }
                    return var5_13;
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (var3_3 == 0 && DeviceId.sDataCuidInfoShable) {
                var4_11 = 436;
                return TargetApiSupport.doChmodSafely(new File(this.mContext.getFilesDir(), "libcuid.so").getAbsolutePath(), var4_11);
            }
            if (!DeviceId.sDataCuidInfoShable) {
                var4_12 = 432;
                return TargetApiSupport.doChmodSafely(new File(this.mContext.getFilesDir(), "libcuid.so").getAbsolutePath(), var4_12);
            }
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private static boolean tryToModifyChmodForSelfFile(Context context, boolean bl) {
        File file = new File(context.getApplicationContext().getFilesDir(), SELF_CUID_FILE);
        if (!file.exists()) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            try {
                if (bl) {
                    return file.setReadable(true, false);
                }
                boolean bl2 = file.setReadable(false, false);
                boolean bl3 = file.setReadable(true, true);
                return bl2 && bl3;
            }
            catch (Exception exception) {
                DeviceId.handleThrowable(exception);
                return false;
            }
        }
        int n = bl ? 436 : 432;
        return TargetApiSupport.doChmodSafely(file.getAbsolutePath(), n);
    }

    private String getSystemSettingValue(String string) {
        try {
            return Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)string);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return null;
        }
    }

    private boolean tryPutSystemSettingValue(String string, String string2) {
        try {
            return Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)string, (String)string2);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return false;
        }
    }

    private static void handleThrowable(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeToFile(File file, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        Object var5_3 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            DeviceId.handleThrowable(iOException);
        }
        return;
        {
            catch (IOException iOException) {
                DeviceId.handleThrowable(iOException);
                Object var5_4 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    DeviceId.handleThrowable(iOException2);
                }
                return;
            }
            catch (SecurityException securityException) {
                DeviceId.handleThrowable(securityException);
                Object var5_5 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    DeviceId.handleThrowable(iOException);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                DeviceId.handleThrowable(iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFileContent(File file) {
        int n;
        FileReader fileReader = null;
        fileReader = new FileReader(file);
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while ((n = fileReader.read(cArray)) > 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        String string = charArrayWriter.toString();
        Object var7_7 = null;
        if (fileReader == null) return string;
        try {
            fileReader.close();
            return string;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return string;
        catch (Exception exception) {
            try {
                DeviceId.handleThrowable(exception);
                Object var7_8 = null;
                if (fileReader == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fileReader == null) throw throwable;
                try {
                    fileReader.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    DeviceId.handleThrowable(exception2);
                }
                throw throwable;
            }
            try {
                fileReader.close();
                return null;
            }
            catch (Exception exception3) {
                DeviceId.handleThrowable(exception3);
            }
            return null;
        }
    }

    public static String getCUID(Context context) {
        return DeviceId.getOrCreateCUIDInfo(context).getFinalCUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CUIDInfo getOrCreateCUIDInfo(Context context) {
        if (sCachedCuidInfo != null) return sCachedCuidInfo;
        Class<CUIDInfo> clazz = CUIDInfo.class;
        synchronized (CUIDInfo.class) {
            if (sCachedCuidInfo != null) return sCachedCuidInfo;
            long l = SystemClock.uptimeMillis();
            sCachedCuidInfo = new DeviceId(context).getCUIDInfo();
            long l2 = SystemClock.uptimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCachedCuidInfo;
        }
    }

    public static String getDeviceID(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).deviceId;
    }

    private static String getAndroidId(Context context) {
        String string = DEFAULT_TM_DEVICEID;
        string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = DEFAULT_TM_DEVICEID;
        }
        return string;
    }

    private CUIDInfo getCUIDInfo() {
        Object object;
        File file;
        int n;
        boolean bl;
        CUIDInfo cUIDInfo = null;
        String string = null;
        List<CUIDBuddyInfo> list = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID).setPackage(this.mContext.getPackageName()), true);
        if (list == null || list.size() == 0) {
            bl = false;
            for (int i = 0; i < 3; ++i) {
                Log.w((String)TAG, (String)"galaxy lib host missing meta-data,make sure you know the right way to integrate galaxy");
            }
        } else {
            CUIDBuddyInfo cUIDBuddyInfo = list.get(0);
            bl = cUIDBuddyInfo.sigMatched;
            if (!cUIDBuddyInfo.sigMatched) {
                for (n = 0; n < 3; ++n) {
                    Log.w((String)TAG, (String)"galaxy config err, In the release version of the signature should be matched");
                }
            }
        }
        if ((file = new File(this.mContext.getFilesDir(), SELF_CUID_FILE)).exists()) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file)));
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 0x10;
            List<CUIDBuddyInfo> list2 = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID), bl);
            if (list2 != null) {
                String string2 = "files";
                object = this.mContext.getFilesDir();
                if (!string2.equals(((File)object).getName())) {
                    Log.e((String)TAG, (String)("fetal error:: app files dir name is unexpectedly :: " + ((File)object).getAbsolutePath()));
                    string2 = ((File)object).getName();
                }
                for (CUIDBuddyInfo object2 : list2) {
                    File file2;
                    if (object2.isSelf || !(file2 = new File(new File(object2.appInfo.dataDir, string2), SELF_CUID_FILE)).exists() || (cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file2)))) == null) continue;
                    break;
                }
            }
        }
        if (cUIDInfo == null) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(this.getSystemSettingValue(KEY_DEVICE_ID_V2)));
        }
        n = this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") ? 1 : 0;
        if (cUIDInfo == null && n != 0) {
            this.mSaveMask |= 2;
            cUIDInfo = this.getCuidInfoFromExternalV2();
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 8;
            cUIDInfo = this.getCUidInfoFromSystemSettingV1();
        }
        boolean bl2 = false;
        if (cUIDInfo == null && n != 0) {
            this.mSaveMask |= 1;
            string = this.getDefaultFlag(DEFAULT_TM_DEVICEID);
            bl2 = true;
            cUIDInfo = this.getExternalV1DeviceId(string);
        }
        if (cUIDInfo == null) {
            Object object3;
            this.mSaveMask |= 4;
            if (!bl2) {
                string = this.getDefaultFlag(DEFAULT_TM_DEVICEID);
            }
            cUIDInfo = new CUIDInfo();
            object = DeviceId.getAndroidId(this.mContext);
            if (Build.VERSION.SDK_INT < 23) {
                String string2 = UUID.randomUUID().toString();
                object3 = string + (String)object + string2;
            } else {
                object3 = "com.baidu" + (String)object;
            }
            cUIDInfo.deviceId = MD5Util.toMd5(((String)object3).getBytes(), true);
            cUIDInfo.flag = string;
        }
        this.fixCUIDInfoByIE(cUIDInfo);
        this.writeJobThread(cUIDInfo);
        return cUIDInfo;
    }

    private synchronized void writeJobThread(CUIDInfo cUIDInfo) {
        Thread thread = new Thread(this.getWriteRunnable(cUIDInfo));
        thread.start();
    }

    private boolean fixCUIDInfoByIE(CUIDInfo cUIDInfo) {
        boolean bl;
        if (cUIDInfo.isIENormal()) {
            cUIDInfo.flag = "O";
            bl = true;
        } else if (cUIDInfo.isIENull()) {
            cUIDInfo.flag = "0";
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private Runnable getWriteRunnable(final CUIDInfo cUIDInfo) {
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                boolean bl;
                Object object2;
                String string = null;
                CUIDInfo cUIDInfo4 = new CUIDInfo();
                cUIDInfo4.flag = cUIDInfo.flag;
                cUIDInfo4.deviceId = cUIDInfo.deviceId;
                File file = new File(DeviceId.this.mContext.getFilesDir(), DeviceId.SELF_CUID_FILE);
                string = DeviceId.encryptCUIDInfo(cUIDInfo4.toPersitString());
                if (!file.exists()) {
                    DeviceId.this.writeToCuidFile(string);
                } else {
                    CUIDInfo cUIDInfo2 = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file)));
                    if (cUIDInfo2 != null) {
                        if (DeviceId.this.fixCUIDInfoByIE(cUIDInfo2)) {
                            DeviceId.this.writeToCuidFile(DeviceId.encryptCUIDInfo(cUIDInfo2.toPersitString()));
                        }
                    } else if (cUIDInfo2 == null) {
                        DeviceId.this.writeToCuidFile(string);
                    }
                }
                boolean bl2 = DeviceId.this.hasWriteSettingsPermission();
                if (bl2) {
                    String string2 = DeviceId.this.getSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2);
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, string);
                    } else {
                        object2 = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(string2));
                        if (object2 != null) {
                            if (DeviceId.this.fixCUIDInfoByIE((CUIDInfo)object2)) {
                                DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, DeviceId.encryptCUIDInfo(((CUIDInfo)object2).toPersitString()));
                            }
                        } else if (object2 == null) {
                            DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, string);
                        }
                    }
                }
                if (bl = DeviceId.this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    object2 = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
                    if (!((File)object2).exists()) {
                        DeviceId.setExternalV2DeviceId(string);
                    } else {
                        object = DeviceId.this.getCuidInfoFromExternalV2();
                        if (object != null) {
                            if (DeviceId.this.fixCUIDInfoByIE((CUIDInfo)object)) {
                                DeviceId.setExternalV2DeviceId(DeviceId.encryptCUIDInfo(((CUIDInfo)object).toPersitString()));
                            }
                        } else if (object == null) {
                            DeviceId.setExternalV2DeviceId(string);
                        }
                    }
                }
                if (bl2) {
                    int n;
                    object2 = DeviceId.this.getSystemSettingValue(DeviceId.KEY_FLAG);
                    int n2 = n = TextUtils.isEmpty((CharSequence)object2) ? 0 : ((String)object2).length();
                    if (CUIDInfo.isIENormal(n)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_FLAG, "O");
                    } else if (CUIDInfo.isIENull((String)object2)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_FLAG, "0");
                    }
                }
                if (bl && ((File)(object2 = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid"))).exists()) {
                    object = DeviceId.this.getDefaultFlag(DeviceId.DEFAULT_TM_DEVICEID);
                    CUIDInfo cUIDInfo3 = DeviceId.this.getExternalV1DeviceId((String)object);
                    if (cUIDInfo3 != null) {
                        if (DeviceId.this.fixCUIDInfoByIE(cUIDInfo3)) {
                            DeviceId.setExternalDeviceId(cUIDInfo3.flag, cUIDInfo3.deviceId);
                        }
                    } else if (cUIDInfo3 == null) {
                        // empty if block
                    }
                }
            }
        };
        return runnable;
    }

    private boolean hasWriteSettingsPermission() {
        return this.checkSelfPermission("android.permission.WRITE_SETTINGS");
    }

    private boolean checkSelfPermission(String string) {
        return this.mContext.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private CUIDInfo getCUidInfoFromSystemSettingV1() {
        String string = this.getSystemSettingValue(KEY_DEVICE_ID);
        String string2 = this.getSystemSettingValue(KEY_FLAG);
        return CUIDInfo.createCuidInfoFromV1Cache(string, string2);
    }

    private CUIDInfo getCuidInfoFromExternalV2() {
        String string;
        File file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
        if (file.exists() && !TextUtils.isEmpty((CharSequence)(string = DeviceId.getFileContent(file)))) {
            try {
                return CUIDInfo.createFromJson(new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes()))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private CUIDInfo getExternalV1DeviceId(String string) {
        String string2 = DEFAULT_TM_DEVICEID;
        String string3 = DEFAULT_TM_DEVICEID;
        File file = new File(Environment.getExternalStorageDirectory(), "baidu/.cuid");
        if (!file.exists()) {
            file = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid");
        }
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string4);
                stringBuilder.append("\r\n");
            }
            bufferedReader.close();
            String string5 = new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(stringBuilder.toString().getBytes())));
            String[] stringArray = string5.split("=");
            if (stringArray != null && stringArray.length == 2) {
                string3 = stringArray[0];
                string2 = stringArray[1];
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CUIDInfo.createCuidInfoFromV1Cache(string2, string3);
    }

    private static String encryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, string.getBytes()), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DeviceId.handleThrowable(unsupportedEncodingException);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return DEFAULT_TM_DEVICEID;
    }

    private static String decryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes())));
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return DEFAULT_TM_DEVICEID;
        }
    }

    private static void setExternalV2DeviceId(String string) {
        File file = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File file2 = new File(file, EXT_FILE_V2);
        try {
            Object object;
            if (file.exists() && !file.isDirectory()) {
                object = new Random();
                File file3 = null;
                File file4 = file.getParentFile();
                String string2 = file.getName();
                while ((file3 = new File(file4, string2 + ((Random)object).nextInt() + ".tmp")).exists()) {
                }
                file.renameTo(file3);
                file3.delete();
            }
            file.mkdirs();
            object = new FileWriter(file2, false);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setExternalDeviceId(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("=");
        stringBuilder.append(string2);
        File file = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File file2 = new File(file, EXT_FILE);
        try {
            Object object;
            Object object2;
            if (file.exists() && !file.isDirectory()) {
                object2 = new Random();
                object = null;
                File file3 = file.getParentFile();
                String string3 = file.getName();
                while (((File)(object = new File(file3, string3 + ((Random)object2).nextInt() + ".tmp"))).exists()) {
                }
                file.renameTo((File)object);
                ((File)object).delete();
            }
            file.mkdirs();
            object2 = new FileWriter(file2, false);
            object = Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, stringBuilder.toString().getBytes()), "utf-8");
            ((Writer)object2).write((String)object);
            ((OutputStreamWriter)object2).flush();
            ((OutputStreamWriter)object2).close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDefaultFlag(String string) {
        String string2 = "0";
        return string2;
    }

    private static String getBase64DecodeStr(String string) {
        return new String(Base64.decode(string.getBytes()));
    }

    static {
        sDataCuidInfoShable = true;
        String string = new String(Base64.decode(new byte[]{77, 122, 65, 121, 77, 84, 73, 120, 77, 68, 73, 61}));
        String string2 = new String(Base64.decode(new byte[]{90, 71, 108, 106, 100, 87, 82, 112, 89, 87, 73, 61}));
        AES_KEY = string + string2;
    }

    private static class CUIDInfo {
        public String deviceId;
        public String flag;
        public int version = 2;
        public int oldValueLength = 0;
        private static final int VERSION_DEF = 2;
        public static final String I_EMPTY = "0";
        public static final String I_FIXED = "O";
        public static final int PROTOCAL_MAX_LENGTH = 14;

        private CUIDInfo() {
        }

        public boolean isIENull() {
            return CUIDInfo.isIENull(this.flag);
        }

        public boolean isIENormal() {
            return CUIDInfo.isIENormal(this.oldValueLength);
        }

        public static boolean isIENull(String string) {
            return TextUtils.isEmpty((CharSequence)string);
        }

        public static boolean isIENormal(int n) {
            return n >= 14;
        }

        public static CUIDInfo createFromJson(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            try {
                int n;
                String string2;
                JSONObject jSONObject = new JSONObject(string);
                Iterator iterator = jSONObject.keys();
                String string3 = I_EMPTY;
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (DeviceId.getBase64DecodeStr(DeviceId.sDEncoded).equals(string2) || DeviceId.getBase64DecodeStr(DeviceId.sVEncoded).equals(string2)) continue;
                    string3 = jSONObject.optString(string2, I_EMPTY);
                }
                string2 = jSONObject.getString(DeviceId.getBase64DecodeStr(DeviceId.sDEncoded));
                int n2 = jSONObject.getInt(DeviceId.getBase64DecodeStr(DeviceId.sVEncoded));
                int n3 = n = TextUtils.isEmpty((CharSequence)string3) ? 0 : string3.length();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    CUIDInfo cUIDInfo = new CUIDInfo();
                    cUIDInfo.deviceId = string2;
                    cUIDInfo.version = n2;
                    cUIDInfo.oldValueLength = n;
                    if (cUIDInfo.oldValueLength < 14) {
                        String string4;
                        cUIDInfo.flag = string4 = TextUtils.isEmpty((CharSequence)string3) ? I_EMPTY : string3;
                    }
                    return cUIDInfo;
                }
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
            }
            return null;
        }

        private static CUIDInfo createCuidInfoFromV1Cache(String string, String string2) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                CUIDInfo cUIDInfo = new CUIDInfo();
                cUIDInfo.deviceId = string;
                int n = cUIDInfo.oldValueLength = TextUtils.isEmpty((CharSequence)string2) ? 0 : string2.length();
                if (cUIDInfo.oldValueLength < 14) {
                    String string3;
                    cUIDInfo.flag = string3 = TextUtils.isEmpty((CharSequence)string2) ? I_EMPTY : string2;
                }
                return cUIDInfo;
            }
            return null;
        }

        public String toPersitString() {
            try {
                return new JSONObject().put(DeviceId.getBase64DecodeStr(DeviceId.sDEncoded), (Object)this.deviceId).put(DeviceId.getBase64DecodeStr(DeviceId.sIEncoded), (Object)this.flag).put(DeviceId.getBase64DecodeStr(DeviceId.sVEncoded), this.version).toString();
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
                return null;
            }
        }

        public String getFinalCUID() {
            String string = this.flag;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = I_EMPTY;
            }
            String string2 = this.deviceId + "|" + string;
            return string2;
        }
    }

    static class TargetApiSupport {
        TargetApiSupport() {
        }

        @TargetApi(value=21)
        static boolean doChmodSafely(String string, int n) {
            try {
                Os.chmod((String)string, (int)n);
            }
            catch (ErrnoException errnoException) {
                DeviceId.handleThrowable(errnoException);
                return false;
            }
            catch (Exception exception) {
                DeviceId.handleThrowable(exception);
                return false;
            }
            return true;
        }
    }

    private static class CUIDBuddyInfo {
        public ApplicationInfo appInfo;
        public int priority = 0;
        public boolean sigMatched = false;
        public boolean isSelf = false;

        private CUIDBuddyInfo() {
        }
    }
}

