/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.ResponseHandler;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResponseHandler
extends ResponseHandler {
    private static final String TAG = "JsonResponseHandler";
    public static final String UTF8_BOM = "\ufeff";

    @Override
    public void onSuccess(int n, Map<String, List<String>> map, String string, byte[] byArray) {
        JSONObject jSONObject = null;
        try {
            jSONObject = this.parseResponse(byArray);
            if (jSONObject != null) {
                this.onSuccess(n, map, jSONObject);
            } else {
                this.onFailure(n, map, new JSONException("Unexpected response type JsonResponseHandler"), null);
            }
        }
        catch (JSONException jSONException) {
            this.onFailure(n, map, jSONException, (JSONObject)null);
            jSONException.printStackTrace();
        }
    }

    public void onSuccess(int n, Map<String, List<String>> map, JSONObject jSONObject) {
    }

    @Override
    public void onFailure(int n, Map<String, List<String>> map, String string, byte[] byArray, Throwable throwable) {
        if (byArray != null) {
            JSONObject jSONObject = null;
            try {
                jSONObject = this.parseResponse(byArray);
                if (jSONObject != null) {
                    this.onFailure(n, map, throwable, jSONObject);
                } else {
                    this.onFailure(n, map, new JSONException("Unexpected response type JsonResponseHandler"), null);
                }
            }
            catch (JSONException jSONException) {
                this.onFailure(n, map, jSONException, null);
            }
        }
    }

    public void onFailure(int n, Map<String, List<String>> map, Throwable throwable, JSONObject jSONObject) {
    }

    public void onFailure(int n, Map<String, List<String>> map, String string, Throwable throwable) {
    }

    private JSONObject parseResponse(byte[] byArray) throws JSONException {
        JSONObject jSONObject = null;
        if (null == byArray) {
            return null;
        }
        String string = JsonResponseHandler.getResponseString(byArray, "utf-8");
        if (string != null) {
            string = string.trim();
            jSONObject = new JSONObject(string);
        }
        return jSONObject;
    }

    private static String getResponseString(byte[] byArray, String string) {
        try {
            String string2;
            String string3 = string2 = byArray == null ? null : new String(byArray, string);
            if (string2 != null && string2.startsWith(UTF8_BOM)) {
                return string2.substring(1);
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtil.e(TAG, "Encoding response into string failed" + unsupportedEncodingException.toString());
            return null;
        }
    }
}

