/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.JsonResponseHandler;
import com.baidu.speech.utils.auth.SharedPreferencesUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetLicenseHandler
extends JsonResponseHandler {
    private static final String TAG = "GetLicenseHandler";
    private int statusCode = -2;
    private String mLicenseFile;
    private Context mContext;
    private String suffix = "_new";
    private String mAuthSN;

    public GetLicenseHandler(String string, String string2) {
        this.mLicenseFile = string;
        this.mAuthSN = string2;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    @Override
    public void onSuccess(int n, Map<String, List<String>> map, JSONObject jSONObject) {
        int n2;
        super.onSuccess(n, map, jSONObject);
        LogUtil.d(TAG, "getLicense resopse=" + jSONObject.toString());
        this.statusCode = n2 = jSONObject.optInt("err_no");
        LogUtil.d(TAG, " onSuccess statusCode: " + n + " errNo: " + n2);
        String string = jSONObject.optString("err_msg");
        long l = jSONObject.optLong("expires");
        long l2 = jSONObject.optLong("time");
        SharedPreferencesUtils.putLong(this.mContext, "getLicense_expires", l);
        SharedPreferencesUtils.putInt(this.mContext, "getLicense_err_no", n2);
        SharedPreferencesUtils.putString(this.mContext, "SN", this.mAuthSN);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 < 60000L && l3 - l2 > 0L) {
            SharedPreferencesUtils.putLong(this.mContext, "getLicense_time", l2);
        } else {
            SharedPreferencesUtils.putLong(this.mContext, "getLicense_time", l3);
        }
        String string2 = jSONObject.optString("license").replaceAll("license_begin|license_end", "");
        if (n2 == 0 && !string2.isEmpty()) {
            SharedPreferencesUtils.putBoolean(this.mContext, "isRegister", true);
            File file = new File(this.mLicenseFile);
            if (file.exists()) {
                File file2 = new File(this.mLicenseFile + this.suffix);
                boolean bl = this.writeStringToFile(this.mLicenseFile + this.suffix, string2);
                LogUtil.d(TAG, "isSave=" + bl);
                boolean bl2 = file.delete();
                LogUtil.d(TAG, "isDelete=" + bl2);
                boolean bl3 = file2.renameTo(file);
                LogUtil.d(TAG, "isRename=" + bl3);
            } else {
                boolean bl = this.writeStringToFile(this.mLicenseFile, string2);
                LogUtil.d(TAG, "isSave=" + bl);
            }
        }
        LogUtil.d(TAG, "getLicense statusCode: " + n + " err_msg: " + string + " err_no: " + n2);
    }

    @Override
    public void onFailure(int n, Map<String, List<String>> map, String string, Throwable throwable) {
        super.onFailure(n, map, string, throwable);
        LogUtil.d(TAG, " statusCode: " + n + " responseString: " + string);
    }

    @Override
    public void onFailure(int n, Map<String, List<String>> map, Throwable throwable, JSONObject jSONObject) {
        super.onFailure(n, map, throwable, jSONObject);
        LogUtil.d(TAG, "getLicense statusCode: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeStringToFile(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        if (null != string2) {
            File file = new File(string);
            if (!file.exists()) {
                File file2 = new File(file.getParent());
                file2.mkdirs();
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string2.getBytes("utf-8"));
            boolean bl = true;
            Object var7_9 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
            catch (Exception exception) {
                boolean bl2;
                try {
                    LogUtil.d(TAG, "download license success, write file failed");
                    this.statusCode = -1010;
                    exception.printStackTrace();
                    bl2 = false;
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return bl2;
            }
        }
        return false;
    }
}

