/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.CommonUtility;
import com.baidu.speech.utils.auth.ResponseHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileAsyncHttpResponseHandler
extends ResponseHandler {
    protected final File file;
    protected final boolean append;
    protected final boolean renameIfExists;
    protected File frontendFile;
    protected static final int BUFFER_SIZE = 4096;
    private static final String LOG_TAG = "FileAsyncHttpRH";

    public FileAsyncHttpResponseHandler(File file) {
        this(file, false);
    }

    public FileAsyncHttpResponseHandler(File file, boolean bl) {
        this(file, bl, false);
    }

    public FileAsyncHttpResponseHandler(File file, boolean bl, boolean bl2) {
        CommonUtility.asserts(file != null, "File passed into FileAsyncHttpResponseHandler constructor must not be null");
        if (!file.isDirectory() && !file.getParentFile().isDirectory()) {
            CommonUtility.asserts(file.getParentFile().mkdirs(), "Cannot create parent directories for requested File location");
        }
        if (file.isDirectory() && !file.mkdirs()) {
            LogUtil.d(LOG_TAG, "Cannot create directories for requested Directory location, might not be a problem");
        }
        this.file = file;
        this.append = bl;
        this.renameIfExists = bl2;
    }

    public FileAsyncHttpResponseHandler(Context context) {
        this.file = this.getTemporaryFile(context);
        this.append = false;
        this.renameIfExists = false;
    }

    public boolean deleteTargetFile() {
        return this.getTargetFile() != null && this.getTargetFile().delete();
    }

    protected File getTemporaryFile(Context context) {
        CommonUtility.asserts(context != null, "Tried creating temporary file without having Context");
        try {
            return File.createTempFile("temp_", "_handled", context.getCacheDir());
        }
        catch (IOException iOException) {
            LogUtil.e(LOG_TAG, "Cannot create temporary file");
            return null;
        }
    }

    protected File getOriginalFile() {
        CommonUtility.asserts(this.file != null, "Target file is null, fatal!");
        return this.file;
    }

    public File getTargetFile() {
        if (this.frontendFile == null) {
            this.frontendFile = this.getOriginalFile().isDirectory() ? this.getTargetFileByParsingURL() : this.getOriginalFile();
        }
        return this.frontendFile;
    }

    protected File getTargetFileByParsingURL() {
        CommonUtility.asserts(this.getOriginalFile().isDirectory(), "Target file is not a directory, cannot proceed");
        CommonUtility.asserts(this.getRequestURI() != null, "RequestURI is null, cannot proceed");
        String string = this.getRequestURI().toString();
        String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
        File file = new File(this.getOriginalFile(), string2);
        if (file.exists() && this.renameIfExists) {
            String string3 = !string2.contains(".") ? string2 + " (%d)" : string2.substring(0, string2.lastIndexOf(46)) + " (%d)" + string2.substring(string2.lastIndexOf(46), string2.length());
            int n = 0;
            while (true) {
                if (!(file = new File(this.getOriginalFile(), String.format(string3, n))).exists()) {
                    return file;
                }
                ++n;
            }
        }
        return file;
    }

    @Override
    public void onSuccess(int n, Map<String, List<String>> map, String string, byte[] byArray) {
        this.onSuccess(n, map, this.getTargetFile());
    }

    public abstract void onSuccess(int var1, Map<String, List<String>> var2, File var3);

    @Override
    public void onFailure(int n, Map<String, List<String>> map, String string, byte[] byArray, Throwable throwable) {
        this.onFailure(n, map, throwable, this.getTargetFile());
    }

    public abstract void onFailure(int var1, Map<String, List<String>> var2, Throwable var3, File var4);

    public void onProgress(long l, long l2) {
    }
}

