/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.Memorizer;
import com.baidu.speech.utils.auth.OfflineAuth;
import com.baidu.speech.utils.auth.OfflineParams;
import com.baidu.speech.utils.auth.StringTool;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthClient {
    private static volatile AuthClient mInstance = null;
    private Memorizer<OfflineAuth, OfflineAuth.OfflineResult> mOfflineMemorizer = new Memorizer();
    private static final String TAG = "AuthClient";
    private Context context;

    private AuthClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthClient getInstance() {
        if (mInstance != null) return mInstance;
        Class<AuthClient> clazz = AuthClient.class;
        synchronized (AuthClient.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AuthClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public OfflineAuth.OfflineResult authOffline(OfflineParams offlineParams) {
        OfflineAuth.OfflineResult offlineResult = new OfflineAuth.OfflineResult();
        offlineResult.setAppId(offlineParams.getAppCode());
        offlineResult.setAuthSN(offlineParams.getAuthSN());
        try {
            offlineResult = this.executeTaskAndGet(new OfflineWork(offlineParams), 2000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            offlineResult.setError(-105);
        }
        catch (ExecutionException executionException) {
            offlineResult.setError(-106);
        }
        catch (TimeoutException timeoutException) {
            offlineResult.setError(-107);
        }
        catch (CancellationException cancellationException) {
            offlineResult.setError(-108);
        }
        return offlineResult;
    }

    private String getDefaultLicenseFilePath() {
        String string = this.context.getFilesDir().getAbsolutePath() + "/";
        String string2 = "asr_license";
        String string3 = null;
        string3 = string.endsWith(File.separator) ? string + string2 : string + File.separator + string2;
        return string3;
    }

    private <T> T executeTaskAndGet(Callable<T> callable, long l) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<T> futureTask = this.executeTask(callable);
        return futureTask.get(l, TimeUnit.MILLISECONDS);
    }

    private <T> FutureTask<T> executeTask(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        Thread thread = new Thread(futureTask);
        thread.setName("bdtts-AuthClient");
        thread.start();
        return futureTask;
    }

    public void clear() {
        if (this.mOfflineMemorizer != null) {
            this.mOfflineMemorizer.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OfflineWork
    implements Callable<OfflineAuth.OfflineResult> {
        private OfflineParams mParams;

        public OfflineWork(OfflineParams offlineParams) {
            this.mParams = offlineParams;
        }

        @Override
        public OfflineAuth.OfflineResult call() throws Exception {
            Comparable<File> comparable;
            OfflineAuth.OfflineResult offlineResult = new OfflineAuth.OfflineResult();
            String string = this.mParams.getAppCode();
            String string2 = this.mParams.getAuthSN();
            String string3 = this.mParams.getLicenseFilePath();
            if (StringTool.isEmpty(string3)) {
                string3 = AuthClient.this.getDefaultLicenseFilePath();
            } else {
                comparable = new File(string3);
                if (comparable == null || !((File)comparable).exists()) {
                    string3 = AuthClient.this.getDefaultLicenseFilePath();
                }
            }
            LogUtil.d(AuthClient.TAG, "appCode=" + string + " SN=" + string2);
            LogUtil.d(AuthClient.TAG, "licenseFilePath=" + string3);
            comparable = new OfflineAuth();
            ((OfflineAuth)comparable).setContext(AuthClient.this.context);
            ((OfflineAuth)comparable).setAuthSN(string2);
            ((OfflineAuth)comparable).setAppCode(string);
            ((OfflineAuth)comparable).setLicenseFilePath(string3);
            return (OfflineAuth.OfflineResult)AuthClient.this.mOfflineMemorizer.memory(comparable);
        }
    }
}

