/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.baidu.speech.EventListener;
import com.baidu.speech.audio.MicrophoneServer;
import com.baidu.speech.core.BDSErrorDescription;
import com.baidu.speech.core.BDSMessage;
import com.baidu.speech.core.BDSParamBase;
import com.baidu.speech.core.BDSSDKLoader;
import com.baidu.speech.utils.AsrError;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.Policy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WakeUpControl
implements BDSSDKLoader.BDSCoreEventListener {
    private static final String TAG = "WakeUpControl";
    private static String WAK_CMD_CONFIG = "wak.config";
    private static String WAK_CMD_START = "wak.start";
    private static String WAK_CMD_DATA = "wak.data";
    private static String WAK_CMD_STOP = "wak.stop";
    private static String WAK_CMD_LOAD_ENGINE = "wak.load";
    private static String WAK_CMD_UNLOAD_ENGINE = "wak.unload";
    private static String ASR_PARAM_KEY_PLATFORM = "asr_param_key_platform.string";
    private static String ASR_PARAM_KEY_SDK_VERSION = "asr_param_key_sdk_version.string";
    private static String ASR_PARAM_KEY_OFFLINE_APP_CODE = "offline_param_key_app_code.string";
    private static String MIC_PARAM_KEY_AUDIO_FILE_PATH = "mic_audio_file_path.string";
    private static String OFFLINE_PARAM_KEY_LICENSE_FILE_PATH = "offline_param_key_license_filepath.string";
    private static String WP_PARAM_KEY_WAKEUP_WORDS = "wakeup_param_key_words.vector<string>";
    private static String WP_PARAM_KEY_WAKEUP_DAT_FILE_PATH = "wakeup_param_key_dat_filepath.string";
    private static String WP_PARAM_KEY_WAKEUP_KWD = "wakeup_param_key_kwd.bool";
    private static String WP_PARAM_KEY_WAKEUP_MODE = "wakeup_param_key_mode.int";
    private static String WP_PARAM_KEY_WAKEUP_WORDS_FILE_PATH = "wakeup_param_key_words_filepath.string";
    private static String COMMON_PARAM_KEY_DEBUG_LOG_LEVEL = "common_param_key_debug_log_level.int";
    private static String WP_PARAM_KEY_WAKEUP_ACCEPT_AUDIO_DATA = "wakeup_param_key_accept_audio_data.bool";
    private static String MIC_PARAM_KEY_SOCKET_PORT = "mic_param_key_socket_port.int";
    private static String WP_PARAM_KEY_ENABLE_VAD = "wakeup_param_key_enable_vad.bool";
    private static String WP_PARAM_KEY_VAD_DAT_FILE_PATH = "wakeup_param_key_vad_dat_file_path.string";
    private static String WP_PARAM_KEY_ENABLE_MODEL_VAD = "wakeup_param_key_mode.int";
    private static final int EWakeupEngineWorkStatusStarted = 0;
    private static final int EWakeupEngineWorkStatusReadyed = 1;
    private static final int EWakeupEngineWorkStatusStopped = 2;
    private static final int EWakeupEngineWorkStatusLoaded = 3;
    private static final int EWakeupEngineWorkStatusUnLoaded = 4;
    private static final int EWakeupEngineWorkStatusTriggered = 5;
    private static final int EWakeupEngineWorkStatusError = 6;
    private static final int EWakeupEngineWorkStatusNewData = 7;
    private EventListener mListener;
    private Context context;
    private JSONObject mParams;
    private String outFile = null;
    private BDSSDKLoader.BDSSDKInterface m_Wakeupcore;
    private boolean mFeedBackAudio;
    private boolean mIsWorking = false;

    public WakeUpControl(Context context) throws Exception {
        this.context = context;
        try {
            BDSSDKLoader.loadLibraries();
        }
        catch (Throwable throwable) {
            throw new Exception(this.generateErrorResult(5001));
        }
        try {
            this.m_Wakeupcore = BDSSDKLoader.getSDKObjectForSDKType("WakeupCore", context);
            if (this.m_Wakeupcore == null) {
                throw new Exception("ASR core support is not linked in package");
            }
            if (!this.m_Wakeupcore.instanceInitialized()) {
                throw new Exception("Failed initialize ASR Core native layer");
            }
            this.m_Wakeupcore.setListener(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Exception("Can't found ASR Core native method");
        }
    }

    public BDSErrorDescription postEvent(String string, String string2) {
        BDSErrorDescription bDSErrorDescription = null;
        boolean bl = false;
        LogUtil.v(TAG, " wakeup postEvent  cmd:" + string + " params:" + string2);
        try {
            bl = this.m_Wakeupcore.instanceInitialized();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -1;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: ASR Core native layer is not initialized!";
            return bDSErrorDescription;
        }
        if (!bl) {
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -1;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: ASR Core native layer is not initialized!";
            return bDSErrorDescription;
        }
        try {
            this.mParams = string2 == null || string2.equals("") ? new JSONObject() : new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            this.mParams = new JSONObject();
        }
        if (string.equals("wp.start")) {
            if (this.mIsWorking) {
                return bDSErrorDescription;
            }
            this.mIsWorking = true;
            try {
                if (!this.mParams.has("audio.socketport")) {
                    String string3 = this.mParams.optString("infile");
                    int n = 1;
                    if (this.mParams.has("audio.source")) {
                        n = this.mParams.optInt("audio.source");
                    }
                    int n2 = MicrophoneServer.create(string3, n);
                    this.mParams.put("audio.socketport", n2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.initWp(bDSErrorDescription, this.mParams);
            this.postEvent(bDSErrorDescription, WAK_CMD_LOAD_ENGINE);
            this.clearOutFile();
        } else if (string.equals("wp.stop")) {
            this.postEvent(bDSErrorDescription, WAK_CMD_UNLOAD_ENGINE);
        }
        return this.postEvent(bDSErrorDescription, string);
    }

    private BDSErrorDescription initWp(BDSErrorDescription bDSErrorDescription, JSONObject jSONObject) {
        int n;
        String string = null;
        try {
            ApplicationInfo applicationInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            string = null == applicationInfo.metaData ? null : applicationInfo.metaData.getInt("com.baidu.speech.APP_ID") + "";
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        String string2 = jSONObject.optString("appid", string);
        JSONArray jSONArray = jSONObject.optJSONArray("words");
        Vector<String> vector = new Vector<String>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    vector.add(jSONArray.getString(i));
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        String string3 = String.format("%s/%s", this.context.getApplicationInfo().nativeLibraryDir, "libbd_easr_s1_merge_normal_20151216.dat.so");
        String string4 = jSONObject.optString("wakeup_dat_filepath", jSONObject.optString("wp.res-file", jSONObject.optString("res-file", string3)));
        String string5 = jSONObject.optString("wp.kws-file", jSONObject.optString("kws-file"));
        String string6 = jSONObject.optString("infile");
        String string7 = jSONObject.optString("decoder-offline.license-file-path", jSONObject.optString("license-file-path", jSONObject.optString("license")));
        int n2 = jSONObject.optInt("log_level", -1);
        if (Log.isLoggable((String)"BDSPEECH", (int)3)) {
            n2 = 5;
        } else if (Log.isLoggable((String)"BDSPEECH", (int)2)) {
            n2 = 6;
        }
        this.mFeedBackAudio = jSONObject.optBoolean("accept-audio-data", false);
        this.outFile = jSONObject.optString("outfile");
        BDSMessage bDSMessage = new BDSMessage();
        bDSMessage.m_messageName = WAK_CMD_CONFIG;
        bDSMessage.m_messageParams = new HashMap();
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_APP_CODE, BDSParamBase.objectParam(string2, "java.lang.String"));
        bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_DAT_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string4), "java.lang.String"));
        bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_WORDS, BDSParamBase.objectParam(vector, "java.util.Vector;"));
        bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_WORDS_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string5), "java.lang.String"));
        bDSMessage.m_messageParams.put(OFFLINE_PARAM_KEY_LICENSE_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string7), "java.lang.String"));
        bDSMessage.m_messageParams.put(MIC_PARAM_KEY_AUDIO_FILE_PATH, BDSParamBase.objectParam(string6, "java.lang.String"));
        boolean bl = jSONObject.optBoolean("wp.vad_enable", false);
        if (bl) {
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_ENABLE_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(2));
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_VAD_DAT_FILE_PATH, BDSParamBase.objectParam(this.context.getApplicationInfo().nativeLibraryDir, "java.lang.String"));
        } else {
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_ENABLE_VAD, BDSParamBase.boolParam(false));
        }
        boolean bl2 = jSONObject.optBoolean("wp.kwd_enable", false);
        if (bl2) {
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_KWD, BDSParamBase.boolParam(true));
        }
        int n3 = jSONObject.optInt("audio.socketport");
        bDSMessage.m_messageParams.put(MIC_PARAM_KEY_SOCKET_PORT, BDSParamBase.intParam(n3));
        if (n2 != -1) {
            bDSMessage.m_messageParams.put(COMMON_PARAM_KEY_DEBUG_LOG_LEVEL, BDSParamBase.intParam(n2));
        }
        bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_ACCEPT_AUDIO_DATA, BDSParamBase.boolParam(this.mFeedBackAudio));
        boolean bl3 = jSONObject.optBoolean("accept-audio-volume", true);
        if (!bl3) {
            bDSMessage.m_messageParams.put("mic_accept_audio_volume.bool", BDSParamBase.boolParam(bl3));
        }
        if ((n = jSONObject.optInt("wp.mode", 0)) > 0) {
            bDSMessage.m_messageParams.put(WP_PARAM_KEY_WAKEUP_MODE, BDSParamBase.intParam(n));
        }
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam("Android", "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam("C++ ASR core", "java.lang.String"));
        try {
            int n4 = this.m_Wakeupcore.postMessage(bDSMessage);
            if (n4 != 0) {
                bDSErrorDescription = new BDSErrorDescription();
                bDSErrorDescription.errorCode = -2;
                bDSErrorDescription.errorDomain = 1;
                bDSErrorDescription.errorDescription = "JNI: readyParamsWpStart Call to Native layer returned error! err( " + n4 + " )";
                return bDSErrorDescription;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -2;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: readyParamsWpStart Call to Native layer returned error! err";
            return bDSErrorDescription;
        }
        return bDSErrorDescription;
    }

    private BDSErrorDescription postEvent(BDSErrorDescription bDSErrorDescription, String string) {
        BDSMessage bDSMessage = new BDSMessage();
        bDSMessage.m_messageName = string.contains("wp") ? string.replace("wp", "wak") : string;
        bDSMessage.m_messageParams = new HashMap();
        String string2 = this.mParams.optString("decoder-server.app", Policy.app(this.context));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam("Android", "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam("C++ ASR core", "java.lang.String"));
        LogUtil.v(TAG, " wakeup postEvent to c++  cmd:" + string + " Message:" + bDSMessage.toString());
        try {
            int n = this.m_Wakeupcore.postMessage(bDSMessage);
            if (n != 0) {
                bDSErrorDescription = new BDSErrorDescription();
                bDSErrorDescription.errorCode = -2;
                bDSErrorDescription.errorDomain = 1;
                bDSErrorDescription.errorDescription = "JNI: readyParamsAsrStart Call to Native layer returned error! err";
                return bDSErrorDescription;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -2;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: readyParamsWpStart Call to Native layer returned error! err";
            return bDSErrorDescription;
        }
        return bDSErrorDescription;
    }

    public void setListener(EventListener eventListener) {
        this.mListener = eventListener;
    }

    public void receiveCoreEvent(BDSMessage bDSMessage, BDSSDKLoader.BDSSDKInterface bDSSDKInterface) {
        if (this.mListener != null && bDSMessage != null) {
            this.asrCallBack(bDSMessage, this.mListener);
        }
    }

    private void asrCallBack(BDSMessage bDSMessage, EventListener eventListener) {
        if (bDSMessage.m_messageName.equals("WAKEUP.callback")) {
            int n = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.wak.status.int")).iValue;
            LogUtil.v(TAG, "WPCallBack:" + bDSMessage.toString());
            switch (n) {
                case 0: {
                    eventListener.onEvent("wp.enter", null, null, 0, 0);
                    break;
                }
                case 1: {
                    eventListener.onEvent("wp.ready", null, null, 0, 0);
                    break;
                }
                case 2: {
                    this.mIsWorking = false;
                    eventListener.onEvent("wp.exit", null, null, 0, 0);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.wak.result.string")).iValue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("word", string);
                    hashMap.put("errorCode", 0);
                    hashMap.put("errorDesc", "wakup success");
                    eventListener.onEvent("wp.data", new JSONObject(hashMap).toString(), null, 0, 0);
                    break;
                }
                case 6: {
                    this.mIsWorking = false;
                    int n2 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.domain.int16_t")).iValue;
                    String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.error.desc.string")).iValue;
                    int n3 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.code.int16_t")).iValue;
                    String string2 = "";
                    try {
                        string2 = this.generateErrorResult(n2, n3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    eventListener.onEvent("wp.error", string2, null, 0, 0);
                    break;
                }
                case 7: {
                    byte[] byArray = bDSMessage.m_messageData;
                    if (this.mFeedBackAudio && byArray != null) {
                        eventListener.onEvent("wp.audio", null, byArray, 0, byArray.length);
                    }
                    this.saveOutFile(byArray);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSourceFromUri(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (new File(string).exists()) {
            return string;
        }
        InputStream inputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            Pattern pattern = Pattern.compile("(.*?)://(.*)");
            Matcher matcher = pattern.matcher(string);
            String string2 = null;
            if (matcher.find()) {
                Object object;
                String string3 = matcher.group(1);
                string2 = matcher.group(2);
                if (string3.equalsIgnoreCase("file")) {
                    inputStream = new FileInputStream(string2);
                } else if (string3.equalsIgnoreCase("asset") || string3.equalsIgnoreCase("assets")) {
                    object = string2.startsWith("/") ? "" : "/";
                    inputStream = this.getClass().getResourceAsStream("/assets" + (String)object + string2);
                } else if (string3.equalsIgnoreCase("res")) {
                    inputStream = this.getClass().getResourceAsStream(string2);
                }
                if (null == inputStream) {
                    throw new IOException("bad data source");
                }
                object = new byte[1024];
                String string4 = this.context.getFilesDir().getAbsolutePath() + string2;
                File file = new File(string4);
                randomAccessFile = new RandomAccessFile(file, "rw");
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > 0) {
                    randomAccessFile.write((byte[])object, 0, n);
                }
                String string5 = file.getAbsolutePath();
                return string5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private File getDiskCacheDir(Context context) {
        return context.getCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutFile(byte[] byArray) {
        if (this.outFile != null && !this.outFile.equals("") && byArray != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.outFile, true);
                ((OutputStream)fileOutputStream).write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    fileOutputStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOutFile() {
        if (this.outFile != null && !this.outFile.equals("")) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.outFile);
                ((OutputStream)fileOutputStream).write("".getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    fileOutputStream = null;
                }
            }
        }
    }

    private String generateErrorResult(int n, int n2) {
        int n3 = -1;
        String string = "";
        if (AsrError.getDescFromCode(n2) != null) {
            n3 = n2;
        } else if (n == 38) {
            if (1 == n2) {
                n3 = 11001;
            } else if (2 == n2) {
                n3 = 11002;
            } else if (3 == n2) {
                n3 = 11003;
            } else if (4 == n2) {
                n3 = 11004;
            } else if (5 == n2) {
                n3 = 11005;
            } else if (6 == n2) {
                n3 = 11006;
            } else if (7 == n2) {
                n3 = 11007;
            } else if (8 == n2) {
                n3 = 11008;
            } else if (9 == n2) {
                n3 = 11009;
            } else if (10 == n2) {
                n3 = 11010;
            } else if (11 == n2) {
                n3 = 11011;
            }
        } else if (n == 20 && 1 == n2) {
            n3 = 3100;
        }
        return this.generateErrorResult(n3);
    }

    private String generateErrorResult(int n) {
        String string = AsrError.getDescFromCode(n);
        int n2 = n / 1000;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", n2);
            jSONObject.put("desc", (Object)string);
            jSONObject.put("sub_error", n);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DebugLogLevel {
        EVRDebugLogLevelOff,
        EVRDebugLogLevelFatal,
        EVRDebugLogLevelError,
        EVRDebugLogLevelWarning,
        EVRDebugLogLevelInformation,
        EVRDebugLogLevelDebug,
        EVRDebugLogLevelTrace;

    }
}

