/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManager;
import com.baidu.speech.asr.ASRListener;
import com.baidu.speech.asr.ASRMessage;
import com.baidu.speech.asr.AnalysisInterceptor;
import com.baidu.speech.core.ASREngine;
import com.baidu.speech.utils.LogUtil;
import java.util.ArrayList;

public class EventManagerAsr
implements EventManager,
ASRListener {
    private static final String VERSION = "3.4.4.106";
    private static final String TAG = "EventManagerAsr";
    private Context mcontext;
    private ArrayList<EventListener> listeners = new ArrayList();
    private ASREngine mEnginer;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ArrayList<ASRMessage> mMessageQueue = new ArrayList();
    private Exception initException = null;

    public EventManagerAsr(Context context) {
        this.mcontext = context;
        try {
            this.mEnginer = new ASREngine(context);
            this.mMessageQueue.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.initException = exception;
        }
    }

    public void send(String string, String string2, byte[] byArray, int n, int n2) {
        LogUtil.v(TAG, "send cmd : " + string + " send params : " + string2);
        AnalysisInterceptor.getInstance(this.mcontext).send(string, string2, byArray, n, n2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (string.equals("asr.start") && this.initException != null) {
            for (final EventListener eventListener : this.listeners) {
                this.mHandler.post(new Runnable(){

                    public void run() {
                        if (eventListener != null) {
                            LogUtil.v(EventManagerAsr.TAG, "onEvent mCommand : asr.finish and asr.exit  onEvent mParam : " + EventManagerAsr.this.initException.getMessage());
                            eventListener.onEvent("asr.finish", EventManagerAsr.this.initException.getMessage(), null, 0, 0);
                            eventListener.onEvent("asr.exit", EventManagerAsr.this.initException.getMessage(), null, 0, 0);
                        }
                    }
                });
            }
        }
        if (this.mEnginer != null) {
            this.mEnginer.setListener(this);
            this.mEnginer.postEvent(string, string2);
        }
    }

    public void registerListener(EventListener eventListener) {
        if (eventListener != null && !this.listeners.contains(eventListener)) {
            this.listeners.add(eventListener);
        }
    }

    public void unregisterListener(EventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public static final String getSDKVersion() {
        return VERSION;
    }

    public void onEvent(String string, String string2, byte[] byArray, int n, int n2) {
        this.onEvent(string, string2, byArray, n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String string, String string2, byte[] byArray, int n, int n2, boolean bl) {
        AnalysisInterceptor.getInstance(this.mcontext).onEvent(string, string2, byArray, n, n2, bl);
        this.updateMessageQueue(new ASRMessage(string, string2, byArray, n, n2, bl));
        ArrayList<EventListener> arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList<ASRMessage> arrayList2 = this.mMessageQueue;
            synchronized (arrayList2) {
                if (this.mMessageQueue.size() <= 0) {
                    return;
                }
                final ASRMessage aSRMessage = this.mMessageQueue.remove(0);
                if (aSRMessage != null) {
                    for (final EventListener eventListener : this.listeners) {
                        this.mHandler.post(new Runnable(){

                            public void run() {
                                if (eventListener != null) {
                                    LogUtil.v(EventManagerAsr.TAG, "onEvent mCommand : " + aSRMessage.mCommand + " onEvent mParam : " + aSRMessage.mParam);
                                    eventListener.onEvent(aSRMessage.mCommand, aSRMessage.mParam, aSRMessage.mData, aSRMessage.mOffset, aSRMessage.mLength);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageQueue(ASRMessage aSRMessage) {
        ArrayList<ASRMessage> arrayList = this.mMessageQueue;
        synchronized (arrayList) {
            if (aSRMessage.mIsVip) {
                this.mMessageQueue.clear();
            }
            this.mMessageQueue.add(aSRMessage);
        }
    }
}

