/*
 * Decompiled with CFR 0.152.
 */
package com.fm.openinstall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.openinstall.sdk.aj;
import io.openinstall.sdk.al;
import io.openinstall.sdk.ap;
import io.openinstall.sdk.ay;
import io.openinstall.sdk.bv;
import io.openinstall.sdk.bw;
import io.openinstall.sdk.p;

public final class OpenInstallHelper {
    private OpenInstallHelper() {
    }

    @Nullable
    public static String checkGaid(@NonNull Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (bw.a) {
                bw.b("\u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u8c03\u7528", new Object[0]);
            }
            return null;
        }
        aj.a a2 = aj.a(context.getApplicationContext());
        if (a2 != null) {
            return a2.a();
        }
        return null;
    }

    @Nullable
    public static String checkOaid(@NonNull Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            if (bw.a) {
                bw.b("\u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u8c03\u7528", new Object[0]);
            }
            return null;
        }
        al al2 = new al();
        al2.a(context.getApplicationContext());
        return al2.a();
    }

    public static boolean isTrackData(@Nullable ClipData clipData) {
        ap ap2 = ap.a(clipData);
        if (ap2 == null) {
            return false;
        }
        return ap2.c(1) || ap2.c(2);
    }

    public static boolean checkSimulator(@NonNull Context context) {
        return p.a().a(context);
    }

    public static boolean isSchemeWakeup(@Nullable Intent intent) {
        if (intent == null || intent.getData() == null || intent.getAction() == null) {
            return false;
        }
        String string = intent.getAction();
        String string2 = intent.getData().getHost();
        if (TextUtils.isEmpty((CharSequence)string2) || !string.equals("android.intent.action.VIEW")) {
            return false;
        }
        for (String string3 : ay.c()) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLauncherFromYYB(@NonNull Activity activity, @Nullable Intent intent) {
        boolean bl2 = false;
        if (activity == null || intent == null || TextUtils.isEmpty((CharSequence)intent.getAction()) || intent.getCategories() == null) {
            return false;
        }
        if (intent.getAction().equals("android.intent.action.MAIN") && intent.getCategories().contains("android.intent.category.LAUNCHER") && Build.VERSION.SDK_INT >= 22) {
            Uri uri = activity.getReferrer();
            if (uri == null) {
                return false;
            }
            String string = uri.getAuthority();
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            if (string.equalsIgnoreCase(bv.o) || string.equalsIgnoreCase(bv.p) || string.equalsIgnoreCase(bv.n)) {
                bl2 = true;
            }
            if (string.equalsIgnoreCase(bv.q) || string.equalsIgnoreCase(bv.r) || string.equalsIgnoreCase(bv.s)) {
                bl2 = true;
            }
        }
        return bl2;
    }
}

