/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.geolocation;

import android.os.SystemClock;
import android.text.TextUtils;
import java.util.Locale;

public class TencentGeofence {
    private final double a;
    private final double b;
    private final float c;
    private final long d;
    private final String e;
    private final long f;

    private TencentGeofence(double d2, double d3, float f2, long l2, String string) {
        this.a = d2;
        this.b = d3;
        this.c = f2;
        this.f = l2;
        this.d = SystemClock.elapsedRealtime() + l2;
        this.e = string;
    }

    public double getLatitude() {
        return this.a;
    }

    public double getLongitude() {
        return this.b;
    }

    public float getRadius() {
        return this.c;
    }

    public long getExpireAt() {
        return this.d;
    }

    public long getDuration() {
        return this.f;
    }

    public String getTag() {
        return this.e;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.a);
        int n2 = 31 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.b);
        return (n2 * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (this.e == null ? 0 : this.e.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (TencentGeofence)object;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(((TencentGeofence)object).a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(((TencentGeofence)object).b)) {
            return false;
        }
        return !(this.e == null ? ((TencentGeofence)object).e != null : !this.e.equals(((TencentGeofence)object).e));
    }

    public String toString() {
        return String.format(Locale.US, "TencentGeofence[tag=%s, type=%s, loc=(%.6f, %.6f), radius=%.2fm life=%.2fs]", this.e, "CIRCLE", this.a, this.b, Float.valueOf(this.c), (double)(this.d - SystemClock.elapsedRealtime()) / 1000.0);
    }

    /* synthetic */ TencentGeofence(double d2, double d3, float f2, long l2, String string, byte by2) {
        this(d2, d3, f2, l2, string);
    }

    public static class Builder {
        private double a;
        private double b;
        private float c;
        private long d;
        private String e;

        public Builder setCircularRegion(double d2, double d3, float f2) {
            if (f2 <= 0.0f) {
                throw new IllegalArgumentException("invalid radius: " + f2);
            }
            if (d2 > 90.0 || d2 < -90.0) {
                throw new IllegalArgumentException("invalid latitude: " + d2);
            }
            if (d3 > 180.0 || d3 < -180.0) {
                throw new IllegalArgumentException("invalid longitude: " + d3);
            }
            this.a = d2;
            this.b = d3;
            this.c = f2;
            return this;
        }

        public Builder setExpirationDuration(long l2) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("invalid duration: " + l2);
            }
            this.d = l2;
            return this;
        }

        public Builder setTag(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new NullPointerException();
            }
            this.e = string;
            return this;
        }

        public TencentGeofence build() {
            return new TencentGeofence(this.a, this.b, this.c, this.d, this.e, 0);
        }
    }
}

