/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.simple.cache;

import android.text.TextUtils;
import com.meihu.kalle.Headers;
import com.meihu.kalle.secure.Encryption;
import com.meihu.kalle.secure.Secret;
import com.meihu.kalle.simple.cache.Cache;
import com.meihu.kalle.simple.cache.CacheStore;
import com.meihu.kalle.util.IOUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.GeneralSecurityException;

public class DiskCacheStore
implements CacheStore {
    private Secret mSecret;
    private String mDirectory;

    public static Builder newBuilder(String string) {
        return new Builder(string);
    }

    private DiskCacheStore(Builder builder) {
        this.mDirectory = builder.mDirectory;
        this.mSecret = Encryption.createSecret(TextUtils.isEmpty((CharSequence)builder.mPassword) ? this.mDirectory : builder.mPassword);
    }

    private String encrypt(String string) throws GeneralSecurityException {
        return this.mSecret.encrypt(string);
    }

    private String decrypt(String string) throws GeneralSecurityException {
        return this.mSecret.decrypt(string);
    }

    private String uniqueKey(String string) {
        return Encryption.getMD5ForString(this.mDirectory + string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cache get(String var1_1) {
        block11: {
            block10: {
                var1_1 = this.uniqueKey(var1_1);
                var2_2 = null;
                var3_3 = v0;
                if (!new File(this.mDirectory, var1_1).exists() || var3_3.isDirectory()) break block10;
                var4_4 = v1;
                v1 = new Cache();
                var5_5 = v2;
                v3 = var4_4;
                v4 = this;
                v5 = var5_5;
                v6 = var4_4;
                v7 = this;
                v8 = var5_5;
                v9 = var4_4;
                v10 = this;
                v11 = var5_5;
                v12 = var4_4;
                v13 = this;
                v14 = var5_5;
                v15 = v14;
                v14(new FileReader(var3_3));
                try {
                    v12.setCode(Integer.parseInt(v13.decrypt(v15.readLine())));
                    v9.setHeaders(Headers.fromJSONString(v10.decrypt(v11.readLine())));
                    v6.setBody(Encryption.hexToByteArray(v7.decrypt(v8.readLine())));
                    v3.setExpires(Long.parseLong(v4.decrypt(v5.readLine())));
                }
                catch (Throwable v16) {
                    var2_2 = var5_5;
                    break block11;
                }
                catch (Exception v17) {
                    var2_2 = var5_5;
                    ** GOTO lbl-1000
                }
                IOUtils.closeQuietly(v2);
                return v1;
            }
            IOUtils.closeQuietly(var2_2);
            return null;
            catch (Throwable v16) {
                break block11;
            }
            catch (Exception v18) {}
lbl-1000:
            // 2 sources

            {
                v19 = var2_2;
                IOUtils.delFileOrFolder(new File(this.mDirectory, var1_1));
            }
            IOUtils.closeQuietly(v19);
            return null;
        }
        IOUtils.closeQuietly(var2_2);
        throw v16;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean replace(String string, Cache cache) {
        Throwable throwable2;
        BufferedWriter bufferedWriter;
        block11: {
            block8: {
                File file;
                block10: {
                    File file2;
                    block9: {
                        string = this.uniqueKey(string);
                        bufferedWriter = null;
                        if (TextUtils.isEmpty((CharSequence)string) || cache == null) break block8;
                        if (IOUtils.createFolder(this.mDirectory)) break block9;
                        IOUtils.closeQuietly(bufferedWriter);
                        return false;
                    }
                    file = file2;
                    if (IOUtils.createNewFile(new File(this.mDirectory, string))) break block10;
                    IOUtils.closeQuietly(bufferedWriter);
                    return false;
                }
                bufferedWriter = IOUtils.toBufferedWriter(new FileWriter(file));
                BufferedWriter bufferedWriter2 = bufferedWriter;
                BufferedWriter bufferedWriter3 = bufferedWriter;
                BufferedWriter bufferedWriter4 = bufferedWriter;
                bufferedWriter4.write(this.encrypt(Integer.toString(cache.getCode())));
                bufferedWriter4.newLine();
                bufferedWriter3.write(this.encrypt(Headers.toJSONString(cache.getHeaders())));
                bufferedWriter3.newLine();
                bufferedWriter2.write(this.encrypt(Encryption.byteArrayToHex(cache.getBody())));
                bufferedWriter2.newLine();
                bufferedWriter.write(this.encrypt(Long.toString(cache.getExpires())));
                bufferedWriter.flush();
                IOUtils.closeQuietly(bufferedWriter);
                return true;
            }
            IOUtils.closeQuietly(bufferedWriter);
            return false;
            {
                BufferedWriter bufferedWriter5;
                catch (Throwable throwable2) {
                    break block11;
                }
                catch (Exception exception) {}
                {
                    bufferedWriter5 = bufferedWriter;
                    IOUtils.delFileOrFolder(new File(this.mDirectory, string));
                }
                IOUtils.closeQuietly(bufferedWriter5);
                return false;
            }
        }
        IOUtils.closeQuietly(bufferedWriter);
        throw throwable2;
    }

    @Override
    public boolean remove(String string) {
        string = this.uniqueKey(string);
        return IOUtils.delFileOrFolder(new File(this.mDirectory, string));
    }

    @Override
    public boolean clear() {
        return IOUtils.delFileOrFolder(this.mDirectory);
    }

    public static class Builder {
        private String mDirectory;
        private String mPassword;

        private Builder(String string) {
            this.mDirectory = string;
        }

        public Builder password(String string) {
            this.mPassword = string;
            return this;
        }

        public DiskCacheStore build() {
            return new DiskCacheStore(this);
        }
    }
}

