/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.simple;

import com.meihu.kalle.Canceller;
import com.meihu.kalle.simple.BasicWorker;
import com.meihu.kalle.simple.Callback;
import com.meihu.kalle.simple.SimpleRequest;
import com.meihu.kalle.simple.SimpleResponse;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

final class Work<T extends SimpleRequest, S, F>
extends FutureTask<SimpleResponse<S, F>>
implements Canceller {
    private BasicWorker<T, S, F> mWorker;
    private final Callback<S, F> mCallback;

    Work(BasicWorker<T, S, F> basicWorker, Callback<S, F> callback) {
        super(basicWorker);
        this.mWorker = basicWorker;
        this.mCallback = callback;
    }

    @Override
    public void run() {
        Work work = this;
        work.mCallback.onStart();
        super.run();
    }

    @Override
    protected void done() {
        try {
            this.mCallback.onResponse((SimpleResponse)this.get());
        }
        catch (Exception exception) {
            if (this.isCancelled()) {
                this.mCallback.onCancel();
            } else {
                this.mCallback.onException(exception);
            }
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (this.isCancelled()) {
                this.mCallback.onCancel();
            } else if (throwable != null && throwable instanceof Exception) {
                this.mCallback.onException((Exception)throwable);
            } else {
                this.mCallback.onException(new Exception(throwable));
            }
        }
        catch (CancellationException cancellationException) {
            this.mCallback.onCancel();
        }
        this.mCallback.onEnd();
    }

    @Override
    public void cancel() {
        Work work = this;
        work.cancel(true);
        work.mWorker.cancel();
    }
}

