/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.simple;

import android.text.TextUtils;
import com.meihu.kalle.BodyRequest;
import com.meihu.kalle.Canceller;
import com.meihu.kalle.RequestMethod;
import com.meihu.kalle.Url;
import com.meihu.kalle.simple.Callback;
import com.meihu.kalle.simple.Converter;
import com.meihu.kalle.simple.RequestManager;
import com.meihu.kalle.simple.SimpleRequest;
import com.meihu.kalle.simple.SimpleResponse;
import com.meihu.kalle.simple.cache.CacheMode;
import java.lang.reflect.Type;

public class SimpleBodyRequest
extends BodyRequest
implements SimpleRequest {
    private final CacheMode mCacheMode;
    private final String mCacheKey;
    private final Converter mConverter;

    public static Api newApi(Url url, RequestMethod requestMethod) {
        return new Api(url, requestMethod);
    }

    private SimpleBodyRequest(Api api) {
        super(api);
        Object object = api.mCacheMode == null ? CacheMode.HTTP : api.mCacheMode;
        this.mCacheMode = object;
        object = TextUtils.isEmpty((CharSequence)api.mCacheKey) ? this.url().toString() : api.mCacheKey;
        this.mCacheKey = object;
        this.mConverter = api.mConverter;
    }

    @Override
    public CacheMode cacheMode() {
        return this.mCacheMode;
    }

    @Override
    public String cacheKey() {
        return this.mCacheKey;
    }

    @Override
    public Converter converter() {
        return this.mConverter;
    }

    public static class Api
    extends BodyRequest.Api<Api> {
        private CacheMode mCacheMode;
        private String mCacheKey;
        private Converter mConverter;

        private Api(Url url, RequestMethod requestMethod) {
            super(url, requestMethod);
        }

        public Api cacheMode(CacheMode cacheMode) {
            this.mCacheMode = cacheMode;
            return this;
        }

        public Api cacheKey(String string) {
            this.mCacheKey = string;
            return this;
        }

        public Api converter(Converter converter) {
            this.mConverter = converter;
            return this;
        }

        public <S, F> SimpleResponse<S, F> perform(Type type, Type type2) throws Exception {
            return RequestManager.getInstance().perform(new SimpleBodyRequest(this), type, type2);
        }

        public <S, F> Canceller perform(Callback<S, F> callback) {
            return RequestManager.getInstance().perform(new SimpleBodyRequest(this), callback);
        }
    }
}

