/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.simple;

import com.meihu.kalle.CancelerManager;
import com.meihu.kalle.Canceller;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.simple.BodyWorker;
import com.meihu.kalle.simple.Callback;
import com.meihu.kalle.simple.SimpleBodyRequest;
import com.meihu.kalle.simple.SimpleResponse;
import com.meihu.kalle.simple.SimpleUrlRequest;
import com.meihu.kalle.simple.UrlWorker;
import com.meihu.kalle.simple.Work;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;

public class RequestManager {
    private static RequestManager sInstance;
    private final Executor mExecutor = Kalle.getConfig().getWorkExecutor();
    private final CancelerManager mCancelManager = new CancelerManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<RequestManager> clazz = RequestManager.class;
        synchronized (RequestManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new RequestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private RequestManager() {
    }

    public <S, F> Canceller perform(final SimpleUrlRequest simpleUrlRequest, Callback<S, F> callback) {
        AsyncCallback asyncCallback;
        Work work;
        Work work2 = work;
        RequestManager requestManager = this;
        Callback<S, F> callback2 = callback;
        Object object = callback2.getSucceed();
        UrlWorker urlWorker = new UrlWorker(simpleUrlRequest, (Type)object, callback2.getFailed());
        object = asyncCallback;
        asyncCallback = new AsyncCallback<S, F>(callback){

            @Override
            public void onEnd() {
                1 v0 = this;
                super.onEnd();
                v0.RequestManager.this.mCancelManager.removeCancel(simpleUrlRequest);
            }
        };
        work2(urlWorker, object);
        requestManager.mCancelManager.addCancel(simpleUrlRequest, work2);
        requestManager.mExecutor.execute(work2);
        return work;
    }

    public <S, F> SimpleResponse<S, F> perform(SimpleUrlRequest simpleUrlRequest, Type type, Type type2) throws Exception {
        return new UrlWorker(simpleUrlRequest, type, type2).call();
    }

    public <S, F> Canceller perform(final SimpleBodyRequest simpleBodyRequest, Callback<S, F> callback) {
        AsyncCallback asyncCallback;
        Work work;
        Work work2 = work;
        RequestManager requestManager = this;
        Callback<S, F> callback2 = callback;
        Object object = callback2.getSucceed();
        BodyWorker bodyWorker = new BodyWorker(simpleBodyRequest, (Type)object, callback2.getFailed());
        object = asyncCallback;
        asyncCallback = new AsyncCallback<S, F>(callback){

            @Override
            public void onEnd() {
                2 v0 = this;
                super.onEnd();
                v0.RequestManager.this.mCancelManager.removeCancel(simpleBodyRequest);
            }
        };
        work2(bodyWorker, object);
        requestManager.mCancelManager.addCancel(simpleBodyRequest, work2);
        requestManager.mExecutor.execute(work2);
        return work;
    }

    public <S, F> SimpleResponse<S, F> perform(SimpleBodyRequest simpleBodyRequest, Type type, Type type2) throws Exception {
        return new BodyWorker(simpleBodyRequest, type, type2).call();
    }

    public void cancel(Object object) {
        this.mCancelManager.cancel(object);
    }

    public void cancelAll() {
        this.mCancelManager.cancelAll();
    }

    private static class AsyncCallback<S, F>
    extends Callback<S, F> {
        private final Callback<S, F> mCallback;
        private final Executor mExecutor;

        AsyncCallback(Callback<S, F> callback) {
            AsyncCallback asyncCallback = this;
            asyncCallback.mCallback = callback;
            asyncCallback.mExecutor = Kalle.getConfig().getMainExecutor();
        }

        @Override
        public Type getSucceed() {
            return this.mCallback.getSucceed();
        }

        @Override
        public Type getFailed() {
            return this.mCallback.getFailed();
        }

        @Override
        public void onStart() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStart();
                }
            });
        }

        @Override
        public void onResponse(final SimpleResponse<S, F> simpleResponse) {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onResponse(simpleResponse);
                }
            });
        }

        @Override
        public void onException(final Exception exception) {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onException(exception);
                }
            });
        }

        @Override
        public void onCancel() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onCancel();
                }
            });
        }

        @Override
        public void onEnd() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onEnd();
                }
            });
        }
    }
}

