/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.simple;

import com.meihu.kalle.Headers;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Response;
import com.meihu.kalle.exception.NoCacheError;
import com.meihu.kalle.exception.ParseError;
import com.meihu.kalle.simple.ByteArrayBody;
import com.meihu.kalle.simple.Converter;
import com.meihu.kalle.simple.SimpleRequest;
import com.meihu.kalle.simple.SimpleResponse;
import com.meihu.kalle.simple.cache.Cache;
import com.meihu.kalle.simple.cache.CacheStore;
import com.meihu.kalle.util.IOUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;

abstract class BasicWorker<T extends SimpleRequest, Succeed, Failed>
implements Callable<SimpleResponse<Succeed, Failed>> {
    private static final long MAX_EXPIRES = System.currentTimeMillis() + 3153600000000L;
    private final T mRequest;
    private final CacheStore mCacheStore;
    private final Converter mConverter;
    private final Type mSucceed;
    private final Type mFailed;

    BasicWorker(T object, Type type, Type type2) {
        BasicWorker basicWorker = this;
        this.mRequest = object;
        this.mSucceed = type;
        basicWorker.mFailed = type2;
        basicWorker.mCacheStore = Kalle.getConfig().getCacheStore();
        object = object.converter() == null ? Kalle.getConfig().getConverter() : object.converter();
        this.mConverter = object;
    }

    private Response tryReadCacheBefore() throws NoCacheError {
        block9: {
            block8: {
                int n2 = 1.$SwitchMap$com$meihu$kalle$simple$cache$CacheMode[this.mRequest.cacheMode().ordinal()];
                if (n2 == 1) break block8;
                switch (n2) {
                    default: {
                        break block9;
                    }
                    case 8: 
                    case 9: {
                        Object object = this.mCacheStore.get(this.mRequest.cacheKey());
                        if (object != null) {
                            Cache cache = object;
                            int n3 = cache.getCode();
                            object = cache.getHeaders();
                            byte[] byArray = cache.getBody();
                            return this.buildResponse(n3, (Headers)object, byArray);
                        }
                        break block9;
                    }
                    case 7: {
                        Object object = this.mCacheStore.get(this.mRequest.cacheKey());
                        if (object != null) {
                            Cache cache = object;
                            int n4 = cache.getCode();
                            object = cache.getHeaders();
                            byte[] byArray = cache.getBody();
                            return this.buildResponse(n4, (Headers)object, byArray);
                        }
                        throw new NoCacheError("No cache found.");
                    }
                }
            }
            Object object = this.mCacheStore.get(this.mRequest.cacheKey());
            if (object == null) {
                return null;
            }
            if (((Cache)object).getExpires() > System.currentTimeMillis()) {
                Cache cache = object;
                int n5 = cache.getCode();
                object = cache.getHeaders();
                byte[] byArray = cache.getBody();
                return this.buildResponse(n5, (Headers)object, byArray);
            }
        }
        return null;
    }

    private void tryAttachCache() {
        Cache cache;
        int n2 = 1.$SwitchMap$com$meihu$kalle$simple$cache$CacheMode[this.mRequest.cacheMode().ordinal()];
        if ((n2 == 1 || n2 == 2) && (cache = this.mCacheStore.get(this.mRequest.cacheKey())) != null) {
            this.attachCache(cache.getHeaders());
        }
    }

    private void tryDetachCache(int n2, Headers headers, byte[] byArray) {
        int n3 = 1.$SwitchMap$com$meihu$kalle$simple$cache$CacheMode[this.mRequest.cacheMode().ordinal()];
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 4) {
                    if (n3 != 5) {
                        long l2;
                        if (n3 == 9 && ((l2 = Headers.analysisCacheExpires(headers)) > 0L || headers.getLastModified() > 0L)) {
                            this.detachCache(n2, headers, byArray, l2);
                        }
                    } else {
                        long l3 = MAX_EXPIRES;
                        this.detachCache(n2, headers, byArray, l3);
                    }
                } else {
                    long l4 = Headers.analysisCacheExpires(headers);
                    if (l4 > 0L || headers.getLastModified() > 0L) {
                        this.detachCache(n2, headers, byArray, l4);
                    }
                }
            } else {
                long l5 = MAX_EXPIRES;
                this.detachCache(n2, headers, byArray, l5);
            }
        } else {
            long l6 = Headers.analysisCacheExpires(headers);
            if (l6 > 0L || headers.getLastModified() > 0L) {
                this.detachCache(n2, headers, byArray, l6);
            }
        }
    }

    private Response tryReadCacheAfter(int n2) {
        Object object;
        int n3 = 1.$SwitchMap$com$meihu$kalle$simple$cache$CacheMode[this.mRequest.cacheMode().ordinal()];
        if (n3 != 1 && n3 != 2) {
            if (n3 != 6) {
                Object object2;
                if (n3 == 9 && n2 == 304 && (object2 = this.mCacheStore.get(this.mRequest.cacheKey())) != null) {
                    Cache cache = object2;
                    int n4 = cache.getCode();
                    object2 = cache.getHeaders();
                    byte[] byArray = cache.getBody();
                    return this.buildResponse(n4, (Headers)object2, byArray);
                }
            } else {
                Object object3 = this.mCacheStore.get(this.mRequest.cacheKey());
                if (object3 != null) {
                    Cache cache = object3;
                    int n5 = cache.getCode();
                    object3 = cache.getHeaders();
                    byte[] byArray = cache.getBody();
                    return this.buildResponse(n5, (Headers)object3, byArray);
                }
            }
        } else if (n2 == 304 && (object = this.mCacheStore.get(this.mRequest.cacheKey())) != null) {
            Cache cache = object;
            int n6 = cache.getCode();
            object = cache.getHeaders();
            byte[] byArray = cache.getBody();
            return this.buildResponse(n6, (Headers)object, byArray);
        }
        return null;
    }

    private void attachCache(Headers headers) {
        long l2;
        Headers headers2 = ((BasicWorker)((Object)headers2)).mRequest.headers();
        String string = headers.getETag();
        if (string != null) {
            headers2.set("If-None-Match", string);
        }
        if ((l2 = headers.getLastModified()) > 0L) {
            headers2.set("If-Modified-Since", Headers.formatMillisToGMT(l2));
        }
    }

    private void detachCache(int n2, Headers headers, byte[] byArray, long l2) {
        Cache cache;
        BasicWorker basicWorker = string;
        String string = basicWorker.mRequest.cacheKey();
        Cache cache2 = cache;
        cache2();
        cache2.setKey(string);
        cache2.setCode(n2);
        cache2.setHeaders(headers);
        cache2.setBody(byArray);
        cache.setExpires(l2);
        basicWorker.mCacheStore.replace(string, cache2);
    }

    private Response buildResponse(int n2, Headers headers, byte[] byArray) {
        return Response.newBuilder().code(n2).headers(headers).body(new ByteArrayBody(headers.getContentType(), byArray)).build();
    }

    private SimpleResponse<Succeed, Failed> buildSimpleResponse(Response response, boolean bl) throws IOException {
        Converter converter = ((BasicWorker)((Object)type)).mConverter;
        BasicWorker basicWorker = type;
        BasicWorker basicWorker2 = basicWorker;
        Type type = basicWorker.mSucceed;
        try {
            return converter.convert(type, basicWorker2.mFailed, response, bl);
        }
        catch (Exception exception) {
            throw new ParseError("An exception occurred while parsing the data.", exception);
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public final SimpleResponse<Succeed, Failed> call() throws Exception {
        Throwable throwable2;
        Response response;
        block16: {
            int n2;
            block14: {
                block15: {
                    response = this.tryReadCacheBefore();
                    if (response != null) {
                        return this.buildSimpleResponse(response, true);
                    }
                    BasicWorker basicWorker = this;
                    basicWorker.tryAttachCache();
                    response = basicWorker.requestNetwork(basicWorker.mRequest);
                    n2 = response.code();
                    if (n2 != 304) break block14;
                    Response response2 = this.tryReadCacheAfter(-1);
                    if (response2 == null) break block15;
                    SimpleResponse<Succeed, Failed> simpleResponse = this.buildSimpleResponse(response2, true);
                    IOUtils.closeQuietly(response);
                    return simpleResponse;
                }
                SimpleResponse<Succeed, Failed> simpleResponse = this.buildSimpleResponse(response, false);
                IOUtils.closeQuietly(response);
                return simpleResponse;
            }
            Object object = response.headers();
            byte[] byArray = new byte[]{};
            if (n2 != 204) {
                byArray = response.body().byteArray();
            }
            BasicWorker basicWorker = this;
            BasicWorker basicWorker2 = basicWorker;
            IOUtils.closeQuietly(response);
            this.tryDetachCache(n2, (Headers)object, byArray);
            response = basicWorker.buildResponse(n2, (Headers)object, byArray);
            SimpleResponse<Succeed, Failed> simpleResponse = basicWorker2.buildSimpleResponse(response, false);
            IOUtils.closeQuietly(response);
            return simpleResponse;
            {
                SimpleResponse<Succeed, Failed> simpleResponse2;
                catch (Throwable throwable2) {
                    break block16;
                }
                catch (IOException iOException) {}
                {
                    object = this.tryReadCacheAfter(-1);
                    if (object == null) throw iOException;
                }
                {
                    simpleResponse2 = this.buildSimpleResponse((Response)object, true);
                }
                IOUtils.closeQuietly(response);
                return simpleResponse2;
            }
        }
        IOUtils.closeQuietly(response);
        throw throwable2;
    }

    protected abstract Response requestNetwork(T var1) throws IOException;

    public abstract void cancel();
}

