/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.download;

import com.meihu.kalle.Canceller;
import com.meihu.kalle.download.BasicWorker;
import com.meihu.kalle.download.Callback;
import com.meihu.kalle.download.Download;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class Work<T extends Download>
extends FutureTask<String>
implements Canceller {
    private BasicWorker<T> mWorker;
    private final Callback mCallback;

    Work(BasicWorker<T> basicWorker, Callback callback) {
        super(basicWorker);
        this.mWorker = basicWorker;
        this.mCallback = callback;
    }

    @Override
    public void run() {
        Work work = this;
        work.mCallback.onStart();
        super.run();
    }

    @Override
    protected void done() {
        try {
            this.mCallback.onFinish((String)this.get());
        }
        catch (Exception exception) {
            if (this.isCancelled()) {
                this.mCallback.onCancel();
            } else {
                this.mCallback.onException(exception);
            }
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (this.isCancelled()) {
                this.mCallback.onCancel();
            } else if (throwable != null && throwable instanceof Exception) {
                this.mCallback.onException((Exception)throwable);
            } else {
                this.mCallback.onException(new Exception(throwable));
            }
        }
        catch (CancellationException cancellationException) {
            this.mCallback.onCancel();
        }
        this.mCallback.onEnd();
    }

    @Override
    public void cancel() {
        Work work = this;
        work.cancel(true);
        work.mWorker.cancel();
    }
}

