/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.download;

import com.meihu.kalle.CancelerManager;
import com.meihu.kalle.Canceller;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.download.BodyDownload;
import com.meihu.kalle.download.BodyWorker;
import com.meihu.kalle.download.Callback;
import com.meihu.kalle.download.UrlDownload;
import com.meihu.kalle.download.UrlWorker;
import com.meihu.kalle.download.Work;
import java.util.concurrent.Executor;

public class DownloadManager {
    private static DownloadManager sInstance;
    private final Executor mExecutor = Kalle.getConfig().getWorkExecutor();
    private final CancelerManager mCancelManager = new CancelerManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<DownloadManager> clazz = DownloadManager.class;
        synchronized (DownloadManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DownloadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private DownloadManager() {
    }

    public Canceller perform(final UrlDownload urlDownload, Callback callback) {
        AsyncCallback asyncCallback;
        Work<UrlDownload> work;
        Work<UrlDownload> work2 = work;
        DownloadManager downloadManager = this;
        AsyncCallback asyncCallback2 = asyncCallback;
        asyncCallback = new AsyncCallback(callback){

            @Override
            public void onEnd() {
                1 v0 = this;
                super.onEnd();
                v0.DownloadManager.this.mCancelManager.removeCancel(urlDownload);
            }
        };
        work2(new UrlWorker(urlDownload), asyncCallback2);
        downloadManager.mCancelManager.addCancel(urlDownload, work2);
        downloadManager.mExecutor.execute(work2);
        return work;
    }

    public String perform(UrlDownload urlDownload) throws Exception {
        return new UrlWorker(urlDownload).call();
    }

    public Canceller perform(final BodyDownload bodyDownload, Callback callback) {
        AsyncCallback asyncCallback;
        Work<BodyDownload> work;
        Work<BodyDownload> work2 = work;
        DownloadManager downloadManager = this;
        AsyncCallback asyncCallback2 = asyncCallback;
        asyncCallback = new AsyncCallback(callback){

            @Override
            public void onEnd() {
                2 v0 = this;
                super.onEnd();
                v0.DownloadManager.this.mCancelManager.removeCancel(bodyDownload);
            }
        };
        work2(new BodyWorker(bodyDownload), asyncCallback2);
        downloadManager.mCancelManager.addCancel(bodyDownload, work2);
        downloadManager.mExecutor.execute(work2);
        return work;
    }

    public String perform(BodyDownload bodyDownload) throws Exception {
        return new BodyWorker(bodyDownload).call();
    }

    public void cancel(Object object) {
        this.mCancelManager.cancel(object);
    }

    public void cancelAll() {
        this.mCancelManager.cancelAll();
    }

    private static class AsyncCallback
    implements Callback {
        private final Callback mCallback;
        private final Executor mExecutor;

        AsyncCallback(Callback callback) {
            AsyncCallback asyncCallback = this;
            asyncCallback.mCallback = callback;
            asyncCallback.mExecutor = Kalle.getConfig().getMainExecutor();
        }

        @Override
        public void onStart() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onStart();
                }
            });
        }

        @Override
        public void onFinish(final String string) {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onFinish(string);
                }
            });
        }

        @Override
        public void onException(final Exception exception) {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onException(exception);
                }
            });
        }

        @Override
        public void onCancel() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onCancel();
                }
            });
        }

        @Override
        public void onEnd() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mCallback.onEnd();
                }
            });
        }
    }
}

