/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.download;

import android.text.TextUtils;
import com.meihu.kalle.Headers;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Response;
import com.meihu.kalle.Url;
import com.meihu.kalle.download.Download;
import com.meihu.kalle.exception.DownloadError;
import com.meihu.kalle.util.IOUtils;
import com.meihu.kalle.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public abstract class BasicWorker<T extends Download>
implements Callable<String> {
    private final T mDownload;
    private String mDirectory;
    private String mFileName;
    private Download.ProgressBar mProgressBar;
    private Download.Policy mPolicy;

    BasicWorker(T t2) {
        BasicWorker basicWorker = this;
        this.mDownload = t2;
        this.mDirectory = t2.directory();
        basicWorker.mFileName = t2.fileName();
        basicWorker.mProgressBar = new AsyncProgressBar(t2.progressBar());
        this.mPolicy = t2.policy();
    }

    private String getRealFileName(Headers object) throws IOException {
        Headers headers = object;
        object = null;
        String string = headers.getContentDisposition();
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)(object = Headers.parseSubValue(string, "filename", null))) && ((String)(object = UrlUtils.urlDecode((String)object, "utf-8"))).startsWith("\"") && ((String)object).endsWith("\"")) {
            Object object2 = object;
            object = ((String)object2).substring(1, ((String)object2).length() - 1);
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            Url url = ((BasicWorker)((Object)url)).mDownload.url();
            object = url.getPath();
            if (TextUtils.isEmpty((CharSequence)object)) {
                object = Integer.toString(url.toString().hashCode());
            } else {
                String[] stringArray = ((String)object).split("/");
                object = stringArray[stringArray.length - 1];
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String call() throws Exception {
        block57: {
            block53: {
                block59: {
                    block56: {
                        block58: {
                            block54: {
                                block55: {
                                    block51: {
                                        block52: {
                                            if (TextUtils.isEmpty((CharSequence)this.mDirectory)) break block57;
                                            IOUtils.createFolder(new File(this.mDirectory));
                                            var1_2 = null;
                                            if (!TextUtils.isEmpty((CharSequence)this.mFileName)) ** GOTO lbl24
                                            v0 = this;
                                            v1 = v0;
                                            v2 = v0;
                                            var1_2 = v0.requestNetwork(v0.mDownload);
                                            var2_3 = var1_2.code();
                                            var3_6 = var1_2.headers();
                                            v2.mFileName = v1.getRealFileName(var3_6);
                                            var4_7 = v3;
                                            v4 = this.mDirectory;
                                            v3 = new File(v4, this.mFileName + ".kalle");
                                            break block51;
lbl24:
                                            // 1 sources

                                            v5 = this;
                                            var4_7 = v6;
                                            v7 = this.mDirectory;
                                            v6 = new File(v7, this.mFileName + ".kalle");
                                            if (!v5.mPolicy.isRange()) break block52;
                                            if (!var4_7.exists()) break block52;
                                            v8 = this;
                                            v8.mDownload.headers().set("Range", "bytes=" + var4_7.length() + "-");
                                            var1_2 = v8.requestNetwork(v8.mDownload);
                                            var2_3 = var1_2.code();
                                            var3_6 = var1_2.headers();
                                        }
                                        v9 = var4_7;
                                        v10 = this;
                                        var1_2 = v10.requestNetwork(v10.mDownload);
                                        var2_3 = var1_2.code();
                                        var3_6 = var1_2.headers();
                                        IOUtils.delFileOrFolder(v9);
                                    }
                                    if (!this.mPolicy.allowDownload(var2_3, var3_6)) break block53;
                                    var5_8 = v11;
                                    v12 = this;
                                    v13 = v12;
                                    var6_9 = v12.mDirectory;
                                    if (!new File(var6_9, v13.mFileName).exists()) break block54;
                                    v14 = this;
                                    var6_9 = var5_8.getAbsolutePath();
                                    if (!v14.mPolicy.oldAvailable(var6_9, var2_3, var3_6)) break block55;
                                    v15 = var6_9;
                                    v16 = var1_2;
                                    v17 = this.mProgressBar;
                                    var0_1 = 100;
                                    var2_4 = var5_8.length();
                                    v17.onProgress(var0_1, var2_4, 0L);
                                    IOUtils.closeQuietly(v16);
                                    return v15;
                                }
                                IOUtils.delFileOrFolder(var5_8);
                            }
                            if (var2_3 != 206) break block58;
                            v18 = var3_6.getContentRange();
                            v19 = v18;
                            v20 = v18.indexOf(47);
                            v21 = Long.parseLong(v19.substring(v20 + 1));
lbl92:
                            // 2 sources

                            while (true) {
                                var2_5 = v21;
                                ** GOTO lbl103
                                break;
                            }
                        }
                        v22 = var3_6;
                        IOUtils.createNewFile(var4_7);
                        v21 = v22.getContentLength();
                        ** continue;
lbl103:
                        // 1 sources

                        v23 = var1_2;
                        var6_10 = var4_7.length();
                        var8_11 = 0;
                        var9_12 = 0L;
                        var11_13 = v24;
                        var11_13(var4_7, "rws");
                        v24.seek(var6_10);
                        var12_14 = new byte[8096];
                        var13_15 = System.currentTimeMillis();
                        var15_16 = 0L;
                        var17_17 = v23.body().stream();
                        block49: while (true) {
                            var18_19 = var17_17.read(var12_14);
                            if (var18_19 == -1) ** GOTO lbl167
                            v25 = var15_16;
                            v26 = var6_10;
                            var11_13.write(var12_14, 0, var18_19);
                            var6_10 = var18_19;
                            var15_16 = v26 + var6_10;
                            var6_10 = v25 + var6_10;
                            var18_18 = System.currentTimeMillis() - var13_15;
                            if (var18_18 >= 400L) break;
lbl131:
                            // 5 sources

                            while (true) {
                                v27 = var15_16;
                                var15_16 = var6_10;
                                var6_10 = v27;
                                continue block49;
                                break;
                            }
                            break;
                        }
                        try {
                            var18_18 = var6_10 * 1000L / var18_18;
                            if (var2_5 == 0L) break block56;
                        }
                        catch (Throwable v28) {
                            IOUtils.closeQuietly(var1_2);
                            throw v28;
                        }
                        var20_20 = (int)(var15_16 * 100L / var2_5);
                        if (var20_20 == var8_11 && var18_18 == var9_12) ** GOTO lbl131
                        var6_10 = 0L;
                        var13_15 = System.currentTimeMillis();
                        this.mProgressBar.onProgress(var20_20, var15_16, var18_18);
                        var9_12 = var18_18;
                        var8_11 = var20_20;
                        ** GOTO lbl131
                    }
                    if (var9_12 == var18_18) break block59;
                    var6_10 = 0L;
                    var9_12 = System.currentTimeMillis();
                    this.mProgressBar.onProgress(0, var15_16, var18_18);
                    var13_15 = var9_12;
                    var9_12 = var18_18;
                    ** GOTO lbl131
                }
                this.mProgressBar.onProgress(0, var15_16, var9_12);
                ** continue;
lbl167:
                // 1 sources

                v29 = var5_8;
                this.mProgressBar.onProgress(100, var6_10, var9_12);
                var4_7.renameTo(var5_8);
                v30 = v29.getAbsolutePath();
                IOUtils.closeQuietly(var1_2);
                return v30;
            }
            throw new DownloadError(var2_3, var3_6, "The download policy prohibits the program from continuing to download.");
        }
        throw new IOException("Please specify the directory.");
    }

    protected abstract Response requestNetwork(T var1) throws IOException;

    public abstract void cancel();

    private static class AsyncProgressBar
    implements Download.ProgressBar {
        private final Download.ProgressBar mProgressBar;
        private final Executor mExecutor;

        AsyncProgressBar(Download.ProgressBar progressBar) {
            AsyncProgressBar asyncProgressBar = this;
            asyncProgressBar.mProgressBar = progressBar;
            asyncProgressBar.mExecutor = Kalle.getConfig().getMainExecutor();
        }

        @Override
        public void onProgress(final int n2, final long l2, final long l3) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    int n22 = v0.n2;
                    long l22 = v0.l2;
                    long l32 = v0.l3;
                    mProgressBar.onProgress(n22, l22, l32);
                }
            });
        }
    }
}

