/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.cookie.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.meihu.kalle.cookie.db.Field;

final class SQLHelper
extends SQLiteOpenHelper
implements Field {
    private static final String DB_COOKIE_NAME = "_kalle_cookies_db.db";
    private static final int DB_COOKIE_VERSION = 3;
    private static final String SQL_CREATE_TABLE = "CREATE TABLE COOKIES_TABLE(_ID INTEGER PRIMARY KEY AUTOINCREMENT, URL TEXT, NAME TEXT, VALUE TEXT, COMMENT TEXT, COMMENT_URL TEXT, DISCARD TEXT, DOMAIN TEXT, EXPIRY INTEGER, PATH TEXT, PORT_LIST TEXT, SECURE TEXT, VERSION INTEGER)";
    private static final String SQL_CREATE_UNIQUE_INDEX = "CREATE UNIQUE INDEX COOKIE_UNIQUE_INDEX ON COOKIES_TABLE(\"NAME\", \"DOMAIN\", \"PATH\")";
    private static final String SQL_DELETE_TABLE = "DROP TABLE IF EXISTS COOKIES_TABLE";

    SQLHelper(Context context) {
        super(context.getApplicationContext(), DB_COOKIE_NAME, null, 3);
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        sQLiteDatabase2.beginTransaction();
        try {
            sQLiteDatabase2.execSQL(SQL_CREATE_TABLE);
            sQLiteDatabase2.execSQL(SQL_CREATE_UNIQUE_INDEX);
            sQLiteDatabase2.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            sQLiteDatabase.endTransaction();
            throw throwable;
        }
        sQLiteDatabase2.endTransaction();
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        if (n3 != n2) {
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            sQLiteDatabase2.beginTransaction();
            try {
                sQLiteDatabase2.execSQL(SQL_DELETE_TABLE);
                sQLiteDatabase2.execSQL(SQL_CREATE_TABLE);
                sQLiteDatabase2.execSQL(SQL_CREATE_UNIQUE_INDEX);
                sQLiteDatabase2.setTransactionSuccessful();
            }
            catch (Throwable throwable) {
                sQLiteDatabase.endTransaction();
                throw throwable;
            }
            sQLiteDatabase2.endTransaction();
        }
    }
}

