/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.connect.http;

import com.meihu.kalle.Headers;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Request;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.Response;
import com.meihu.kalle.connect.ConnectFactory;
import com.meihu.kalle.connect.Connection;
import com.meihu.kalle.connect.Interceptor;
import com.meihu.kalle.connect.Network;
import com.meihu.kalle.connect.StreamBody;
import com.meihu.kalle.connect.http.Chain;
import com.meihu.kalle.cookie.CookieManager;
import com.meihu.kalle.exception.ConnectException;
import com.meihu.kalle.exception.ConnectTimeoutError;
import com.meihu.kalle.exception.HostError;
import com.meihu.kalle.exception.NetworkError;
import com.meihu.kalle.exception.ReadException;
import com.meihu.kalle.exception.ReadTimeoutError;
import com.meihu.kalle.exception.URLError;
import com.meihu.kalle.exception.WriteException;
import com.meihu.kalle.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;

class ConnectInterceptor
implements Interceptor {
    private final CookieManager mCookieManager = new CookieManager(Kalle.getConfig().getCookieStore());
    private final ConnectFactory mFactory = Kalle.getConfig().getConnectFactory();
    private final Network mNetwork = Kalle.getConfig().getNetwork();
    private Connection mConnection;
    private boolean isCanceled;

    ConnectInterceptor() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection connect(Request request) throws ConnectException {
        List<String> list;
        URI uRI;
        Object[] objectArray;
        ConnectInterceptor connectInterceptor;
        void var1_8;
        if (!this.mNetwork.isAvailable()) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = var1_8.url();
            throw new NetworkError(String.format("Network Unavailable: %1$s.", objectArray3));
        }
        try {
            connectInterceptor = this;
            objectArray = var1_8.headers();
        }
        catch (Exception exception) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = var1_8.url();
            throw new ConnectException(String.format("An unknown exception: %1$s.", objectArray), exception);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = var1_8.url();
            throw new ConnectTimeoutError(String.format("Connect time out: %1$s.", objectArray), socketTimeoutException);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray6 = new Object[1];
            objectArray = objectArray6;
            objectArray6[0] = var1_8.url();
            throw new HostError(String.format("Hostname can not be resolved: %1$s.", objectArray), unknownHostException);
        }
        catch (MalformedURLException malformedURLException) {
            Object[] objectArray7 = new Object[1];
            objectArray = objectArray7;
            objectArray7[0] = var1_8.url();
            throw new URLError(String.format("The url is malformed: %1$s.", objectArray), malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Object[] objectArray8 = new Object[1];
            objectArray = objectArray8;
            objectArray8[0] = var1_8.url();
            throw new URLError(String.format("The url syntax error: %1$s.", objectArray), uRISyntaxException);
        }
        URI uRI2 = uRI;
        {
            uRI = new URI(var1_8.url().toString());
            list = connectInterceptor.mCookieManager.get(uRI2);
        }
        {
            if (list != null && !list.isEmpty()) {
                objectArray.add("Cookie", list);
            }
            String string = "Host";
            objectArray.set(string, uRI2.getHost());
            return this.mFactory.connect((Request)var1_8);
        }
    }

    private void writeBody(RequestBody requestBody) throws WriteException {
        OutputStream outputStream;
        try {
            outputStream = this.mConnection.getOutputStream();
        }
        catch (Exception exception) {
            throw new WriteException(exception);
        }
        requestBody.writeTo(IOUtils.toBufferedOutputStream(outputStream));
        IOUtils.closeQuietly(outputStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response readResponse(Request request) throws ReadException {
        StreamBody streamBody;
        Object object;
        Headers headers;
        int n2;
        try {
            ConnectInterceptor connectInterceptor = this;
            n2 = connectInterceptor.mConnection.getCode();
            headers = connectInterceptor.parseResponseHeaders(connectInterceptor.mConnection.getHeaders());
        }
        catch (Exception exception) {
            throw new ReadException(exception);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = request.url();
            throw new ReadTimeoutError(String.format("Read data time out: %1$s.", objectArray2), socketTimeoutException);
        }
        {
            object = headers.get("Set-Cookie");
        }
        {
            if (object != null && !object.isEmpty()) {
                this.mCookieManager.add(URI.create(request.url().toString()), (List<String>)object);
            }
            object = headers.getContentType();
        }
        StreamBody streamBody2 = streamBody;
        {
            streamBody = new StreamBody((String)object, this.mConnection.getInputStream());
            return Response.newBuilder().code(n2).headers(headers).body(streamBody2).build();
        }
    }

    private Headers parseResponseHeaders(Map<String, List<String>> object) {
        Headers headers;
        Headers headers2 = headers;
        headers = new Headers();
        for (Map.Entry entry : object.entrySet()) {
            headers2.add((String)entry.getKey(), (List<String>)((List)entry.getValue()));
        }
        return headers2;
    }

    @Override
    public Response intercept(Chain object) throws IOException {
        if (!this.isCanceled) {
            if (((Request)(object = object.request())).method().allowBody()) {
                ConnectInterceptor connectInterceptor = this;
                Object object2 = object;
                Headers headers = ((Request)object2).headers();
                RequestBody requestBody = ((Request)object).body();
                headers.set("Content-Length", Long.toString(requestBody.contentLength()));
                headers.set("Content-Type", requestBody.contentType());
                connectInterceptor.mConnection = connectInterceptor.connect((Request)object2);
                connectInterceptor.writeBody(requestBody);
            } else {
                this.mConnection = this.connect((Request)object);
            }
            return this.readResponse((Request)object);
        }
        throw new CancellationException("The request has been cancelled.");
    }

    public void cancel() {
        ((ConnectInterceptor)((Object)connection)).isCanceled = true;
        Connection connection = ((ConnectInterceptor)((Object)connection)).mConnection;
        if (connection != null) {
            connection.disconnect();
        }
    }
}

