/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.text.TextUtils;
import com.meihu.kalle.BaseContent;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StringBody
extends BaseContent<StringBody>
implements RequestBody {
    private final String mBody;
    private final Charset mCharset;
    private final String mContentType;

    public StringBody(String string) {
        this(string, Kalle.getConfig().getCharset());
    }

    public StringBody(String string, Charset charset) {
        this(string, charset, "application/octet-stream");
    }

    public StringBody(String string, String string2) {
        this(string, Kalle.getConfig().getCharset(), string2);
    }

    public StringBody(String string, Charset charset, String string2) {
        this.mBody = string;
        this.mCharset = charset;
        this.mContentType = string2;
    }

    @Override
    public long contentLength() {
        if (TextUtils.isEmpty((CharSequence)this.mBody)) {
            return 0L;
        }
        return IOUtils.toByteArray((CharSequence)this.mBody, this.mCharset).length;
    }

    @Override
    public String contentType() {
        return this.mContentType + "; charset=" + this.mCharset.name();
    }

    @Override
    protected void onWrite(OutputStream outputStream) throws IOException {
        StringBody stringBody = string;
        String string = stringBody.mBody;
        IOUtils.write(outputStream, (CharSequence)string, stringBody.mCharset);
    }

    public String toString() {
        return this.mBody;
    }
}

