/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import com.meihu.kalle.Headers;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Params;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.RequestMethod;
import com.meihu.kalle.Url;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public abstract class Request {
    private final RequestMethod mMethod;
    private final Headers mHeaders;
    private final Proxy mProxy;
    private final SSLSocketFactory mSSLSocketFactory;
    private final HostnameVerifier mHostnameVerifier;
    private final int mConnectTimeout;
    private final int mReadTimeout;
    private final Object mTag;

    protected <T extends Api<T>> Request(Api<T> api) {
        this.mMethod = ((Api)api).mMethod;
        this.mHeaders = ((Api)api).mHeaders;
        this.mProxy = ((Api)api).mProxy;
        this.mSSLSocketFactory = ((Api)api).mSSLSocketFactory;
        this.mHostnameVerifier = ((Api)api).mHostnameVerifier;
        this.mConnectTimeout = ((Api)api).mConnectTimeout;
        this.mReadTimeout = ((Api)api).mReadTimeout;
        this.mTag = ((Api)api).mTag;
    }

    public abstract Url url();

    public abstract Params copyParams();

    public abstract RequestBody body();

    public RequestMethod method() {
        return this.mMethod;
    }

    public Headers headers() {
        return this.mHeaders;
    }

    public Proxy proxy() {
        return this.mProxy;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.mHostnameVerifier;
    }

    public int connectTimeout() {
        return this.mConnectTimeout;
    }

    public int readTimeout() {
        return this.mReadTimeout;
    }

    public Object tag() {
        return this.mTag;
    }

    public static abstract class Api<T extends Api<T>> {
        private final RequestMethod mMethod;
        private final Headers mHeaders;
        private Proxy mProxy;
        private SSLSocketFactory mSSLSocketFactory;
        private HostnameVerifier mHostnameVerifier;
        private int mConnectTimeout;
        private int mReadTimeout;
        private Object mTag;

        protected Api(RequestMethod requestMethod) {
            Headers headers;
            Headers headers2 = headers;
            Api api = this;
            Headers headers3 = headers2;
            headers3();
            api.mHeaders = headers3;
            api.mProxy = Kalle.getConfig().getProxy();
            api.mSSLSocketFactory = Kalle.getConfig().getSSLSocketFactory();
            api.mHostnameVerifier = Kalle.getConfig().getHostnameVerifier();
            api.mConnectTimeout = Kalle.getConfig().getConnectTimeout();
            api.mReadTimeout = Kalle.getConfig().getReadTimeout();
            this.mMethod = requestMethod;
            headers.add(Kalle.getConfig().getHeaders());
        }

        public abstract T path(int var1);

        public abstract T path(long var1);

        public abstract T path(boolean var1);

        public abstract T path(char var1);

        public abstract T path(double var1);

        public abstract T path(float var1);

        public abstract T path(String var1);

        public T addHeader(String string, String string2) {
            Api api = this;
            api.mHeaders.add(string, string2);
            return (T)api;
        }

        public T setHeader(String string, String string2) {
            Api api = this;
            api.mHeaders.set(string, string2);
            return (T)api;
        }

        public T setHeaders(Headers headers) {
            Api api = this;
            api.mHeaders.set(headers);
            return (T)api;
        }

        public T removeHeader(String string) {
            Api api = this;
            api.mHeaders.remove(string);
            return (T)api;
        }

        public T clearHeaders() {
            Api api = this;
            api.mHeaders.clear();
            return (T)api;
        }

        public abstract T param(String var1, int var2);

        public abstract T param(String var1, long var2);

        public abstract T param(String var1, boolean var2);

        public abstract T param(String var1, char var2);

        public abstract T param(String var1, double var2);

        public abstract T param(String var1, float var2);

        public abstract T param(String var1, short var2);

        public abstract T param(String var1, String var2);

        public abstract T param(String var1, List<String> var2);

        public abstract T removeParam(String var1);

        public abstract T clearParams();

        public T proxy(Proxy proxy) {
            this.mProxy = proxy;
            return (T)this;
        }

        public T sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.mSSLSocketFactory = sSLSocketFactory;
            return (T)this;
        }

        public T hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.mHostnameVerifier = hostnameVerifier;
            return (T)this;
        }

        public T connectTimeout(int n2, TimeUnit timeUnit) {
            this.mConnectTimeout = (int)Math.min(timeUnit.toMillis(n2), Integer.MAX_VALUE);
            return (T)this;
        }

        public T readTimeout(int n2, TimeUnit timeUnit) {
            this.mReadTimeout = (int)Math.min(timeUnit.toMillis(n2), Integer.MAX_VALUE);
            return (T)this;
        }

        public T tag(Object object) {
            this.mTag = object;
            return (T)this;
        }
    }
}

