/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.net.Uri;
import android.text.TextUtils;
import com.meihu.kalle.Binary;
import com.meihu.kalle.FileBinary;
import com.meihu.kalle.FormBody;
import com.meihu.kalle.UrlBody;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Params {
    private final Map<String, List<Object>> mMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Params(Builder builder) {
        this.mMap = builder.mMap;
    }

    public List<Object> get(String string) {
        return this.mMap.get(string);
    }

    public Object getFirst(String string) {
        List<Object> list = ((Params)((Object)list)).mMap.get(string);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.mMap.entrySet();
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public boolean containsKey(String string) {
        return this.mMap.containsKey(string);
    }

    public boolean hasBinary() {
        Iterator<Map.Entry<String, List<Object>>> iterator = ((Params)((Object)iterator)).entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = (List)((Map.Entry)iterator.next()).getValue();
            if (object.size() <= 0) continue;
            object = object.iterator();
            while (object.hasNext()) {
                if (!(object.next() instanceof Binary)) continue;
                return true;
            }
        }
        return false;
    }

    public UrlBody toUrlBody() {
        return UrlBody.newBuilder().params(this).build();
    }

    public FormBody toFormBody() {
        return FormBody.newBuilder().params(this).build();
    }

    public Builder builder() {
        LinkedHashMap linkedHashMap;
        Params params = linkedHashMap2;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry<String, List<Object>> entry : params.mMap.entrySet()) {
            linkedHashMap2.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new Builder(linkedHashMap2);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (String string : this.keySet()) {
            for (Object object : this.get(string)) {
                if (!(object instanceof CharSequence)) continue;
                object = bl ? Uri.encode((String)object.toString()) : object.toString();
                stringBuilder2.append("&").append(string).append("=").append((String)object);
            }
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.deleteCharAt(0);
        }
        return stringBuilder2.toString();
    }

    public static class Builder {
        private Map<String, List<Object>> mMap;

        private Builder() {
            LinkedHashMap linkedHashMap;
            LinkedHashMap linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            v1.mMap = linkedHashMap2;
        }

        private Builder(Map<String, List<Object>> map) {
            this.mMap = map;
        }

        private Builder add(String string, Object object) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                Object object2;
                if (!this.mMap.containsKey(string)) {
                    ArrayList arrayList;
                    object2 = arrayList;
                    arrayList = new ArrayList(1);
                    this.mMap.put(string, (List<Object>)object2);
                }
                if (object == null) {
                    object = "";
                }
                if (object instanceof File) {
                    FileBinary fileBinary;
                    object2 = fileBinary;
                    fileBinary = new FileBinary((File)object);
                    object = object2;
                }
                this.mMap.get(string).add(object);
            }
            return this;
        }

        public Builder add(String string, int n2) {
            return this.add(string, Integer.toString(n2));
        }

        public Builder add(String string, long l2) {
            return this.add(string, Long.toString(l2));
        }

        public Builder add(String string, boolean bl) {
            return this.add(string, Boolean.toString(bl));
        }

        public Builder add(String string, char c2) {
            return this.add(string, String.valueOf(c2));
        }

        public Builder add(String string, double d2) {
            return this.add(string, Double.toString(d2));
        }

        public Builder add(String string, float f2) {
            return this.add(string, Float.toString(f2));
        }

        public Builder add(String string, short s2) {
            return this.add(string, Integer.toString(s2));
        }

        public Builder add(String string, CharSequence charSequence) {
            return this.add(string, (Object)charSequence);
        }

        public Builder add(String string, List<String> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.add(string, (String)object.next());
            }
            return this;
        }

        public Builder add(Params object) {
            for (Map.Entry<String, List<Object>> entry : ((Params)((Object)object)).entrySet()) {
                String string = entry.getKey();
                Iterator<Object> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    this.add(string, iterator.next());
                }
            }
            return this;
        }

        public Builder set(Params params) {
            return this.clear().add(params);
        }

        public Builder file(String string, File file) {
            return this.add(string, file);
        }

        public Builder files(String string, List<File> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.add(string, (File)object.next());
            }
            return this;
        }

        public Builder binary(String string, Binary binary) {
            return this.add(string, binary);
        }

        public Builder binaries(String string, List<Binary> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.binary(string, (Binary)object.next());
            }
            return this;
        }

        public Builder remove(String string) {
            Builder builder = this;
            builder.mMap.remove(string);
            return builder;
        }

        public Builder clear() {
            Builder builder = this;
            builder.mMap.clear();
            return builder;
        }

        public Params build() {
            return new Params(this);
        }
    }
}

