/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import com.meihu.kalle.Binary;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Params;
import com.meihu.kalle.Request;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.RequestMethod;
import com.meihu.kalle.Url;
import java.io.File;
import java.util.List;

public class BodyRequest
extends Request {
    private final Url mUrl;
    private final RequestBody mBody;
    private final Params mParams;

    public static Builder newBuilder(String string, RequestMethod requestMethod) {
        return BodyRequest.newBuilder(Url.newBuilder(string).build(), requestMethod);
    }

    public static Builder newBuilder(Url url, RequestMethod requestMethod) {
        return new Builder(url, requestMethod);
    }

    @Deprecated
    public static Builder newBuilder(Url.Builder builder, RequestMethod requestMethod) {
        return BodyRequest.newBuilder(builder.build(), requestMethod);
    }

    protected BodyRequest(Api object) {
        super(object);
        Params params;
        this.mUrl = ((Api)object).mUrlBuilder.build();
        this.mParams = params = ((Api)object).mParams.build();
        object = ((Api)object).mBody == null ? (params.hasBinary() ? params.toFormBody() : params.toUrlBody()) : ((Api)object).mBody;
        this.mBody = object;
    }

    @Override
    public Url url() {
        return this.mUrl;
    }

    @Override
    public Params copyParams() {
        return this.mParams;
    }

    @Override
    public RequestBody body() {
        return this.mBody;
    }

    public static class Builder
    extends Api<Builder> {
        private Builder(Url url, RequestMethod requestMethod) {
            super(url, requestMethod);
        }

        public BodyRequest build() {
            return new BodyRequest(this);
        }
    }

    public static class Api<T extends Api<T>>
    extends Request.Api<T> {
        private Url.Builder mUrlBuilder;
        private Params.Builder mParams;
        private RequestBody mBody;

        protected Api(Url url, RequestMethod requestMethod) {
            super(requestMethod);
            this.mUrlBuilder = url.builder();
            this.mParams = Params.newBuilder();
            this.mParams.add(Kalle.getConfig().getParams());
        }

        @Override
        public T path(int n2) {
            Api api = this;
            api.mUrlBuilder.addPath(n2);
            return (T)api;
        }

        @Override
        public T path(long l2) {
            Api api = this;
            api.mUrlBuilder.addPath(l2);
            return (T)api;
        }

        @Override
        public T path(boolean bl) {
            Api api = this;
            api.mUrlBuilder.addPath(bl);
            return (T)api;
        }

        @Override
        public T path(char c2) {
            Api api = this;
            api.mUrlBuilder.addPath(c2);
            return (T)api;
        }

        @Override
        public T path(double d2) {
            Api api = this;
            api.mUrlBuilder.addPath(d2);
            return (T)api;
        }

        @Override
        public T path(float f2) {
            Api api = this;
            api.mUrlBuilder.addPath(f2);
            return (T)api;
        }

        @Override
        public T path(String string) {
            Api api = this;
            api.mUrlBuilder.addPath(string);
            return (T)api;
        }

        public T urlParam(String string, int n2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, n2);
            return (T)api;
        }

        public T urlParam(String string, long l2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, l2);
            return (T)api;
        }

        public T urlParam(String string, boolean bl) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, bl);
            return (T)api;
        }

        public T urlParam(String string, char c2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, c2);
            return (T)api;
        }

        public T urlParam(String string, double d2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, d2);
            return (T)api;
        }

        public T urlParam(String string, float f2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, f2);
            return (T)api;
        }

        public T urlParam(String string, short s2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, s2);
            return (T)api;
        }

        public T urlParam(String string, String string2) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, string2);
            return (T)api;
        }

        public T urlParam(String string, List<String> list) {
            Api api = this;
            api.mUrlBuilder.addQuery(string, list);
            return (T)api;
        }

        public T urlParam(Params params) {
            Api api = this;
            api.mUrlBuilder.addQuery(params);
            return (T)api;
        }

        public T setUrlParam(Params params) {
            Api api = this;
            api.mUrlBuilder.setQuery(params);
            return (T)api;
        }

        @Override
        public T param(String string, int n2) {
            return (T)this.param(string, Integer.toString(n2));
        }

        @Override
        public T param(String string, long l2) {
            Api api = this;
            api.mParams.add(string, l2);
            return (T)api;
        }

        @Override
        public T param(String string, boolean bl) {
            Api api = this;
            api.mParams.add(string, bl);
            return (T)api;
        }

        @Override
        public T param(String string, char c2) {
            Api api = this;
            api.mParams.add(string, c2);
            return (T)api;
        }

        @Override
        public T param(String string, double d2) {
            Api api = this;
            api.mParams.add(string, d2);
            return (T)api;
        }

        @Override
        public T param(String string, float f2) {
            Api api = this;
            api.mParams.add(string, f2);
            return (T)api;
        }

        @Override
        public T param(String string, short s2) {
            Api api = this;
            api.mParams.add(string, s2);
            return (T)api;
        }

        @Override
        public T param(String string, String string2) {
            Api api = this;
            api.mParams.add(string, string2);
            return (T)api;
        }

        @Override
        public T param(String string, List<String> list) {
            Api api = this;
            api.mParams.add(string, list);
            return (T)api;
        }

        public T params(Params params) {
            Api api = this;
            api.mParams.add(params);
            return (T)api;
        }

        public T setParams(Params params) {
            Api api = this;
            api.mParams.set(params);
            return (T)api;
        }

        @Override
        public T removeParam(String string) {
            Api api = this;
            api.mParams.remove(string);
            return (T)api;
        }

        @Override
        public T clearParams() {
            Api api = this;
            api.mParams.clear();
            return (T)api;
        }

        public T file(String string, File file) {
            Api api = this;
            api.mParams.file(string, file);
            return (T)api;
        }

        public T files(String string, List<File> list) {
            Api api = this;
            api.mParams.files(string, list);
            return (T)api;
        }

        public T binary(String string, Binary binary) {
            Api api = this;
            api.mParams.binary(string, binary);
            return (T)api;
        }

        public T binaries(String string, List<Binary> list) {
            Api api = this;
            api.mParams.binaries(string, list);
            return (T)api;
        }

        public T body(RequestBody requestBody) {
            this.mBody = requestBody;
            return (T)this;
        }
    }
}

