/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.ve_gl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    public static final String a = "GlUtil";

    private GlUtil() {
    }

    public static void checkNoGLES2Error(String string) {
        int n2 = GLES20.glGetError();
        if (n2 == 0) {
            return;
        }
        throw new RuntimeException(string + ": GLES20 error: " + n2);
    }

    public static void checkGlError(String string) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            new StringBuilder().append(string).append(": glError 0x").append(Integer.toHexString(n2));
        }
    }

    public static int createTexture(int n2, @Nullable Bitmap bitmap, int n3, int n4, int n5, int n6) {
        int n7 = n2;
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtil.checkGlError("glGenTextures");
        GLES20.glBindTexture((int)n2, (int)nArray[0]);
        GlUtil.checkGlError("glBindTexture " + nArray[0]);
        GLES20.glTexParameterf((int)n2, (int)10241, (float)n3);
        GLES20.glTexParameterf((int)n7, (int)10240, (float)n4);
        GLES20.glTexParameteri((int)n7, (int)10242, (int)n5);
        GLES20.glTexParameteri((int)n7, (int)10243, (int)n6);
        if (bitmap != null) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        GlUtil.checkGlError("glTexParameter");
        return nArray[0];
    }

    public static int createTexture(int n2) {
        return GlUtil.createTexture(n2, null, 9729, 9729, 33071, 33071);
    }

    public static int createTexture(int n2, Bitmap bitmap) {
        return GlUtil.createTexture(n2, bitmap, 9729, 9729, 33071, 33071);
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static int generateTexture(int n2) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n3 = nArray[0];
        int n4 = n2;
        GLES20.glBindTexture((int)n4, (int)n3);
        GLES20.glTexParameterf((int)n4, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n4, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n4, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n4, (int)10243, (float)33071.0f);
        GlUtil.checkNoGLES2Error("generateTexture");
        return n3;
    }

    public static int generateFrameBuffer(int n2) {
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        int n3 = nArray[0];
        GLES20.glBindFramebuffer((int)36160, (int)n3);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n2, (int)0);
        if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
            return -1;
        }
        GlUtil.checkNoGLES2Error("generateFrameBuffer");
        return n3;
    }
}

