/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.utils;

import android.text.TextPaint;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class StringUtils {
    public static final String EMPTY = "";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd hh:mm:ss";
    private static final String DEFAULT_FILE_PATTERN = "yyyy-MM-dd-HH-mm-ss";
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    public static final SimpleDateFormat DATE_FORMAT_PART = new SimpleDateFormat("HH:mm");
    private static final StringBuffer sStringBuilder = new StringBuffer();

    public static String getCurrentTimeString() {
        return DATE_FORMAT_PART.format(Calendar.getInstance().getTime());
    }

    public static char chatAt(String string, int n2) {
        if (string != null && string.length() > 0) {
            return string.charAt(n2);
        }
        return ' ';
    }

    public static float GetTextWidth(String string, float f2) {
        TextPaint textPaint;
        if (StringUtils.isEmpty(string)) {
            return 0.0f;
        }
        TextPaint textPaint2 = textPaint;
        textPaint2();
        textPaint2.setTextSize(f2);
        return textPaint.measureText(string.trim()) + (float)((int)((double)f2 * 0.1));
    }

    public static String formatDate(Date date, String string) {
        return new SimpleDateFormat(string).format(date);
    }

    public static String formatDate(long l2, String string) {
        return new SimpleDateFormat(string).format(new Date(l2));
    }

    public static String formatDate(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATE_PATTERN);
    }

    public static String formatDate(long l2) {
        return StringUtils.formatDate(new Date(l2), DEFAULT_DATE_PATTERN);
    }

    public static String getDate() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATE_PATTERN);
    }

    public static String createFileName() {
        Date date;
        Date date2 = date;
        date = new Date(System.currentTimeMillis());
        return new SimpleDateFormat(DEFAULT_FILE_PATTERN).format(date2);
    }

    public static String getDateTime() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(long l2) {
        return StringUtils.formatDate(new Date(l2), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatGMTDate(String string) {
        return StringUtils.formatDate(Calendar.getInstance(TimeZone.getTimeZone(string)).getTimeInMillis());
    }

    public static String join(ArrayList<String> object, String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if (object != null && ((ArrayList)object).size() > 0) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                stringBuffer2.append((String)object.next());
                stringBuffer2.append(string);
            }
            StringBuffer stringBuffer3 = stringBuffer2;
            int n2 = stringBuffer3.length() - 1;
            stringBuffer3.delete(n2, stringBuffer3.length());
        }
        return stringBuffer2.toString();
    }

    public static String join(Iterator<String> iterator, String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if (iterator != null) {
            while (iterator.hasNext()) {
                stringBuffer2.append(iterator.next());
                stringBuffer2.append(string);
            }
            if (stringBuffer2.length() > 0) {
                StringBuffer stringBuffer3 = stringBuffer2;
                int n2 = stringBuffer3.length() - 1;
                stringBuffer3.delete(n2, stringBuffer3.length());
            }
        }
        return stringBuffer2.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0 || string.equalsIgnoreCase("null");
    }

    public static String trim(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String generateTime(long l2) {
        String string;
        long l3 = l2;
        int n2 = (int)(l3 % 1000L);
        int n3 = (int)(l3 / 1000L);
        int n4 = n3 % 60;
        int n5 = n3 / 60 % 60;
        int n6 = n3 / 3600;
        if (n6 > 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n6;
            objectArray2[1] = n5;
            objectArray[2] = n4;
            string = String.format("%02d:%02d:%02d", objectArray2);
        } else if (n5 > 0) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = n5;
            objectArray[1] = n4;
            string = String.format("%02d:%02d", objectArray3);
        } else if (n3 > 0) {
            Object[] objectArray = new Object[2];
            Object[] objectArray4 = objectArray;
            objectArray4[0] = n3;
            objectArray[1] = n2;
            string = String.format("%02d''%02d", objectArray4);
        } else {
            Object[] objectArray = new Object[1];
            Object[] objectArray5 = objectArray;
            objectArray[0] = n2;
            string = String.format("''%02d", objectArray5);
        }
        return string;
    }

    public static String generateMillisTime(int n2) {
        String string;
        int n3 = n2;
        n2 = n3 % 1000;
        int n4 = n3 / 1000;
        int n5 = n4 % 60;
        int n6 = n4 / 60 % 60;
        if (n6 > 0) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n6;
            objectArray[1] = n5;
            string = String.format("%02d:%02d", objectArray2);
        } else if (n5 > 0) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = n5;
            objectArray[1] = n2;
            string = String.format("%02d''%02d", objectArray3);
        } else {
            Object[] objectArray = new Object[1];
            Object[] objectArray4 = objectArray;
            objectArray[0] = n2;
            string = String.format("''%02d", objectArray4);
        }
        return string;
    }

    public static String generateStandardTime(int n2) {
        int n3 = n2 / 1000;
        n2 = n3 % 60;
        int n4 = n3 / 60 % 60;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n4;
        objectArray[1] = n2;
        return String.format("%02d:%02d", objectArray2);
    }

    public static String generateFileSize(long l2) {
        String string;
        double d2;
        double d3 = l2;
        if (d2 < 1024.0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            string = stringBuilder.append(l2).append("B").toString();
        } else if (d3 < 1048576.0) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = d3 / 1024.0;
            string = String.format("%.1f", objectArray2) + "KB";
        } else if (d3 < 1.073741824E9) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = d3 / 1048576.0;
            string = String.format("%.1f", objectArray3) + "MB";
        } else {
            Object[] objectArray = new Object[1];
            Object[] objectArray4 = objectArray;
            objectArray[0] = d3 / 1.073741824E9;
            string = String.format("%.1f", objectArray4) + "GB";
        }
        return string;
    }

    public static String findString(String string, String string2, String string3) {
        int n2;
        String string4 = string2;
        int n3 = string4.length();
        int n4 = StringUtils.isEmpty(string4) ? 0 : string.indexOf(string2);
        if (n4 > -1 && (n2 = StringUtils.isEmpty(string3) ? -1 : string.indexOf(string3, n4 + n3)) > -1) {
            return string.substring(n4 + string2.length(), n2);
        }
        return EMPTY;
    }

    public static String substring(String string, String string2, String string3, String string4) {
        String string5 = string2;
        int n2 = string5.length();
        int n3 = StringUtils.isEmpty(string5) ? 0 : string.indexOf(string2);
        if (n3 > -1) {
            int n4 = StringUtils.isEmpty(string3) ? -1 : string.indexOf(string3, n3 + n2);
            if (n4 > -1) {
                return string.substring(n3 + string2.length(), n4);
            }
            return string.substring(n3 + string2.length());
        }
        return string4;
    }

    public static String substring(String string, String string2, String string3) {
        return StringUtils.substring(string, string2, string3, EMPTY);
    }

    public static String makeSafe(String string) {
        if (string == null) {
            string = EMPTY;
        }
        return string;
    }

    public static boolean canParseInt(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("\\d+");
    }

    public static String contact(String ... stringArray) {
        StringBuffer stringBuffer = sStringBuilder;
        stringBuffer.delete(0, stringBuffer.length());
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sStringBuilder.append(stringArray[i2]);
        }
        return sStringBuilder.toString();
    }
}

