/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.program;

import android.opengl.GLES20;
import com.meihu.beautylibrary.program.FBO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class ProgramYuv {
    public static final String TAG = "ProgramYuv";
    private static final String VERTEX_SHADER = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position =  aPosition;\n    vTextureCoord =  aTextureCoord.xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision highp float;\nprecision highp int;\n\nvarying vec2 vTextureCoord;\nuniform sampler2D uTexture;\n\nuniform float uWidth;\nuniform float uHeight;\n\nfloat cY(float x,float y){\n    vec4 c=texture2D(uTexture,vec2(x,y));\n    return c.r*0.257+c.g*0.504+c.b*0.098+0.0625;\n}\n\nvec4 cC(float x,float y,float dx,float dy){\n    vec4 c0=texture2D(uTexture,vec2(x,y));\n    vec4 c1=texture2D(uTexture,vec2(x+dx,y));\n    vec4 c2=texture2D(uTexture,vec2(x,y+dy));\n    vec4 c3=texture2D(uTexture,vec2(x+dx,y+dy));\n    return (c0+c1+c2+c3)/4.;\n}\n\nfloat cU(float x,float y,float dx,float dy){\n    vec4 c=cC(x,y,dx,dy);\n    return -0.148*c.r - 0.291*c.g + 0.439*c.b+0.5000;\n}\n\nfloat cV(float x,float y,float dx,float dy){\n    vec4 c=cC(x,y,dx,dy);\n    return 0.439*c.r - 0.368*c.g - 0.071*c.b+0.5000;\n}\n\nvec2 cPos(float t,float shiftx,float gy){\n    vec2 pos=vec2(floor(uWidth*vTextureCoord.x),floor(uHeight*gy));\n    return vec2(mod(pos.x*shiftx,uWidth),(pos.y*shiftx+floor(pos.x*shiftx/uWidth))*t);\n}\n\nvec4 calculateY(){\n    vec2 pos=cPos(1.,4.,vTextureCoord.y);\n    vec4 oColor=vec4(0);\n    float textureYPos=pos.y/uHeight;\n    oColor[0]=cY(pos.x/uWidth,textureYPos);\n    oColor[1]=cY((pos.x+1.)/uWidth,textureYPos);\n    oColor[2]=cY((pos.x+2.)/uWidth,textureYPos);\n    oColor[3]=cY((pos.x+3.)/uWidth,textureYPos);\n    return oColor;\n}\nvec4 calculateU(float gy,float dx,float dy){\n    vec2 pos=cPos(2.,8.,vTextureCoord.y-gy);\n    vec4 oColor=vec4(0);\n    float textureYPos=pos.y/uHeight;\n    oColor[0]= cU(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[1]= cU((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    oColor[2]= cU((pos.x+4.)/uWidth,textureYPos,dx,dy);\n    oColor[3]= cU((pos.x+6.)/uWidth,textureYPos,dx,dy);\n    return oColor;\n}\nvec4 calculateV(float gy,float dx,float dy){\n    vec2 pos=cPos(2.,8.,vTextureCoord.y-gy);\n    vec4 oColor=vec4(0);\n    float textureYPos=pos.y/uHeight;\n    oColor[0]=cV(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[1]=cV((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    oColor[2]=cV((pos.x+4.)/uWidth,textureYPos,dx,dy);\n    oColor[3]=cV((pos.x+6.)/uWidth,textureYPos,dx,dy);\n    return oColor;\n}\nvec4 calculateUV(float dx,float dy){\n    vec2 pos=cPos(2.,4.,vTextureCoord.y-0.2500);\n    vec4 oColor=vec4(0);\n    float textureYPos=pos.y/uHeight;\n    oColor[0]= cU(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[1]= cV(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[2]= cU((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    oColor[3]= cV((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    return oColor;\n}\nvec4 calculateVU(float dx,float dy){\n    vec2 pos=cPos(2.,4.,vTextureCoord.y-0.2500);\n    vec4 oColor=vec4(0);\n    float textureYPos=pos.y/uHeight;\n    oColor[0]= cV(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[1]= cU(pos.x/uWidth,textureYPos,dx,dy);\n    oColor[2]= cV((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    oColor[3]= cU((pos.x+2.)/uWidth,textureYPos,dx,dy);\n    return oColor;\n}\nvoid main() {\n    if(vTextureCoord.y<0.2500){\n        gl_FragColor=calculateY();\n    }else if(vTextureCoord.y<0.3750){\n        gl_FragColor=calculateVU(1./uWidth,1./uHeight);\n    }else{\n        gl_FragColor=vec4(0,0,0,0);\n    }\n}\n";
    private int program;
    private int vertShader;
    private int fragShader;
    private boolean mMirror;
    private int mAngle;
    private ByteBuffer mTempBuffer;
    private byte[] tempBuffer;
    private float[] SQUARE_COORDS;
    private float[] TEXTURE_COORDS;
    private float[] TEXTURE_COORDS_90;
    private float[] TEXTURE_COORDS_270;
    private float[] TEXTURE_COORDS_180;
    private FBO mFBO;
    private FloatBuffer VERTEX_BUF;
    private FloatBuffer TEXTURE_COORD_BUF;

    public ProgramYuv() {
        float[] fArray = new float[8];
        Object object = fArray;
        fArray[0] = 1.0f;
        fArray[1] = -1.0f;
        fArray[2] = -1.0f;
        fArray[3] = -1.0f;
        fArray[4] = 1.0f;
        fArray[5] = 1.0f;
        fArray[6] = -1.0f;
        fArray[7] = 1.0f;
        v1.SQUARE_COORDS = (float[])object;
        float[] fArray2 = new float[8];
        object = fArray2;
        fArray2[0] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 1.0f;
        fArray2[3] = 0.0f;
        fArray2[4] = 0.0f;
        fArray2[5] = 1.0f;
        fArray2[6] = 1.0f;
        fArray2[7] = 1.0f;
        v1.TEXTURE_COORDS = (float[])object;
        float[] fArray3 = new float[8];
        object = fArray3;
        fArray3[0] = 1.0f;
        fArray3[1] = 0.0f;
        fArray3[2] = 1.0f;
        fArray3[3] = 1.0f;
        fArray3[4] = 0.0f;
        fArray3[5] = 0.0f;
        fArray3[6] = 0.0f;
        fArray3[7] = 1.0f;
        v1.TEXTURE_COORDS_90 = (float[])object;
        float[] fArray4 = new float[8];
        object = fArray4;
        fArray4[0] = 0.0f;
        fArray4[1] = 1.0f;
        fArray4[2] = 0.0f;
        fArray4[3] = 0.0f;
        fArray4[4] = 1.0f;
        fArray4[5] = 1.0f;
        fArray4[6] = 1.0f;
        fArray4[7] = 0.0f;
        v1.TEXTURE_COORDS_270 = (float[])object;
        float[] fArray5 = new float[8];
        object = fArray5;
        fArray5[0] = 1.0f;
        fArray5[1] = 1.0f;
        fArray5[2] = 0.0f;
        fArray5[3] = 1.0f;
        fArray5[4] = 1.0f;
        fArray5[5] = 0.0f;
        fArray5[6] = 0.0f;
        fArray5[7] = 0.0f;
        v1.TEXTURE_COORDS_180 = (float[])object;
    }

    private void initProgram() {
        int n2;
        ProgramYuv programYuv = this;
        programYuv.vertShader = programYuv.compileShader(35633, VERTEX_SHADER);
        programYuv.fragShader = programYuv.compileShader(35632, FRAGMENT_SHADER_2D);
        this.program = n2 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n2, (int)this.vertShader);
        GLES20.glAttachShader((int)programYuv.program, (int)this.fragShader);
        programYuv.link();
        if (programYuv.VERTEX_BUF == null) {
            FloatBuffer floatBuffer;
            ProgramYuv programYuv2 = this;
            this.VERTEX_BUF = floatBuffer = ByteBuffer.allocateDirect(programYuv2.SQUARE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(this.SQUARE_COORDS);
            programYuv2.VERTEX_BUF.position(0);
        }
        if (this.TEXTURE_COORD_BUF == null) {
            FloatBuffer floatBuffer;
            ProgramYuv programYuv3 = this;
            this.TEXTURE_COORD_BUF = floatBuffer = ByteBuffer.allocateDirect(programYuv3.TEXTURE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(this.TEXTURE_COORDS);
            programYuv3.TEXTURE_COORD_BUF.position(0);
        }
    }

    private int compileShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            int n4 = n3;
            GLES20.glShaderSource((int)n4, (String)string);
            GLES20.glCompileShader((int)n4);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                new StringBuilder().append("shader complie error : ").append(GLES20.glGetShaderInfoLog((int)n3));
                GLES20.glDeleteShader((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    private int attributeIndex(String string) {
        return GLES20.glGetAttribLocation((int)this.program, (String)string);
    }

    private int uniformIndex(String string) {
        return GLES20.glGetUniformLocation((int)this.program, (String)string);
    }

    private boolean link() {
        GLES20.glLinkProgram((int)this.program);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            new StringBuilder().append("link program error : ").append(GLES20.glGetProgramInfoLog((int)this.program));
            int n2 = this.vertShader;
            if (n2 > 0) {
                GLES20.glDeleteShader((int)n2);
                this.vertShader = 0;
            }
            if ((n2 = this.fragShader) > 0) {
                GLES20.glDeleteShader((int)n2);
                this.fragShader = 0;
            }
            return false;
        }
        return true;
    }

    private void use() {
        GLES20.glUseProgram((int)this.program);
    }

    public ProgramYuv setAngle(int n2) {
        this.mAngle = n2;
        if (n2 != 90) {
            if (n2 != 180) {
                if (n2 == 270) {
                    this.TEXTURE_COORDS = this.TEXTURE_COORDS_270;
                }
            } else {
                this.TEXTURE_COORDS = this.TEXTURE_COORDS_180;
            }
        } else {
            this.TEXTURE_COORDS = this.TEXTURE_COORDS_90;
        }
        return this;
    }

    public ProgramYuv setMirror(boolean bl) {
        this.mMirror = bl;
        if (bl) {
            float[] fArray = this.TEXTURE_COORDS;
            fArray[0] = 1.0f - this.TEXTURE_COORDS[0];
            fArray[2] = 1.0f - this.TEXTURE_COORDS[2];
            fArray[4] = 1.0f - this.TEXTURE_COORDS[4];
            fArray[6] = 1.0f - this.TEXTURE_COORDS[6];
        }
        return this;
    }

    public ProgramYuv setMirror2(boolean bl) {
        this.mMirror = bl;
        if (bl) {
            float[] fArray = this.TEXTURE_COORDS;
            fArray[1] = 1.0f - this.TEXTURE_COORDS[1];
            fArray[3] = 1.0f - this.TEXTURE_COORDS[3];
            fArray[5] = 1.0f - this.TEXTURE_COORDS[5];
            fArray[7] = 1.0f - this.TEXTURE_COORDS[7];
        }
        return this;
    }

    public ProgramYuv init() {
        ProgramYuv programYuv = this;
        programYuv.initProgram();
        return programYuv;
    }

    public byte[] getBuffer(int n2, int n3, int n4) {
        if (((ProgramYuv)object2).mTempBuffer == null) {
            ProgramYuv programYuv = object2;
            int n5 = n3 * n4 * 3 / 2;
            programYuv.mTempBuffer = ByteBuffer.allocate(n5);
            programYuv.tempBuffer = new byte[n5];
        }
        ProgramYuv programYuv = object2;
        programYuv.use();
        Object object = programYuv.mFBO;
        if (object == null || ((FBO)object).getWidth() != n3 || ((ProgramYuv)object2).mFBO.getHeight() != n4) {
            FBO fBO;
            object = fBO;
            fBO = new FBO(n3, n4, 33984);
            ((ProgramYuv)object2).mFBO = object;
        }
        ProgramYuv programYuv2 = object2;
        int n6 = GLES20.glGetUniformLocation((int)programYuv2.program, (String)"uTexture");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glUniform1i((int)n6, (int)0);
        n2 = GLES20.glGetAttribLocation((int)programYuv2.program, (String)"aPosition");
        GLES20.glEnableVertexAttribArray((int)n2);
        object = ((ProgramYuv)object2).VERTEX_BUF;
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
        int n7 = GLES20.glGetAttribLocation((int)programYuv2.program, (String)"aTextureCoord");
        ProgramYuv programYuv3 = object2;
        ProgramYuv programYuv4 = object2;
        GLES20.glEnableVertexAttribArray((int)n7);
        FloatBuffer floatBuffer = ((ProgramYuv)object2).TEXTURE_COORD_BUF;
        GLES20.glVertexAttribPointer((int)n7, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)floatBuffer);
        GLES20.glUniform1f((int)GLES20.glGetUniformLocation((int)programYuv4.program, (String)"uWidth"), (float)n3);
        GLES20.glUniform1f((int)GLES20.glGetUniformLocation((int)programYuv4.program, (String)"uHeight"), (float)n4);
        programYuv4.mFBO.bind();
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        GLES20.glClear((int)16384);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        int n8 = n4 * 3 / 8;
        ByteBuffer byteBuffer = programYuv3.mTempBuffer;
        GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n8, (int)6408, (int)5121, (Buffer)byteBuffer);
        programYuv3.mFBO.unbind();
        GLES20.glDisableVertexAttribArray((int)n2);
        GLES20.glDisableVertexAttribArray((int)n7);
        GLES20.glUseProgram((int)0);
        Object object2 = ((ProgramYuv)object2).tempBuffer;
        n8 = n3 * n4 * 3 / 2;
        programYuv2.mTempBuffer.get((byte[])object2, 0, n8);
        programYuv2.mTempBuffer.clear();
        return programYuv2.tempBuffer;
    }

    public void destroy() {
        Object object;
        int n2 = this.vertShader;
        if (n2 > 0) {
            GLES20.glDeleteShader((int)n2);
            this.vertShader = 0;
        }
        if ((n2 = this.fragShader) > 0) {
            GLES20.glDeleteShader((int)n2);
            this.fragShader = 0;
        }
        if ((n2 = this.program) > 0) {
            GLES20.glDeleteProgram((int)n2);
            this.program = 0;
        }
        if ((object = this.mFBO) != null) {
            ((FBO)object).destroy();
            this.mFBO = null;
        }
        if ((object = this.VERTEX_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.VERTEX_BUF = null;
        }
        if ((object = this.TEXTURE_COORD_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.TEXTURE_COORD_BUF = null;
        }
    }
}

