/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.program;

import android.opengl.GLES20;
import com.meihu.beautylibrary.program.FBO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class ProgramTextureOES {
    public static final String TAG = "ProgramTextureOES";
    static final float[] SQUARE_COORDS = new float[]{1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    static final float[] TEXTURE_COORDS = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private static final String VERTEX_SHADER = "\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\n\nvarying vec2 vTextureCoord;\n\nvoid main() {\n\n    gl_Position = aPosition;\n    vTextureCoord =   aTextureCoord.xy;\n\n//    gl_Position = uMVPMatrix * aPosition;\n//    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n\n}";
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision mediump float; //\u6307\u5b9a\u9ed8\u8ba4\u7cbe\u5ea6\n\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES uTexture;\n\nvoid main() {\n    gl_FragColor = texture2D(uTexture, vTextureCoord);\n}";
    private int program;
    private int vertShader;
    private int fragShader;
    private FBO mFBO;
    private FloatBuffer VERTEX_BUF;
    private FloatBuffer TEXTURE_COORD_BUF;

    public ProgramTextureOES() {
        FloatBuffer floatBuffer;
        int n2;
        ProgramTextureOES programTextureOES = this;
        programTextureOES.vertShader = programTextureOES.compileShader(35633, VERTEX_SHADER);
        programTextureOES.fragShader = programTextureOES.compileShader(35632, FRAGMENT_SHADER_EXT);
        this.program = n2 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n2, (int)this.vertShader);
        GLES20.glAttachShader((int)programTextureOES.program, (int)this.fragShader);
        programTextureOES.link();
        if (programTextureOES.VERTEX_BUF == null) {
            float[] fArray = SQUARE_COORDS;
            this.VERTEX_BUF = floatBuffer = ByteBuffer.allocateDirect(SQUARE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(fArray);
            this.VERTEX_BUF.position(0);
        }
        if (this.TEXTURE_COORD_BUF == null) {
            float[] fArray = TEXTURE_COORDS;
            this.TEXTURE_COORD_BUF = floatBuffer = ByteBuffer.allocateDirect(TEXTURE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(fArray);
            this.TEXTURE_COORD_BUF.position(0);
        }
    }

    private int compileShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            int n4 = n3;
            GLES20.glShaderSource((int)n4, (String)string);
            GLES20.glCompileShader((int)n4);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                new StringBuilder().append("shader complie error : ").append(GLES20.glGetShaderInfoLog((int)n3));
                GLES20.glDeleteShader((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    public int attributeIndex(String string) {
        return GLES20.glGetAttribLocation((int)this.program, (String)string);
    }

    public int uniformIndex(String string) {
        return GLES20.glGetUniformLocation((int)this.program, (String)string);
    }

    public boolean link() {
        GLES20.glLinkProgram((int)this.program);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            new StringBuilder().append("link program error : ").append(GLES20.glGetProgramInfoLog((int)this.program));
            int n2 = this.vertShader;
            if (n2 > 0) {
                GLES20.glDeleteShader((int)n2);
                this.vertShader = 0;
            }
            if ((n2 = this.fragShader) > 0) {
                GLES20.glDeleteShader((int)n2);
                this.fragShader = 0;
            }
            return false;
        }
        return true;
    }

    public int getTexId(int n2, int n3, int n4) {
        ProgramTextureOES programTextureOES = floatBuffer;
        programTextureOES.use();
        Object object = programTextureOES.mFBO;
        if (object == null || ((FBO)object).getWidth() != n3 || ((ProgramTextureOES)((Object)floatBuffer)).mFBO.getHeight() != n4) {
            FBO fBO;
            object = fBO;
            fBO = new FBO(n3, n4, 33984);
            ((ProgramTextureOES)((Object)floatBuffer)).mFBO = object;
        }
        ProgramTextureOES programTextureOES2 = floatBuffer;
        int n5 = GLES20.glGetUniformLocation((int)programTextureOES2.program, (String)"uTexture");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        GLES20.glUniform1i((int)n5, (int)0);
        n2 = GLES20.glGetAttribLocation((int)programTextureOES2.program, (String)"aPosition");
        GLES20.glEnableVertexAttribArray((int)n2);
        object = ((ProgramTextureOES)((Object)floatBuffer)).VERTEX_BUF;
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
        int n6 = GLES20.glGetAttribLocation((int)programTextureOES2.program, (String)"aTextureCoord");
        ProgramTextureOES programTextureOES3 = floatBuffer;
        GLES20.glEnableVertexAttribArray((int)n6);
        FloatBuffer floatBuffer = ((ProgramTextureOES)((Object)floatBuffer)).TEXTURE_COORD_BUF;
        GLES20.glVertexAttribPointer((int)n6, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)floatBuffer);
        programTextureOES3.mFBO.bind();
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        GLES20.glClear((int)16384);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        programTextureOES3.mFBO.unbind();
        GLES20.glDisableVertexAttribArray((int)n2);
        GLES20.glDisableVertexAttribArray((int)n6);
        GLES20.glUseProgram((int)0);
        return programTextureOES2.mFBO.getTexId();
    }

    public void use() {
        GLES20.glUseProgram((int)this.program);
    }

    public void destroy() {
        Object object;
        int n2 = this.vertShader;
        if (n2 > 0) {
            GLES20.glDeleteShader((int)n2);
            this.vertShader = 0;
        }
        if ((n2 = this.fragShader) > 0) {
            GLES20.glDeleteShader((int)n2);
            this.fragShader = 0;
        }
        if ((n2 = this.program) > 0) {
            GLES20.glDeleteProgram((int)n2);
            this.program = 0;
        }
        if ((object = this.mFBO) != null) {
            ((FBO)object).destroy();
            this.mFBO = null;
        }
        if ((object = this.VERTEX_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.VERTEX_BUF = null;
        }
        if ((object = this.TEXTURE_COORD_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.TEXTURE_COORD_BUF = null;
        }
    }
}

