/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.beautylibrary.program;

import android.opengl.GLES20;
import com.meihu.beautylibrary.program.FBO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class ProgramTexture2d {
    public static final String TAG = "ProgramTexture2d";
    private static final String VERTEX_SHADER = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position =  aPosition;\n    vTextureCoord =  aTextureCoord.xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision highp float;\nvarying highp vec2 vTextureCoord;\nuniform sampler2D uTexture;\nvoid main() {\n    gl_FragColor = texture2D(uTexture, vTextureCoord);\n}\n";
    private int program;
    private int vertShader;
    private int fragShader;
    private boolean mMirror;
    private int mAngle;
    private float[] SQUARE_COORDS;
    private float[] TEXTURE_COORDS;
    private float[] TEXTURE_COORDS_90;
    private float[] TEXTURE_COORDS_270;
    private float[] TEXTURE_COORDS_180;
    private FBO mFBO;
    private FloatBuffer VERTEX_BUF;
    private FloatBuffer TEXTURE_COORD_BUF;

    public ProgramTexture2d() {
        float[] fArray = new float[8];
        Object object = fArray;
        fArray[0] = 1.0f;
        fArray[1] = -1.0f;
        fArray[2] = -1.0f;
        fArray[3] = -1.0f;
        fArray[4] = 1.0f;
        fArray[5] = 1.0f;
        fArray[6] = -1.0f;
        fArray[7] = 1.0f;
        v1.SQUARE_COORDS = (float[])object;
        float[] fArray2 = new float[8];
        object = fArray2;
        fArray2[0] = 0.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 1.0f;
        fArray2[3] = 0.0f;
        fArray2[4] = 0.0f;
        fArray2[5] = 1.0f;
        fArray2[6] = 1.0f;
        fArray2[7] = 1.0f;
        v1.TEXTURE_COORDS = (float[])object;
        float[] fArray3 = new float[8];
        object = fArray3;
        fArray3[0] = 1.0f;
        fArray3[1] = 0.0f;
        fArray3[2] = 1.0f;
        fArray3[3] = 1.0f;
        fArray3[4] = 0.0f;
        fArray3[5] = 0.0f;
        fArray3[6] = 0.0f;
        fArray3[7] = 1.0f;
        v1.TEXTURE_COORDS_90 = (float[])object;
        float[] fArray4 = new float[8];
        object = fArray4;
        fArray4[0] = 0.0f;
        fArray4[1] = 1.0f;
        fArray4[2] = 0.0f;
        fArray4[3] = 0.0f;
        fArray4[4] = 1.0f;
        fArray4[5] = 1.0f;
        fArray4[6] = 1.0f;
        fArray4[7] = 0.0f;
        v1.TEXTURE_COORDS_270 = (float[])object;
        float[] fArray5 = new float[8];
        object = fArray5;
        fArray5[0] = 1.0f;
        fArray5[1] = 1.0f;
        fArray5[2] = 0.0f;
        fArray5[3] = 1.0f;
        fArray5[4] = 1.0f;
        fArray5[5] = 0.0f;
        fArray5[6] = 0.0f;
        fArray5[7] = 0.0f;
        v1.TEXTURE_COORDS_180 = (float[])object;
    }

    private void initProgram() {
        int n2;
        ProgramTexture2d programTexture2d = this;
        programTexture2d.vertShader = programTexture2d.compileShader(35633, VERTEX_SHADER);
        programTexture2d.fragShader = programTexture2d.compileShader(35632, FRAGMENT_SHADER_2D);
        this.program = n2 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n2, (int)this.vertShader);
        GLES20.glAttachShader((int)programTexture2d.program, (int)this.fragShader);
        programTexture2d.link();
        if (programTexture2d.VERTEX_BUF == null) {
            FloatBuffer floatBuffer;
            ProgramTexture2d programTexture2d2 = this;
            this.VERTEX_BUF = floatBuffer = ByteBuffer.allocateDirect(programTexture2d2.SQUARE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(this.SQUARE_COORDS);
            programTexture2d2.VERTEX_BUF.position(0);
        }
        if (this.TEXTURE_COORD_BUF == null) {
            FloatBuffer floatBuffer;
            ProgramTexture2d programTexture2d3 = this;
            this.TEXTURE_COORD_BUF = floatBuffer = ByteBuffer.allocateDirect(programTexture2d3.TEXTURE_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(this.TEXTURE_COORDS);
            programTexture2d3.TEXTURE_COORD_BUF.position(0);
        }
    }

    private int compileShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            int n4 = n3;
            GLES20.glShaderSource((int)n4, (String)string);
            GLES20.glCompileShader((int)n4);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                new StringBuilder().append("shader complie error : ").append(GLES20.glGetShaderInfoLog((int)n3));
                GLES20.glDeleteShader((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    private int attributeIndex(String string) {
        return GLES20.glGetAttribLocation((int)this.program, (String)string);
    }

    private int uniformIndex(String string) {
        return GLES20.glGetUniformLocation((int)this.program, (String)string);
    }

    private boolean link() {
        GLES20.glLinkProgram((int)this.program);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            new StringBuilder().append("link program error : ").append(GLES20.glGetProgramInfoLog((int)this.program));
            int n2 = this.vertShader;
            if (n2 > 0) {
                GLES20.glDeleteShader((int)n2);
                this.vertShader = 0;
            }
            if ((n2 = this.fragShader) > 0) {
                GLES20.glDeleteShader((int)n2);
                this.fragShader = 0;
            }
            return false;
        }
        return true;
    }

    private void use() {
        GLES20.glUseProgram((int)this.program);
    }

    public ProgramTexture2d setAngle(int n2) {
        this.mAngle = n2;
        if (n2 != 90) {
            if (n2 != 180) {
                if (n2 == 270) {
                    this.TEXTURE_COORDS = this.TEXTURE_COORDS_270;
                }
            } else {
                this.TEXTURE_COORDS = this.TEXTURE_COORDS_180;
            }
        } else {
            this.TEXTURE_COORDS = this.TEXTURE_COORDS_90;
        }
        return this;
    }

    public ProgramTexture2d setMirror(boolean bl) {
        this.mMirror = bl;
        if (bl) {
            float[] fArray = this.TEXTURE_COORDS;
            fArray[0] = 1.0f - this.TEXTURE_COORDS[0];
            fArray[2] = 1.0f - this.TEXTURE_COORDS[2];
            fArray[4] = 1.0f - this.TEXTURE_COORDS[4];
            fArray[6] = 1.0f - this.TEXTURE_COORDS[6];
        }
        return this;
    }

    public ProgramTexture2d setMirror2(boolean bl) {
        this.mMirror = bl;
        if (bl) {
            float[] fArray = this.TEXTURE_COORDS;
            fArray[1] = 1.0f - this.TEXTURE_COORDS[1];
            fArray[3] = 1.0f - this.TEXTURE_COORDS[3];
            fArray[5] = 1.0f - this.TEXTURE_COORDS[5];
            fArray[7] = 1.0f - this.TEXTURE_COORDS[7];
        }
        return this;
    }

    public ProgramTexture2d init() {
        ProgramTexture2d programTexture2d = this;
        programTexture2d.initProgram();
        return programTexture2d;
    }

    public int getTexId(int n2, int n3, int n4) {
        ProgramTexture2d programTexture2d = floatBuffer;
        programTexture2d.use();
        Object object = programTexture2d.mFBO;
        if (object == null || ((FBO)object).getWidth() != n3 || ((ProgramTexture2d)((Object)floatBuffer)).mFBO.getHeight() != n4) {
            FBO fBO;
            object = fBO;
            fBO = new FBO(n3, n4, 33984);
            ((ProgramTexture2d)((Object)floatBuffer)).mFBO = object;
        }
        ProgramTexture2d programTexture2d2 = floatBuffer;
        int n5 = GLES20.glGetUniformLocation((int)programTexture2d2.program, (String)"uTexture");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glUniform1i((int)n5, (int)0);
        n2 = GLES20.glGetAttribLocation((int)programTexture2d2.program, (String)"aPosition");
        GLES20.glEnableVertexAttribArray((int)n2);
        object = ((ProgramTexture2d)((Object)floatBuffer)).VERTEX_BUF;
        GLES20.glVertexAttribPointer((int)n2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
        int n6 = GLES20.glGetAttribLocation((int)programTexture2d2.program, (String)"aTextureCoord");
        ProgramTexture2d programTexture2d3 = floatBuffer;
        GLES20.glEnableVertexAttribArray((int)n6);
        FloatBuffer floatBuffer = ((ProgramTexture2d)((Object)floatBuffer)).TEXTURE_COORD_BUF;
        GLES20.glVertexAttribPointer((int)n6, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)floatBuffer);
        programTexture2d3.mFBO.bind();
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        GLES20.glClear((int)16384);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        programTexture2d3.mFBO.unbind();
        GLES20.glDisableVertexAttribArray((int)n2);
        GLES20.glDisableVertexAttribArray((int)n6);
        GLES20.glUseProgram((int)0);
        return programTexture2d2.mFBO.getTexId();
    }

    public void destroy() {
        Object object;
        int n2 = this.vertShader;
        if (n2 > 0) {
            GLES20.glDeleteShader((int)n2);
            this.vertShader = 0;
        }
        if ((n2 = this.fragShader) > 0) {
            GLES20.glDeleteShader((int)n2);
            this.fragShader = 0;
        }
        if ((n2 = this.program) > 0) {
            GLES20.glDeleteProgram((int)n2);
            this.program = 0;
        }
        if ((object = this.mFBO) != null) {
            ((FBO)object).destroy();
            this.mFBO = null;
        }
        if ((object = this.VERTEX_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.VERTEX_BUF = null;
        }
        if ((object = this.TEXTURE_COORD_BUF) != null) {
            ((FloatBuffer)object).clear();
            this.TEXTURE_COORD_BUF = null;
        }
    }
}

