/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.download;

import com.meihu.kalle.BodyRequest;
import com.meihu.kalle.Canceller;
import com.meihu.kalle.RequestMethod;
import com.meihu.kalle.Url;
import com.meihu.kalle.download.BodyWorker;
import com.meihu.kalle.download.Callback;
import com.meihu.kalle.download.Download;
import com.meihu.kalle.download.DownloadManager;

public class BodyDownload
extends BodyRequest
implements Download {
    private final String mDirectory;
    private final String mFileName;
    private final Download.ProgressBar mProgressBar;
    private final Download.Policy mPolicy;

    public static Api newApi(Url url, RequestMethod requestMethod) {
        return new Api(url, requestMethod);
    }

    private BodyDownload(Api object) {
        super((BodyRequest.Api)object);
        this.mDirectory = ((Api)object).mDirectory;
        this.mFileName = ((Api)object).mFileName;
        Download.ProgressBar progressBar = ((Api)object).mProgressBar == null ? Download.ProgressBar.DEFAULT : ((Api)object).mProgressBar;
        this.mProgressBar = progressBar;
        object = ((Api)object).mPolicy == null ? Download.Policy.DEFAULT : ((Api)object).mPolicy;
        this.mPolicy = object;
    }

    @Override
    public String directory() {
        return this.mDirectory;
    }

    @Override
    public String fileName() {
        return this.mFileName;
    }

    @Override
    public Download.ProgressBar progressBar() {
        return this.mProgressBar;
    }

    @Override
    public Download.Policy policy() {
        return this.mPolicy;
    }

    public static class Api
    extends BodyRequest.Api<Api> {
        private String mDirectory;
        private String mFileName;
        private Download.ProgressBar mProgressBar;
        private Download.Policy mPolicy;

        private Api(Url url, RequestMethod requestMethod) {
            super(url, requestMethod);
        }

        public Api directory(String string) {
            this.mDirectory = string;
            return this;
        }

        public Api fileName(String string) {
            this.mFileName = string;
            return this;
        }

        public Api onProgress(Download.ProgressBar progressBar) {
            this.mProgressBar = progressBar;
            return this;
        }

        public Api policy(Download.Policy policy) {
            this.mPolicy = policy;
            return this;
        }

        public String perform() throws Exception {
            return new BodyWorker(new BodyDownload(this)).call();
        }

        public Canceller perform(Callback callback) {
            return DownloadManager.getInstance().perform(new BodyDownload(this), callback);
        }
    }
}

