/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import cn.qqtheme.framework.util.ConvertUtils;
import java.lang.reflect.Field;

public class StrokeTextView
extends TextView {
    private TextPaint textPaint;
    private boolean isStroke = false;
    private int borderWidth = 3;
    private int textColor = -1;
    private int borderColor = -16777216;

    public StrokeTextView(Context context) {
        super(context);
        this.init();
    }

    public StrokeTextView(Context context, boolean isStroke) {
        super(context);
        this.init();
        this.isStroke = isStroke;
    }

    public StrokeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StrokeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.textPaint = this.getPaint();
    }

    public void setStroke(boolean stroke) {
        this.isStroke = stroke;
        this.invalidate();
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.invalidate();
    }

    public void setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        super.setTextColor(textColor);
    }

    public void setTextColor(ColorStateList colors) {
        this.textColor = colors.getColorForState(this.getDrawableState(), this.textColor);
        super.setTextColor(colors);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isStroke) {
            super.onDraw(canvas);
            return;
        }
        if (this.textColor == this.borderColor) {
            this.borderColor = ConvertUtils.toDarkenColor(this.borderColor, 0.7f);
        }
        this.setTextColorUseReflection(this.borderColor);
        this.textPaint.setStrokeWidth((float)ConvertUtils.toPx(this.getContext(), this.borderWidth));
        this.textPaint.setStyle(Paint.Style.STROKE);
        this.textPaint.setFakeBoldText(true);
        super.onDraw(canvas);
        this.setTextColorUseReflection(this.textColor);
        this.textPaint.setStrokeWidth(0.0f);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setFakeBoldText(false);
        super.onDraw(canvas);
    }

    private void setTextColorUseReflection(@ColorInt int color) {
        try {
            Field field = TextView.class.getDeclaredField("mCurTextColor");
            field.setAccessible(true);
            field.set((Object)this, color);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.textPaint.setColor(color);
    }
}

