/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.util;

import com.meihu.kalle.Content;
import com.meihu.kalle.ProgressBar;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressOutputStream<T extends Content>
extends OutputStream {
    private OutputStream mWriter;
    private T mOrigin;
    private ProgressBar<T> mProgressBar;
    private long mContentLength;
    private long mWriteCount;
    private int mOldProgress;

    public ProgressOutputStream(OutputStream outputStream, T t2, ProgressBar<T> progressBar) {
        this.mWriter = outputStream;
        this.mOrigin = t2;
        this.mProgressBar = progressBar;
        this.mContentLength = t2.contentLength();
    }

    private void calcProgress() {
        int n2;
        long l2 = this.mContentLength;
        if (l2 > 0L && (n2 = (int)(this.mWriteCount * 100L / l2)) > this.mOldProgress && n2 % 2 == 0) {
            this.mOldProgress = n2;
            this.mProgressBar.progress(this.mOrigin, n2);
        }
    }

    @Override
    public void write(int n2) throws IOException {
        ProgressOutputStream progressOutputStream = this;
        progressOutputStream.mWriter.write(n2);
        ++progressOutputStream.mWriteCount;
        progressOutputStream.calcProgress();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        ProgressOutputStream progressOutputStream = this;
        progressOutputStream.mWriter.write(byArray);
        progressOutputStream.mWriteCount += (long)byArray.length;
        progressOutputStream.calcProgress();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        ProgressOutputStream progressOutputStream = this;
        progressOutputStream.mWriter.write(byArray, n2, n3);
        progressOutputStream.mWriteCount += (long)n3;
        progressOutputStream.calcProgress();
    }

    @Override
    public void flush() throws IOException {
        this.mWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }
}

