/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.ssl;

import android.os.Build;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TLSSocketFactory
extends SSLSocketFactory {
    private static final String[] PROTOCOL_ARRAY;
    private static final X509TrustManager DEFAULT_TRUST_MANAGERS;
    private SSLSocketFactory delegate;

    private static void setSupportProtocolAndCipherSuites(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(PROTOCOL_ARRAY);
        }
    }

    public TLSSocketFactory() {
        SecureRandom secureRandom;
        SSLContext sSLContext;
        try {
            sSLContext = SSLContext.getInstance("TLS");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError();
        }
        TrustManager[] trustManagerArray = new TrustManager[1];
        trustManagerArray[0] = DEFAULT_TRUST_MANAGERS;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        sSLContext.init(null, trustManagerArray, secureRandom2);
        this.delegate = sSLContext.getSocketFactory();
    }

    public TLSSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.delegate = sSLSocketFactory;
    }

    static {
        int n2 = Build.VERSION.SDK_INT;
        PROTOCOL_ARRAY = n2 >= 26 ? new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"} : (n2 >= 16 ? new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"} : new String[]{"SSLv3", "TLSv1"});
        DEFAULT_TRUST_MANAGERS = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        Socket socket2 = this.delegate.createSocket(socket, string, n2, bl);
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket2);
        return socket2;
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException {
        Socket socket = this.delegate.createSocket(string, n2);
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        Socket socket = this.delegate.createSocket(string, n2, inetAddress, n3);
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        Socket socket = this.delegate.createSocket(inetAddress, n2);
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Socket socket = this.delegate.createSocket(inetAddress, n2, inetAddress2, n3);
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket);
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.delegate.createSocket();
        TLSSocketFactory.setSupportProtocolAndCipherSuites(socket);
        return socket;
    }
}

