/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import com.meihu.kalle.KalleConfig;
import com.meihu.kalle.RequestMethod;
import com.meihu.kalle.Url;
import com.meihu.kalle.download.BodyDownload;
import com.meihu.kalle.download.DownloadManager;
import com.meihu.kalle.download.UrlDownload;
import com.meihu.kalle.simple.RequestManager;
import com.meihu.kalle.simple.SimpleBodyRequest;
import com.meihu.kalle.simple.SimpleUrlRequest;

public final class Kalle {
    private static KalleConfig sConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setConfig(KalleConfig kalleConfig) {
        if (sConfig != null) return;
        Class<KalleConfig> clazz = KalleConfig.class;
        synchronized (KalleConfig.class) {
            if (sConfig == null) {
                if (kalleConfig == null) {
                    kalleConfig = KalleConfig.newBuilder().build();
                }
                sConfig = kalleConfig;
            } else {
                new IllegalStateException("Only allowed to configure once.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static KalleConfig getConfig() {
        Kalle.setConfig(null);
        return sConfig;
    }

    public static SimpleUrlRequest.Api get(String string) {
        return SimpleUrlRequest.newApi(Url.newBuilder(string).build(), RequestMethod.GET);
    }

    public static SimpleUrlRequest.Api get(Url url) {
        return SimpleUrlRequest.newApi(url, RequestMethod.GET);
    }

    public static SimpleUrlRequest.Api head(String string) {
        return SimpleUrlRequest.newApi(Url.newBuilder(string).build(), RequestMethod.HEAD);
    }

    public static SimpleUrlRequest.Api head(Url url) {
        return SimpleUrlRequest.newApi(url, RequestMethod.HEAD);
    }

    public static SimpleUrlRequest.Api options(String string) {
        return SimpleUrlRequest.newApi(Url.newBuilder(string).build(), RequestMethod.OPTIONS);
    }

    public static SimpleUrlRequest.Api options(Url url) {
        return SimpleUrlRequest.newApi(url, RequestMethod.OPTIONS);
    }

    public static SimpleUrlRequest.Api trace(String string) {
        return SimpleUrlRequest.newApi(Url.newBuilder(string).build(), RequestMethod.TRACE);
    }

    public static SimpleUrlRequest.Api trace(Url url) {
        return SimpleUrlRequest.newApi(url, RequestMethod.TRACE);
    }

    public static SimpleBodyRequest.Api post(String string) {
        return SimpleBodyRequest.newApi(Url.newBuilder(string).build(), RequestMethod.POST);
    }

    public static SimpleBodyRequest.Api post(Url url) {
        return SimpleBodyRequest.newApi(url, RequestMethod.POST);
    }

    public static SimpleBodyRequest.Api put(String string) {
        return SimpleBodyRequest.newApi(Url.newBuilder(string).build(), RequestMethod.PUT);
    }

    public static SimpleBodyRequest.Api put(Url url) {
        return SimpleBodyRequest.newApi(url, RequestMethod.PUT);
    }

    public static SimpleBodyRequest.Api patch(String string) {
        return SimpleBodyRequest.newApi(Url.newBuilder(string).build(), RequestMethod.PATCH);
    }

    public static SimpleBodyRequest.Api patch(Url url) {
        return SimpleBodyRequest.newApi(url, RequestMethod.PATCH);
    }

    public static SimpleBodyRequest.Api delete(String string) {
        return SimpleBodyRequest.newApi(Url.newBuilder(string).build(), RequestMethod.DELETE);
    }

    public static SimpleBodyRequest.Api delete(Url url) {
        return SimpleBodyRequest.newApi(url, RequestMethod.DELETE);
    }

    public static void cancel(Object object) {
        RequestManager.getInstance().cancel(object);
    }

    public static void cancel() {
        RequestManager.getInstance().cancelAll();
    }

    private Kalle() {
    }

    public static class Download {
        public static UrlDownload.Api get(String string) {
            return UrlDownload.newApi(Url.newBuilder(string).build(), RequestMethod.GET);
        }

        public static UrlDownload.Api get(Url url) {
            return UrlDownload.newApi(url, RequestMethod.GET);
        }

        public static UrlDownload.Api head(String string) {
            return UrlDownload.newApi(Url.newBuilder(string).build(), RequestMethod.HEAD);
        }

        public static UrlDownload.Api head(Url url) {
            return UrlDownload.newApi(url, RequestMethod.HEAD);
        }

        public static UrlDownload.Api options(String string) {
            return UrlDownload.newApi(Url.newBuilder(string).build(), RequestMethod.OPTIONS);
        }

        public static UrlDownload.Api options(Url url) {
            return UrlDownload.newApi(url, RequestMethod.OPTIONS);
        }

        public static UrlDownload.Api trace(String string) {
            return UrlDownload.newApi(Url.newBuilder(string).build(), RequestMethod.TRACE);
        }

        public static UrlDownload.Api trace(Url url) {
            return UrlDownload.newApi(url, RequestMethod.TRACE);
        }

        public static BodyDownload.Api post(String string) {
            return BodyDownload.newApi(Url.newBuilder(string).build(), RequestMethod.POST);
        }

        public static BodyDownload.Api post(Url url) {
            return BodyDownload.newApi(url, RequestMethod.POST);
        }

        public static BodyDownload.Api put(String string) {
            return BodyDownload.newApi(Url.newBuilder(string).build(), RequestMethod.PUT);
        }

        public static BodyDownload.Api put(Url url) {
            return BodyDownload.newApi(url, RequestMethod.PUT);
        }

        public static BodyDownload.Api patch(String string) {
            return BodyDownload.newApi(Url.newBuilder(string).build(), RequestMethod.PATCH);
        }

        public static BodyDownload.Api patch(Url url) {
            return BodyDownload.newApi(url, RequestMethod.PATCH);
        }

        public static BodyDownload.Api delete(String string) {
            return BodyDownload.newApi(Url.newBuilder(string).build(), RequestMethod.DELETE);
        }

        public static BodyDownload.Api delete(Url url) {
            return BodyDownload.newApi(url, RequestMethod.DELETE);
        }

        public static void cancel(Object object) {
            DownloadManager.getInstance().cancel(object);
        }
    }
}

