/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.FileAsyncHttpResponseHandler;
import com.baidu.speech.utils.auth.HttpResponseEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public abstract class RangeFileAsyncHttpResponseHandler
extends FileAsyncHttpResponseHandler {
    private static final String TAG = "RangeFileAsyncHttpRH";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    private long current = 0L;
    private boolean append = false;

    public RangeFileAsyncHttpResponseHandler(File file) {
        super(file);
    }

    public void sendResponseMessage(HttpResponseEntity httpResponseEntity) {
        if (!Thread.currentThread().isInterrupted()) {
            int n = httpResponseEntity.getResponseCode();
            Map<String, List<String>> map = httpResponseEntity.getHeader();
            if (n == 416) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.onFailure(n, map, null, null);
                }
            } else if (n > 300) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.onFailure(n, map, new Exception("response failed "), null);
                }
            } else if (!Thread.currentThread().isInterrupted()) {
                List<String> list = map.get(HEADER_CONTENT_RANGE);
                if (list == null) {
                    this.append = false;
                    this.current = 0L;
                } else {
                    LogUtil.v(TAG, " HEADER_CONTENT_RANGE: " + list.get(0));
                }
                this.onSuccess(n, map, httpResponseEntity.getContentType(), this.getResponseData(httpResponseEntity));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getResponseData(HttpResponseEntity httpResponseEntity) {
        block6: {
            if (httpResponseEntity != null) {
                try {
                    InputStream inputStream = httpResponseEntity.getContent();
                    long l = httpResponseEntity.getContentLength();
                    FileOutputStream fileOutputStream = new FileOutputStream(this.getTargetFile(), this.append);
                    if (inputStream == null) break block6;
                    try {
                        byte[] byArray = new byte[4096];
                        int n = 0;
                        int n2 = 0;
                        while ((n = inputStream.read(byArray)) != -1 && !Thread.currentThread().isInterrupted()) {
                            fileOutputStream.write(byArray, 0, n);
                            this.onProgress(n2 += n, l);
                        }
                        Object var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        throw throwable;
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    {
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return new byte[0];
    }

    public void updateRequestHeaders(HttpURLConnection httpURLConnection) {
        if (this.file.exists() && this.file.canWrite()) {
            this.current = this.file.length();
        }
        if (this.current > 0L) {
            this.append = true;
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.current + "-");
        }
    }
}

