/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.auth.HttpResponseEntity;
import com.baidu.speech.utils.auth.RangeFileAsyncHttpResponseHandler;
import com.baidu.speech.utils.auth.ResponseHandlerInterface;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientUtil {
    private static final String TAG = "HttpClientUtil";
    private static final String REQUESTMETHOD_POST = "POST";
    private static final String REQUESTMETHOD_GET = "GET";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final int DEFAULT_TIMEOUT = 5000;
    private static SSLContext mSSLContext = null;
    private boolean isUrlEncodingEnabled = true;
    private int mTimeOut = 5000;
    private Proxy proxy = null;
    private String contentType = null;
    private int statusCode = -1;
    private HttpURLConnection httpURLConnection = null;
    private Map<String, String> headers = null;
    final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            String string2 = HttpClientUtil.convertHostname(string);
            if (hostnameVerifier.verify("tts.baidu.com", sSLSession) || hostnameVerifier.verify("tsn.baidu.com", sSLSession) || hostnameVerifier.verify("upl.baidu.com", sSLSession) || hostnameVerifier.verify("httpdns.baidubce.com", sSLSession) || hostnameVerifier.verify("httpsdns.baidu.com", sSLSession)) {
                return true;
            }
            return string2.contains(".baidu.");
        }
    };

    public void get(String string, ResponseHandlerInterface responseHandlerInterface) {
        this.makeRequest(string, "", REQUESTMETHOD_GET, responseHandlerInterface);
    }

    public void post(String string, String string2, ResponseHandlerInterface responseHandlerInterface) {
        this.makeRequest(string, string2, REQUESTMETHOD_POST, responseHandlerInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(String string, String string2, String string3, ResponseHandlerInterface responseHandlerInterface) {
        block28: {
            Map<String, List<String>> map = null;
            try {
                try {
                    URL uRL;
                    Object object;
                    if (!this.isUrlEncodingEnabled) {
                        object = URLDecoder.decode(string, "UTF-8");
                        uRL = new URL((String)object);
                    } else {
                        uRL = new URL(string);
                    }
                    if (uRL.getProtocol().toLowerCase().equals("https")) {
                        this.httpURLConnection = this.proxy != null ? (HttpsURLConnection)uRL.openConnection(this.proxy) : (HttpsURLConnection)uRL.openConnection();
                        ((HttpsURLConnection)this.httpURLConnection).setHostnameVerifier(this.DO_NOT_VERIFY);
                    } else {
                        this.httpURLConnection = this.proxy != null ? (HttpURLConnection)uRL.openConnection(this.proxy) : (HttpURLConnection)uRL.openConnection();
                    }
                    if (this.headers != null) {
                        for (String object2 : this.headers.keySet()) {
                            String string4 = this.headers.get(object2);
                            this.httpURLConnection.setRequestProperty(object2, string4);
                        }
                    }
                    if (responseHandlerInterface instanceof RangeFileAsyncHttpResponseHandler) {
                        LogUtil.d(TAG, "RangeFileAsyncHttpResponseHandler");
                        ((RangeFileAsyncHttpResponseHandler)responseHandlerInterface).updateRequestHeaders(this.httpURLConnection);
                    }
                    responseHandlerInterface.setRequestURI(URI.create(string));
                    this.httpURLConnection.setRequestMethod(string3);
                    this.httpURLConnection.setConnectTimeout(this.mTimeOut);
                    this.httpURLConnection.setReadTimeout(this.mTimeOut);
                    if (string3 == REQUESTMETHOD_POST) {
                        this.httpURLConnection.setDoInput(true);
                        this.httpURLConnection.setDoOutput(true);
                        object = this.httpURLConnection.getOutputStream();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                        bufferedOutputStream.write(string2.getBytes());
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        ((OutputStream)object).close();
                    } else {
                        this.httpURLConnection.setDoInput(true);
                    }
                    this.statusCode = this.httpURLConnection.getResponseCode();
                    LogUtil.d(TAG, "ResponseCode: " + this.statusCode);
                    this.contentType = this.httpURLConnection.getContentType();
                    map = this.httpURLConnection.getHeaderFields();
                    object = new HttpResponseEntity();
                    ((HttpResponseEntity)object).setContentLength(this.httpURLConnection.getContentLength());
                    ((HttpResponseEntity)object).setInputStream(this.httpURLConnection.getInputStream());
                    ((HttpResponseEntity)object).setHeader(map);
                    ((HttpResponseEntity)object).setContentEncoding(this.httpURLConnection.getContentEncoding());
                    ((HttpResponseEntity)object).setContentType(this.contentType);
                    ((HttpResponseEntity)object).setResponseCode(this.statusCode);
                    responseHandlerInterface.sendResponseMessage((HttpResponseEntity)object);
                }
                catch (MalformedURLException malformedURLException) {
                    if (responseHandlerInterface != null) {
                        responseHandlerInterface.sendErrorMessage(this.statusCode, map, this.contentType, malformedURLException);
                    }
                    malformedURLException.printStackTrace();
                    Object var11_17 = null;
                    if (this.httpURLConnection != null) {
                        this.httpURLConnection.disconnect();
                    }
                    break block28;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (responseHandlerInterface != null) {
                        responseHandlerInterface.sendErrorMessage(this.statusCode, map, this.contentType, socketTimeoutException);
                    }
                    socketTimeoutException.printStackTrace();
                    Object var11_18 = null;
                    if (this.httpURLConnection != null) {
                        this.httpURLConnection.disconnect();
                    }
                    break block28;
                }
                catch (InterruptedIOException interruptedIOException) {
                    LogUtil.d(TAG, interruptedIOException.toString());
                    Object var11_19 = null;
                    if (this.httpURLConnection != null) {
                        this.httpURLConnection.disconnect();
                    }
                    break block28;
                }
                catch (IOException iOException) {
                    if (responseHandlerInterface != null) {
                        responseHandlerInterface.sendErrorMessage(this.statusCode, map, this.contentType, iOException);
                    }
                    iOException.printStackTrace();
                    Object var11_20 = null;
                    if (this.httpURLConnection != null) {
                        this.httpURLConnection.disconnect();
                    }
                    break block28;
                }
                catch (Exception exception) {
                    if (responseHandlerInterface != null) {
                        responseHandlerInterface.sendErrorMessage(this.statusCode, map, this.contentType, exception);
                    }
                    Object var11_21 = null;
                    if (this.httpURLConnection != null) {
                        this.httpURLConnection.disconnect();
                    }
                }
                Object var11_16 = null;
                if (this.httpURLConnection != null) {
                    this.httpURLConnection.disconnect();
                }
            }
            catch (Throwable throwable) {
                Object var11_22 = null;
                if (this.httpURLConnection != null) {
                    this.httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    public void setTimeOut(int n) {
        this.mTimeOut = n = n < 1000 ? 5000 : n;
    }

    public int getTimeOut(int n) {
        return this.mTimeOut;
    }

    public void setProxy(String string, int n) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
    }

    public void setURLEncodingEnabled(boolean bl) {
        this.isUrlEncodingEnabled = bl;
    }

    public boolean isUrlEncodingEnabled() {
        return this.isUrlEncodingEnabled;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    private static String convertHostname(String string) {
        if ("vse.baidu.com".equals(string) || "vop.baidu.com".equals(string) || "openapi.baidu.com".equals(string) || "upl.baidu.com".equals(string)) {
            return string;
        }
        return string;
    }

    public void stop() {
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
        }
    }
}

