/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.auth;

import android.content.Context;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.Policy;
import com.baidu.speech.utils.Utility;
import com.baidu.speech.utils.auth.GetLicenseHandler;
import com.baidu.speech.utils.auth.HttpClientUtil;
import com.baidu.speech.utils.auth.KeyEnum;
import com.baidu.speech.utils.auth.SharedPreferencesUtils;
import com.baidu.speech.utils.auth.UrlEnum;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTtsLicenseWork
implements Callable<Integer> {
    private static final String TAG = "GetTtsLicenseWork";
    private String appCode;
    private String licenseFilePath;
    private String authSN;
    private Context mContext;

    public GetTtsLicenseWork(Context context, String string, String string2, String string3) {
        this.mContext = context;
        this.appCode = string;
        this.licenseFilePath = string2;
        this.authSN = string3;
    }

    @Override
    public Integer call() throws Exception {
        String string = UrlEnum.GETLICENSE_SERVER.getUrl();
        boolean bl = SharedPreferencesUtils.getBoolean(this.mContext, "isRegister", false);
        String string2 = SharedPreferencesUtils.getString(this.mContext, "SN", "");
        string = bl && string2.equals(this.authSN) ? string + "check?logid=" + System.currentTimeMillis() : string + "register?logid=" + System.currentTimeMillis();
        LogUtil.d(TAG, " isRegister:" + bl + "  getlicense url:" + string);
        HttpClientUtil httpClientUtil = new HttpClientUtil();
        GetLicenseHandler getLicenseHandler = new GetLicenseHandler(this.licenseFilePath, this.authSN);
        getLicenseHandler.setContext(this.mContext);
        httpClientUtil.post(string, this.getEntity(), getLicenseHandler);
        int n = getLicenseHandler.getStatusCode();
        return n;
    }

    private String getEntity() throws UnsupportedEncodingException {
        try {
            JSONObject jSONObject = new JSONObject();
            String string = Policy.uid(this.mContext);
            Context context = this.mContext;
            String string2 = Utility.stringToMd5(this.appCode + string);
            int n = SharedPreferencesUtils.getInt(context, "getLicense_err_no");
            jSONObject.put(KeyEnum.CUID.getShortName(), (Object)string);
            jSONObject.put(KeyEnum.SIGN.getShortName(), (Object)string2);
            jSONObject.put(KeyEnum.ID.getShortName(), (Object)this.appCode);
            jSONObject.put(KeyEnum.SERIAL_NUMBER.getShortName(), (Object)this.authSN);
            jSONObject.put(KeyEnum.APPNAME.getShortName(), (Object)Utility.getPackageName(context));
            jSONObject.put(KeyEnum.STA.getShortName(), (Object)Utility.getPlatform(context));
            jSONObject.put(KeyEnum.GETLICENSE_ERRNO.getShortName(), (Object)("" + n));
            jSONObject.put(KeyEnum.VERSION.getAlias(), (Object)"3.4.4.106");
            String string3 = jSONObject.toString();
            LogUtil.d(TAG, "getLicense params: " + string3);
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

