/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.analysis;

import android.content.Context;
import android.util.Log;
import com.baidu.speech.utils.Policy;
import com.baidu.speech.utils.analysis.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analysis {
    private static final String KEY_CUID = "wise_cuid";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_APP_NAME = "app_name";
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_OS = "os";
    private static final String KEY_NET_TYPE = "net_type";
    private static final String KEY_APP_ID = "appid";
    private static final String KEY_SCREEN = "screen";
    private static final String KEY_SDK_NAME = "sdk_name";
    private static final String KEY_APP_SIGNATURE = "app_signature";
    private static final String KEY_RECOGNITION_RESULT = "recog_results";
    private static final String KEY_RECOGNITION_RESULT_TIME = "time";
    private static final String KEY_RECOGNITION_RESULT_ERROR_CODE = "error_code";
    private static final String KEY_RECOGNITION_RESULT_CMD_TYPE = "cmd_type";
    private static final String KEY_RECOGNITION_RESULT_CMD_ID = "cmd_id";
    private static final String KEY_RECOGNITION_RESULT_VOICE_TO_TEXT = "voice_to_text_result";
    private static final String KEY_PID = "pid";
    private static final String KEY_TYPE = "type";
    private static final String KEY_PKG = "pkg";
    private static final String KEY_ERROR = "error";
    private static final String KEY_RESPONSE_ERROR_CODE = "errno";
    private static final String KEY_RESPONSE_UPLOAD_DATA = "data";
    private static final String KEY_RESPONSE_UPLOAD_PERIOD = "secs";
    private static final String TAG = "Analysis";
    private static final boolean DEBUG = false;

    public static void log(Context context, Item item) {
        try {
            File file = new File(context.getFilesDir(), "open-analysis");
            file.mkdirs();
            if (file.exists()) {
                if (item.appId == 0) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.i((String)TAG, (String)("appid is 0, ignore " + item));
                    }
                } else {
                    File file2 = new File(file, System.currentTimeMillis() + ".txt");
                    FileWriter fileWriter = new FileWriter(file2);
                    String string = item.toString();
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.i((String)TAG, (String)("write to " + file2 + ", \t content: " + string));
                    }
                    fileWriter.write(item.toString());
                    fileWriter.write("\r\n");
                    fileWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void asyncUploadAll(final Context context) {
        new Thread(new Runnable(){

            public void run() {
                Analysis.syncUploadAll(context);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void syncUploadAll(Context context) {
        try {
            File[] fileArray;
            File file = new File(context.getFilesDir(), "open-analysis");
            file.mkdirs();
            if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length && i <= 10; ++i) {
                    File file2 = fileArray[i];
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(new FileInputStream(file2)).useDelimiter("\\A");
                        String string = scanner.nextLine();
                        JSONObject jSONObject = new JSONObject(string);
                        String string2 = "" + jSONObject.getInt("app_id");
                        JSONObject jSONObject2 = new JSONObject().put(KEY_RECOGNITION_RESULT, (Object)new JSONArray().put((Object)jSONObject));
                        byte[] byArray = Utility.encryptGZIP(jSONObject2.toString());
                        if (byArray.length >= 2) {
                            byArray[0] = 117;
                            byArray[1] = 123;
                        }
                        String string3 = Utility.encryptBASE64(byArray);
                        String string4 = "records=" + URLEncoder.encode(string3, "utf-8");
                        byte[] byArray2 = string4.getBytes("utf-8");
                        String string5 = Analysis.buildStatUrl(context, string2);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("Content-Type", "application/x-www-form-urlencoded");
                        String string6 = Analysis.httpRequest(string5, hashMap, byArray2, true);
                        file2.delete();
                        if (!Log.isLoggable((String)TAG, (int)3)) {
                            continue;
                        }
                        Log.i((String)TAG, (String)("POST " + string5 + "\n\t\trequest data:" + string4 + "\n\t\tresponse data:\n" + string6));
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!Log.isLoggable((String)TAG, (int)3)) {
                            continue;
                        }
                        Log.i((String)TAG, (String)"", (Throwable)exception);
                        continue;
                    }
                    finally {
                        if (null != scanner) {
                            scanner.close();
                        }
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private static String buildStatUrl(Context context, String string) throws UnsupportedEncodingException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("wise_cuid=" + URLEncoder.encode(Policy.uid(context), "utf-8"));
        linkedList.add("sdk_version=" + URLEncoder.encode(Utility.getSdkVersion(), "utf-8"));
        linkedList.add("app_name=" + URLEncoder.encode(Utility.getAppName(context), "utf-8"));
        linkedList.add("platform=" + URLEncoder.encode(Utility.getPlatform(context), "utf-8"));
        linkedList.add("os=" + URLEncoder.encode(Utility.getOS(), "utf-8"));
        linkedList.add("net_type=" + URLEncoder.encode(Utility.getNetType(context) + "", "utf-8"));
        linkedList.add("appid=" + URLEncoder.encode(string, "utf-8"));
        linkedList.add("screen=" + URLEncoder.encode(Utility.getScreen(context), "utf-8"));
        linkedList.add("sdk_name=" + URLEncoder.encode(Utility.getSdkName(), "utf-8"));
        linkedList.add("app_signature=" + URLEncoder.encode(Utility.getSignatureMD5(context), "utf-8"));
        String string2 = Analysis.join(linkedList, "&");
        String string3 = "https://yuyin.baidu.com/voice?osname=voiceopen&action=usereventflow&";
        string3 = string3 + string2;
        return string3;
    }

    private static String join(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String httpRequest(String string, Map<String, String> map, byte[] byArray, boolean bl) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.i((String)TAG, (String)("cur time: " + System.currentTimeMillis() % 1000000L + ", http req: " + string));
            }
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setConnectTimeout(8000);
            httpURLConnection.setReadTimeout(8000);
            httpURLConnection.setInstanceFollowRedirects(false);
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
            }
            if (null != byArray || bl) {
                httpURLConnection.setRequestMethod("POST");
            }
            httpURLConnection.connect();
            if (null != byArray) {
                httpURLConnection.getOutputStream().write(byArray);
            }
            String string2 = new Scanner(httpURLConnection.getInputStream()).useDelimiter("\\A").next();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.i((String)TAG, (String)("http res: " + (String)string2));
            }
            Object object = string2;
            return object;
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.w((String)TAG, (String)"", (Throwable)exception);
            }
            throw exception;
        }
        finally {
            if (null != httpURLConnection) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static class Item {
        public int appId = 0;
        public long time;
        public int error_code;
        public int pid;
        public int decoder;
        public String type;
        public String pkg;
        public static final String TYPE_WAKEUP = "wakeup";
        public static final String TYPE_TTS = "tts";
        public static final String TYPE_ASR_LONGSPEECH = "asr_longspeech";
        public static final String TYPE_NORMAL = "asr_normal";

        public String toString() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(Analysis.KEY_RECOGNITION_RESULT_TIME, this.time);
            hashMap.put(Analysis.KEY_RECOGNITION_RESULT_ERROR_CODE, this.error_code);
            hashMap.put(Analysis.KEY_RECOGNITION_RESULT_CMD_TYPE, 0);
            hashMap.put(Analysis.KEY_RECOGNITION_RESULT_CMD_ID, 0);
            hashMap.put(Analysis.KEY_RECOGNITION_RESULT_VOICE_TO_TEXT, "");
            hashMap.put(Analysis.KEY_PID, this.pid);
            hashMap.put("decoder", this.decoder);
            hashMap.put(Analysis.KEY_TYPE, this.type);
            hashMap.put(Analysis.KEY_PKG, this.pkg);
            hashMap.put("app_id", this.appId);
            return new JSONObject(hashMap).toString();
        }
    }
}

