/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.audio;

import android.media.AudioRecord;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.speech.utils.LogUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MicrophoneServer
implements Runnable {
    public static final String TAG = MicrophoneServer.class.getSimpleName();
    public static final int S_DATA_LENGTH = 1920000;
    public static final int S_LENGTH = 640;
    private static final int PORT = 3277;
    private final byte[] sData = new byte[1920000];
    private final int sLen = 640;
    private long sLimit = 0L;
    private ArrayList<SocketWrap> mRemoteOutputStreams = new ArrayList();
    private String mInfile;
    private int mAudioSource;
    private LocalServerSocket mServerSocket;
    private String SOCKET_ADDRESS = "com.baidu.speech";
    private DataInputStream mIn = null;
    private final int mServerPort;
    private static HashMap<String, MicrophoneServer> sPorts = new HashMap();
    private boolean firstStart = true;
    ExecutorService newSingleThreadExecutor = Executors.newSingleThreadExecutor();
    Future<Integer> future;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int create(String string, int n) throws IOException {
        HashMap<String, MicrophoneServer> hashMap = sPorts;
        synchronized (hashMap) {
            MicrophoneServer microphoneServer = sPorts.get(string);
            if (microphoneServer == null) {
                try {
                    MicrophoneServer microphoneServer2 = new MicrophoneServer(string, n);
                    sPorts.put(string, microphoneServer2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 3277;
                }
            }
            return MicrophoneServer.sPorts.get((Object)string).mServerPort;
        }
    }

    private MicrophoneServer(String string, int n) throws IOException {
        int n2;
        this.mInfile = string;
        this.mAudioSource = n;
        Log.i((String)TAG, (String)("infile:" + string + "  audioSource:" + n));
        if (TextUtils.isEmpty((CharSequence)string)) {
            n2 = new Random().nextInt(1000);
            this.mServerSocket = new LocalServerSocket(this.SOCKET_ADDRESS + "_" + n2);
            this.mServerPort = n2;
        } else {
            n2 = new Random().nextInt(1000);
            this.mServerSocket = new LocalServerSocket(this.SOCKET_ADDRESS + "_" + n2);
            this.mServerPort = n2;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    while (true) {
                        LocalSocket localSocket = MicrophoneServer.this.mServerSocket.accept();
                        ArrayList arrayList = MicrophoneServer.this.mRemoteOutputStreams;
                        // MONITORENTER : arrayList
                        SocketWrap socketWrap = new SocketWrap(localSocket);
                        MicrophoneServer.this.mRemoteOutputStreams.add(socketWrap);
                        LogUtil.i(TAG, "add wrap socket, mRemoteOutputStreams size = " + MicrophoneServer.this.mRemoteOutputStreams.size() + " firstStart = " + MicrophoneServer.this.firstStart);
                        if (MicrophoneServer.this.mRemoteOutputStreams.size() == 1 && MicrophoneServer.this.firstStart) {
                            MicrophoneServer.this.firstStart = false;
                            if (MicrophoneServer.this.mIn != null) {
                                try {
                                    MicrophoneServer.this.mIn.close();
                                    MicrophoneServer.this.mIn = null;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            InputStream inputStream = MicrophoneServer.this.createInputStream(MicrophoneServer.this.mInfile, MicrophoneServer.this.mAudioSource);
                            MicrophoneServer.this.mIn = new DataInputStream(inputStream);
                            new Thread(MicrophoneServer.this).start();
                        }
                        // MONITOREXIT : arrayList
                    }
                }
                catch (Exception exception) {
                    LogUtil.d(TAG, " mRemoteOutputStreams.size\uff1a" + MicrophoneServer.this.mRemoteOutputStreams.size());
                    MicrophoneServer.this.firstStart = true;
                    ArrayList arrayList = MicrophoneServer.this.mRemoteOutputStreams;
                    // MONITORENTER : arrayList
                    for (LocalSocket localSocket : MicrophoneServer.this.mRemoteOutputStreams) {
                        try {
                            localSocket.getOutputStream().close();
                            localSocket.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    MicrophoneServer.this.mRemoteOutputStreams.clear();
                    // MONITOREXIT : arrayList
                    if (MicrophoneServer.this.mIn != null) {
                        try {
                            MicrophoneServer.this.mIn.close();
                            MicrophoneServer.this.mIn = null;
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                    try {
                        MicrophoneServer.this.mServerSocket.close();
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    HashMap hashMap = sPorts;
                    // MONITORENTER : hashMap
                    sPorts.remove(MicrophoneServer.this.mInfile);
                    // MONITOREXIT : hashMap
                    exception.printStackTrace();
                    return;
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        ArrayList<SocketWrap> arrayList;
        try {
            int n = 0;
            while (true) {
                n = (int)(this.sLimit % (long)this.sData.length);
                try {
                    this.mIn.readFully(this.sData, n, 640);
                }
                catch (EOFException eOFException) {
                    eOFException.printStackTrace();
                    this.firstStart = true;
                    break;
                }
                this.sLimit += 640L;
                n += 640;
                ArrayList<SocketWrap> arrayList2 = this.mRemoteOutputStreams;
                synchronized (arrayList2) {
                    for (int i = 0; i < this.mRemoteOutputStreams.size(); ++i) {
                        final SocketWrap socketWrap = this.mRemoteOutputStreams.get(i);
                        try {
                            long l = socketWrap.getPosition(this.sLimit);
                            final int n2 = (int)(l % (long)this.sData.length);
                            final OutputStream outputStream = socketWrap.getOutputStream();
                            final int n3 = n - n2;
                            final int n4 = n;
                            this.future = this.newSingleThreadExecutor.submit(new Callable<Integer>(){

                                @Override
                                public Integer call() throws Exception {
                                    if (n3 >= 0) {
                                        outputStream.write(MicrophoneServer.this.sData, n2, n3);
                                    } else {
                                        outputStream.write(MicrophoneServer.this.sData, n2, MicrophoneServer.this.sData.length - n2);
                                        outputStream.write(MicrophoneServer.this.sData, 0, n4);
                                    }
                                    socketWrap.setPosition(MicrophoneServer.this.sLimit);
                                    return 0;
                                }
                            });
                            this.future.get(1000L, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        catch (TimeoutException timeoutException) {
                            throw timeoutException;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.mRemoteOutputStreams.remove((Object)socketWrap);
                            socketWrap.getOutputStream().close();
                            socketWrap.close();
                        }
                    }
                    if (this.mRemoteOutputStreams.size() <= 0) {
                        this.firstStart = true;
                        break;
                    }
                }
            }
            Object var15_23 = null;
            arrayList = this.mRemoteOutputStreams;
        }
        catch (Throwable throwable) {
            Object var15_26 = null;
            ArrayList<SocketWrap> arrayList3 = this.mRemoteOutputStreams;
            synchronized (arrayList3) {
                LogUtil.i(TAG, "finally, mRemoteOutputStreams size = " + this.mRemoteOutputStreams.size() + " firstStart = " + this.firstStart);
                if (this.firstStart) {
                    Object object2222 = this.mRemoteOutputStreams.iterator();
                    while (object2222.hasNext()) {
                        LocalSocket localSocket = object2222.next();
                        try {
                            localSocket.getOutputStream().close();
                            localSocket.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    this.mRemoteOutputStreams.clear();
                    try {
                        if (this.mIn != null) {
                            this.mIn.close();
                            this.mIn = null;
                        }
                    }
                    catch (Exception object2222) {
                        ((Throwable)object2222).printStackTrace();
                    }
                }
            }
            throw throwable;
        }
        synchronized (arrayList) {
            LogUtil.i(TAG, "finally, mRemoteOutputStreams size = " + this.mRemoteOutputStreams.size() + " firstStart = " + this.firstStart);
            if (this.firstStart) {
                Object object3222 = this.mRemoteOutputStreams.iterator();
                while (object3222.hasNext()) {
                    LocalSocket localSocket = object3222.next();
                    try {
                        localSocket.getOutputStream().close();
                        localSocket.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.mRemoteOutputStreams.clear();
                try {
                    if (this.mIn != null) {
                        this.mIn.close();
                        this.mIn = null;
                    }
                }
                catch (Exception object3222) {
                    ((Throwable)object3222).printStackTrace();
                }
            }
        }
        {
            catch (TimeoutException timeoutException) {
                timeoutException.printStackTrace();
                HashMap<String, MicrophoneServer> hashMap = sPorts;
                synchronized (hashMap) {
                    try {
                        this.mServerSocket.close();
                    }
                    catch (Exception exception) {
                        timeoutException.printStackTrace();
                    }
                    sPorts.remove(this.mInfile);
                }
                Object var15_24 = null;
                ArrayList<SocketWrap> arrayList4 = this.mRemoteOutputStreams;
                synchronized (arrayList4) {
                    LogUtil.i(TAG, "finally, mRemoteOutputStreams size = " + this.mRemoteOutputStreams.size() + " firstStart = " + this.firstStart);
                    if (this.firstStart) {
                        Object object4222 = this.mRemoteOutputStreams.iterator();
                        while (object4222.hasNext()) {
                            LocalSocket localSocket = object4222.next();
                            try {
                                localSocket.getOutputStream().close();
                                localSocket.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        this.mRemoteOutputStreams.clear();
                        try {
                            if (this.mIn != null) {
                                this.mIn.close();
                                this.mIn = null;
                            }
                        }
                        catch (Exception object4222) {
                            ((Throwable)object4222).printStackTrace();
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.firstStart = true;
                ArrayList<SocketWrap> arrayList5 = this.mRemoteOutputStreams;
                synchronized (arrayList5) {
                    for (int i = 0; i < this.mRemoteOutputStreams.size(); ++i) {
                        LocalSocket localSocket = this.mRemoteOutputStreams.get(i);
                        try {
                            OutputStream outputStream = localSocket.getOutputStream();
                            byte[] byArray = TextUtils.isEmpty((CharSequence)this.mInfile) ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{1, 0, 0, 0, 0, 0};
                            outputStream.write(byArray, 0, byArray.length);
                            continue;
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                }
                Object var15_25 = null;
                ArrayList<SocketWrap> arrayList6 = this.mRemoteOutputStreams;
                synchronized (arrayList6) {
                    LogUtil.i(TAG, "finally, mRemoteOutputStreams size = " + this.mRemoteOutputStreams.size() + " firstStart = " + this.firstStart);
                    if (this.firstStart) {
                        Object object5222 = this.mRemoteOutputStreams.iterator();
                        while (object5222.hasNext()) {
                            LocalSocket localSocket = object5222.next();
                            try {
                                localSocket.getOutputStream().close();
                                localSocket.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        this.mRemoteOutputStreams.clear();
                        try {
                            if (this.mIn != null) {
                                this.mIn.close();
                                this.mIn = null;
                            }
                        }
                        catch (Exception object5222) {
                            ((Throwable)object5222).printStackTrace();
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream createInputStream(String string, int n) throws Exception {
        if (string == null) return new MicInputStream(n, 16000);
        if (string.equals("")) return new MicInputStream(n, 16000);
        if (string.startsWith("#")) {
            Matcher matcher = Pattern.compile("^#(.*)[#.](.*?)\\(").matcher(string);
            if (!matcher.find()) throw new IOException("can not create inputStream");
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return (InputStream)Class.forName(string2).getMethod(string3, new Class[0]).invoke(null, new Object[0]);
        }
        if (string.startsWith("res://")) {
            String string4 = string.replaceFirst("res://", "").replaceFirst("/", "");
            return this.getClass().getResourceAsStream("/" + string4);
        }
        if (string.startsWith("asset://") || string.startsWith("assets://")) {
            String string5 = string.replaceFirst("assets://", "").replaceFirst("/", "");
            if (!string.startsWith("asset://")) return this.getClass().getResourceAsStream("/assets/" + string5);
            string5 = string.replaceFirst("asset://", "").replaceFirst("/", "");
            return this.getClass().getResourceAsStream("/assets/" + string5);
        }
        if (!string.startsWith("tcp://")) return new FileInputStream(string);
        String string6 = string.replaceFirst("tcp://", "").replaceFirst("/", "");
        int n2 = Integer.parseInt(string6);
        Socket socket = new Socket("localhost", n2);
        return socket.getInputStream();
    }

    private static class SocketWrap
    extends LocalSocket {
        private long mPosition = -1L;
        private final LocalSocket mSocket;
        byte[] data = new byte[8];

        public SocketWrap(LocalSocket localSocket) {
            this.mSocket = localSocket;
            try {
                this.mSocket.setSoTimeout(2000);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public long getPosition(long l) {
            if (this.mPosition >= 0L) {
                return this.mPosition;
            }
            InputStream inputStream = null;
            try {
                inputStream = this.mSocket.getInputStream();
                int n = inputStream.read(this.data, 0, this.data.length);
                long l2 = this.byteArrayToInt(this.data);
                Log.i((String)TAG, (String)("audio mills is " + l2));
                if (l2 > 0L) {
                    long l3 = System.currentTimeMillis() - l2;
                    long l4 = Math.min(Math.max(0L, l3), l / 32L);
                    this.mPosition = l4 / 20L * 20L * 32L;
                } else {
                    this.mPosition = 640L;
                }
                this.mPosition = (l - this.mPosition + 1920000L) % 1920000L;
            }
            catch (Exception exception) {
                this.mPosition = (l - 640L + 1920000L) % 1920000L;
                exception.printStackTrace();
            }
            return this.mPosition;
        }

        public void setPosition(long l) {
            this.mPosition = l;
        }

        public synchronized void close() throws IOException {
            this.mSocket.close();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.mSocket.getOutputStream();
        }

        public void shutdownOutput() throws IOException {
            this.mSocket.shutdownOutput();
        }

        private long byteArrayToInt(byte[] byArray) {
            byte[] byArray2 = new byte[8];
            int n = byArray2.length - 1;
            int n2 = 0;
            while (n >= 0) {
                byArray2[n] = n2 < byArray.length ? byArray[n2] : (byte)0;
                --n;
                ++n2;
            }
            long l = (long)(byArray2[0] & 0xFF) << 56;
            long l2 = (long)(byArray2[1] & 0xFF) << 48;
            long l3 = (long)(byArray2[2] & 0xFF) << 40;
            long l4 = (long)(byArray2[3] & 0xFF) << 32;
            long l5 = (long)(byArray2[4] & 0xFF) << 24;
            long l6 = (long)(byArray2[5] & 0xFF) << 16;
            long l7 = (long)(byArray2[6] & 0xFF) << 8;
            long l8 = byArray2[7] & 0xFF;
            return l + l2 + l3 + l4 + l5 + l6 + l7 + l8;
        }
    }

    public static class MicInputStream
    extends InputStream {
        private String TAG;
        private static final int DEFAULT_BUFFER_SIZE = 160000;
        private AudioRecord mAudioRecord;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public MicInputStream(int n, int n2) {
            block16: {
                block17: {
                    block15: {
                        this.TAG = MicInputStream.class.getSimpleName();
                        this.mAudioRecord = new AudioRecord(n, n2, 16, 2, 160000);
                        LogUtil.i("audioSource : ", n + "");
                        LogUtil.i(this.TAG, "startRecordingAndCheckStatus recorder status is " + this.mAudioRecord.getState());
                        this.mAudioRecord.startRecording();
                        int n3 = 0;
                        byte[] byArray = new byte[32];
                        for (int i = 0; i < 10; ++i) {
                            int n4 = this.mAudioRecord.read(byArray, 0, byArray.length);
                            if (n4 <= 0) continue;
                            n3 += n4;
                            break;
                        }
                        if (n3 > 0) break block15;
                        this.mAudioRecord.release();
                        new Exception("bad recorder, read(byte[])");
                    }
                    if (this.mAudioRecord != null && this.mAudioRecord.getRecordingState() != 3) break block17;
                    if (this.mAudioRecord.getState() != 0) break block16;
                }
                try {
                    this.mAudioRecord.release();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                LogUtil.d(this.TAG, "recorder start failed, RecordingState=" + this.mAudioRecord.getRecordingState());
                break block16;
                catch (Exception exception) {
                    try {
                        exception.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        block19: {
                            block18: {
                                if (this.mAudioRecord != null && this.mAudioRecord.getRecordingState() != 3) break block18;
                                if (this.mAudioRecord.getState() != 0) break block19;
                            }
                            try {
                                this.mAudioRecord.release();
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                            LogUtil.d(this.TAG, "recorder start failed, RecordingState=" + this.mAudioRecord.getRecordingState());
                        }
                        throw throwable;
                    }
                    if (this.mAudioRecord == null || this.mAudioRecord.getRecordingState() == 3) {
                        if (this.mAudioRecord.getState() != 0) break block16;
                    }
                    try {
                        this.mAudioRecord.release();
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    LogUtil.d(this.TAG, "recorder start failed, RecordingState=" + this.mAudioRecord.getRecordingState());
                }
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.mAudioRecord == null) {
                throw new IOException("audio recorder is null");
            }
            int n3 = this.mAudioRecord.read(byArray, n, n2);
            LogUtil.v(this.TAG, " AudioRecord read: len:" + n3 + " byteOffset:" + n + " byteCount:" + n2);
            if (n3 < 0 || n3 > n2) {
                throw new IOException("audio recdoder read error, len = " + n3);
            }
            return n3;
        }

        public void close() throws IOException {
            if (this.mAudioRecord != null) {
                this.mAudioRecord.release();
            }
        }

        public int read() throws IOException {
            throw new IOException("read not support");
        }
    }
}

