/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventContext
extends ContextWrapper {
    private static final String TAG = "EventContext";
    private static final Logger logger = Logger.getLogger("EventContext");

    public EventContext(Context context) {
        super(context);
    }

    public SharedPreferences getSdkSharedPreferences() {
        return super.getSharedPreferences("bds", 0);
    }

    public JSONObject loadJsonFromUri(String string) {
        return this.loadJsonFromUri(string, false, false);
    }

    public JSONObject loadJsonFromUri(String string, boolean bl, boolean bl2) {
        try {
            JSONObject jSONObject = this.loadJsonFromUriOrThrow(string, bl, bl2);
            return jSONObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JSONObject loadJsonFromUriOrThrow(String string) throws IOException, JSONException {
        return this.loadJsonFromUriOrThrow(string, false, false);
    }

    public JSONObject loadJsonFromUriOrThrow(String string, boolean bl, boolean bl2) throws IOException, JSONException {
        String string2 = this.loadStringFromUri(string, bl);
        if (bl2) {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        return new JSONObject(string2);
    }

    public String loadStringFromUri(String string) throws IOException {
        return this.loadStringFromUri(string, false);
    }

    public String loadStringFromUri(String string, boolean bl) throws IOException {
        byte[] byArray = this.loadBytesFromUri(string);
        if (bl) {
            byte[] byArray2 = Base64.decode((byte[])byArray, (int)0);
            return new String(byArray2, "UTF-8");
        }
        return new String(byArray, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBytesFromUri(String string) throws IOException {
        InputStream inputStream = null;
        try {
            byte[] byArray;
            int n;
            Object object;
            Object object2;
            String string2 = string.contains("://") ? string : "file://" + string;
            Pattern pattern = Pattern.compile("(.*?)://(.*)");
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                object2 = matcher.group(1);
                object = matcher.group(2);
                if (((String)object2).equalsIgnoreCase("file")) {
                    inputStream = new FileInputStream((String)object);
                } else if (((String)object2).equalsIgnoreCase("asset") || ((String)object2).equalsIgnoreCase("assets")) {
                    String string3 = ((String)object).startsWith("/") ? "" : "/";
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/assets" + string3 + (String)object);
                } else if (((String)object2).equalsIgnoreCase("res")) {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream((String)object);
                }
            }
            if (null == inputStream) {
                throw new IOException("bad data source");
            }
            object2 = new byte[1024];
            object = new ByteArrayOutputStream();
            while (-1 != (n = inputStream.read((byte[])object2, 0, ((Object)object2).length))) {
                ((ByteArrayOutputStream)object).write((byte[])object2, 0, n);
            }
            byte[] byArray2 = byArray = ((ByteArrayOutputStream)object).toByteArray();
            return byArray2;
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    public static short[] byteToShortArray(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return new short[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray, n, n2);
        byteBuffer.clear();
        short[] sArray = new short[n2 / 2];
        byteBuffer.asShortBuffer().get(sArray);
        return sArray;
    }

    public Object searchItemFromJson(JSONObject jSONObject, String string) throws JSONException {
        if (null == jSONObject) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            JSONObject jSONObject2;
            Object object;
            String string2 = (String)iterator.next();
            if (string2.equals(string)) {
                return jSONObject.get(string);
            }
            Object object2 = jSONObject.get(string2);
            if (!(object2 instanceof JSONObject) || null == (object = this.searchItemFromJson(jSONObject2 = (JSONObject)object2, string))) continue;
            return object;
        }
        return null;
    }

    public long computePower(byte[] byArray, int n) {
        short[] sArray = new short[n / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(byArray[2 * i + 1] << 8 | byArray[2 * i + 0] & 0xFF);
        }
        return EventContext.computePower(sArray, sArray.length);
    }

    public static long computePower(short[] sArray, int n) {
        if (sArray == null) {
            return 0L;
        }
        long l = System.currentTimeMillis();
        int n2 = 2;
        int n3 = Math.min(n / n2, 512);
        if (n3 <= 0) {
            return 0L;
        }
        long l2 = 0L;
        for (int i = 0; i < n3; ++i) {
            l2 += (long)(sArray[i * n2] * sArray[i * n2]);
        }
        long l3 = (long)Math.sqrt(l2 / (long)n3);
        return l3;
    }

    public String httpRequest(String string, Map<String, String> map, byte[] byArray, boolean bl) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            if (Log.isLoggable((String)TAG, (int)3) || logger.isLoggable(Level.ALL)) {
                logger.info("cur time: " + System.currentTimeMillis() % 1000000L + ", http req: " + string);
            }
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setConnectTimeout(8000);
            httpURLConnection.setReadTimeout(8000);
            httpURLConnection.setInstanceFollowRedirects(false);
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
            }
            if (null != byArray || bl) {
                httpURLConnection.setRequestMethod("POST");
            }
            httpURLConnection.connect();
            if (null != byArray) {
                httpURLConnection.getOutputStream().write(byArray);
            }
            String string2 = new Scanner(httpURLConnection.getInputStream()).useDelimiter("\\A").next();
            if (Log.isLoggable((String)TAG, (int)3) || logger.isLoggable(Level.ALL)) {
                logger.info("http res: " + (String)string2);
            }
            Object object = string2;
            return object;
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)3) || logger.isLoggable(Level.ALL)) {
                logger.log(Level.WARNING, "", exception);
            }
            throw exception;
        }
        finally {
            if (null != httpURLConnection) {
                httpURLConnection.disconnect();
            }
        }
    }

    public String join(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public <T> T loggerIt(Object object, String ... stringArray) {
        return SmartLogger.wrap(object, stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SmartLogger {
        private static final String TAG = "baidu_speech";
        private static final Logger logger = Logger.getLogger("baidu_speech");

        private SmartLogger() {
        }

        public static <T> T wrap(String string, final Object object, final String ... stringArray) {
            final boolean bl = Log.isLoggable((String)TAG, (int)3);
            if (Log.isLoggable((String)TAG, (int)3)) {
                logger.setLevel(Level.ALL);
            }
            ArrayList arrayList = new ArrayList();
            Class<?> clazz = object.getClass();
            do {
                arrayList.addAll(Arrays.asList(clazz.getInterfaces()));
            } while ((clazz = clazz.getSuperclass()) != Object.class);
            Object object2 = Proxy.newProxyInstance(object.getClass().getClassLoader(), arrayList.toArray(new Class[0]), new InvocationHandler(){

                public Object invoke(Object object4, Method method, Object[] objectArray) throws Throwable {
                    Object object2 = method.invoke(object, objectArray);
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = null != stringArray && stringArray.length > 0 ? stringArray[0] : object.getClass().getName();
                    stringBuffer.append(string + "@" + Integer.toHexString(object.hashCode()));
                    stringBuffer.append("." + method.getName() + "(");
                    if (null != objectArray) {
                        for (Object object3 : objectArray) {
                            String string2 = object3 + "";
                            if (!bl) {
                                string2 = string2.replaceAll("[\r\n]]", "");
                                string2 = string2.substring(0, Math.min(50, string2.length()));
                            }
                            stringBuffer.append(string2 + ", ");
                        }
                    }
                    stringBuffer.append(") : " + object2);
                    logger.info(stringBuffer.toString());
                    return object2;
                }
            });
            return (T)object2;
        }

        public static <T> T wrap(Object object, String[] stringArray) {
            return SmartLogger.wrap(TAG, object, stringArray);
        }

        static {
            logger.setLevel(Level.OFF);
        }
    }
}

