/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

public class ColorPanelView
extends View {
    private static final int[] GRAD_COLORS = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    private static final int[] GRAD_ALPHA = new int[]{-1, 0};
    private ColorPanelView mBrightnessGradientView;
    private Shader mShader;
    private Drawable mPointerDrawable;
    private Paint mPaint;
    private Paint mPaintBackground;
    private RectF mGradientRect = new RectF();
    private float[] mHSV = new float[]{1.0f, 1.0f, 1.0f};
    private int[] mSelectedColorGradient = new int[]{0, -16777216};
    private float mRadius = 0.0f;
    private int mSelectedColor = 0;
    private boolean mIsBrightnessGradient = false;
    private int mLastX = Integer.MIN_VALUE;
    private int mLastY;
    private int mPointerHeight;
    private int mPointerWidth;
    private boolean mLockPointerInBounds = false;
    private OnColorChangedListener mOnColorChangedListener;

    public ColorPanelView(Context context) {
        super(context);
        this.init();
    }

    public ColorPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ColorPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClickable(true);
        this.mPaint = new Paint(1);
        this.mPaintBackground = new Paint(1);
        this.mPaintBackground.setColor(-1);
        this.setLayerType(1, this.isInEditMode() ? null : this.mPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = 0;
        int desiredHeight = 0;
        if (this.mPointerDrawable != null) {
            desiredHeight = this.mPointerDrawable.getIntrinsicHeight();
            desiredWidth = this.mPointerDrawable.getIntrinsicWidth();
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mShader != null) {
            canvas.drawRoundRect(this.mGradientRect, this.mRadius, this.mRadius, this.mPaintBackground);
            canvas.drawRoundRect(this.mGradientRect, this.mRadius, this.mRadius, this.mPaint);
        }
        this.onDrawPointer(canvas);
    }

    private void onDrawPointer(Canvas canvas) {
        if (this.mPointerDrawable != null) {
            float ty;
            float tx;
            int vh = this.getHeight();
            int pwh = this.mPointerWidth >> 1;
            int phh = this.mPointerHeight >> 1;
            if (!this.mIsBrightnessGradient) {
                tx = this.mLastX - pwh;
                ty = this.mLastY - phh;
                if (this.mLockPointerInBounds) {
                    tx = Math.max(this.mGradientRect.left, Math.min(tx, this.mGradientRect.right - (float)this.mPointerWidth));
                    ty = Math.max(this.mGradientRect.top, Math.min(ty, this.mGradientRect.bottom - (float)this.mPointerHeight));
                } else {
                    tx = Math.max(this.mGradientRect.left - (float)pwh, Math.min(tx, this.mGradientRect.right - (float)pwh));
                    ty = Math.max(this.mGradientRect.top - (float)pwh, Math.min(ty, this.mGradientRect.bottom - (float)phh));
                }
            } else {
                tx = this.mLastX - pwh;
                float f = ty = this.mPointerHeight != this.mPointerDrawable.getIntrinsicHeight() ? (float)((vh >> 1) - phh) : 0.0f;
                if (this.mLockPointerInBounds) {
                    tx = Math.max(this.mGradientRect.left, Math.min(tx, this.mGradientRect.right - (float)this.mPointerWidth));
                    ty = Math.max(this.mGradientRect.top, Math.min(ty, this.mGradientRect.bottom - (float)this.mPointerHeight));
                } else {
                    tx = Math.max(this.mGradientRect.left - (float)pwh, Math.min(tx, this.mGradientRect.right - (float)pwh));
                    ty = Math.max(this.mGradientRect.top - (float)pwh, Math.min(ty, this.mGradientRect.bottom - (float)phh));
                }
            }
            canvas.translate(tx, ty);
            this.mPointerDrawable.draw(canvas);
            canvas.translate(-tx, -ty);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mGradientRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(right - left - this.getPaddingRight()), (float)(bottom - top - this.getPaddingBottom()));
        if (changed) {
            this.buildShader();
        }
        if (this.mPointerDrawable != null) {
            int h = (int)this.mGradientRect.height();
            int ph = this.mPointerDrawable.getIntrinsicHeight();
            int pw = this.mPointerDrawable.getIntrinsicWidth();
            this.mPointerHeight = ph;
            this.mPointerWidth = pw;
            if (h < ph) {
                this.mPointerHeight = h;
                this.mPointerWidth = (int)((float)pw * ((float)h / (float)ph));
            }
            this.mPointerDrawable.setBounds(0, 0, this.mPointerWidth, this.mPointerHeight);
            this.updatePointerPosition();
        }
    }

    private void buildShader() {
        if (this.mIsBrightnessGradient) {
            this.mShader = new LinearGradient(this.mGradientRect.left, this.mGradientRect.top, this.mGradientRect.right, this.mGradientRect.top, this.mSelectedColorGradient, null, Shader.TileMode.CLAMP);
        } else {
            LinearGradient gradientShader = new LinearGradient(this.mGradientRect.left, this.mGradientRect.top, this.mGradientRect.right, this.mGradientRect.top, GRAD_COLORS, null, Shader.TileMode.CLAMP);
            LinearGradient alphaShader = new LinearGradient(0.0f, this.mGradientRect.top + this.mGradientRect.height() / 3.0f, 0.0f, this.mGradientRect.bottom, GRAD_ALPHA, null, Shader.TileMode.CLAMP);
            this.mShader = new ComposeShader((Shader)alphaShader, (Shader)gradientShader, PorterDuff.Mode.MULTIPLY);
        }
        this.mPaint.setShader(this.mShader);
    }

    public void setRadius(float radius) {
        if ((int)radius != (int)this.mRadius) {
            this.mRadius = radius;
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mLastX = (int)event.getX();
        this.mLastY = (int)event.getY();
        this.onUpdateColorSelection(this.mLastX, this.mLastY);
        this.invalidate();
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onUpdateColorSelection(int x, int y) {
        x = (int)Math.max(this.mGradientRect.left, Math.min((float)x, this.mGradientRect.right));
        y = (int)Math.max(this.mGradientRect.top, Math.min((float)y, this.mGradientRect.bottom));
        if (this.mIsBrightnessGradient) {
            float b;
            this.mHSV[2] = b = this.pointToValueBrightness(x);
            this.mSelectedColor = Color.HSVToColor((float[])this.mHSV);
        } else {
            float hue = this.pointToHue(x);
            float sat = this.pointToSaturation(y);
            this.mHSV[0] = hue;
            this.mHSV[1] = sat;
            this.mHSV[2] = 1.0f;
            this.mSelectedColor = Color.HSVToColor((float[])this.mHSV);
        }
        this.dispatchColorChanged(this.mSelectedColor);
    }

    protected void dispatchColorChanged(int color) {
        if (this.mBrightnessGradientView != null) {
            this.mBrightnessGradientView.setColor(color, false);
        }
        if (this.mOnColorChangedListener != null) {
            this.mOnColorChangedListener.onColorChanged(this, color);
        }
    }

    public void setIsBrightnessGradient(boolean isBrightnessGradient) {
        this.mIsBrightnessGradient = isBrightnessGradient;
    }

    public void setBrightnessGradientView(ColorPanelView brightnessGradient) {
        if (this.mBrightnessGradientView != brightnessGradient) {
            this.mBrightnessGradientView = brightnessGradient;
            if (this.mBrightnessGradientView != null) {
                this.mBrightnessGradientView.setIsBrightnessGradient(true);
                this.mBrightnessGradientView.setColor(this.mSelectedColor);
            }
        }
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setColor(int selectedColor) {
        this.setColor(selectedColor, true);
    }

    protected void setColor(int selectedColor, boolean updatePointers) {
        Color.colorToHSV((int)selectedColor, (float[])this.mHSV);
        if (this.mIsBrightnessGradient) {
            this.mSelectedColorGradient[0] = this.getColorForGradient(this.mHSV);
            this.mSelectedColor = Color.HSVToColor((float[])this.mHSV);
            this.buildShader();
            if (this.mLastX != Integer.MIN_VALUE) {
                this.mHSV[2] = this.pointToValueBrightness(this.mLastX);
            }
            selectedColor = Color.HSVToColor((float[])this.mHSV);
        }
        if (updatePointers) {
            this.updatePointerPosition();
        }
        this.mSelectedColor = selectedColor;
        this.invalidate();
        this.dispatchColorChanged(this.mSelectedColor);
    }

    private int getColorForGradient(float[] hsv) {
        if ((int)hsv[2] != 1) {
            float oldV = hsv[2];
            hsv[2] = 1.0f;
            int color = Color.HSVToColor((float[])hsv);
            hsv[2] = oldV;
            return color;
        }
        return Color.HSVToColor((float[])hsv);
    }

    private void updatePointerPosition() {
        if (this.mGradientRect.width() != 0.0f && this.mGradientRect.height() != 0.0f) {
            if (!this.mIsBrightnessGradient) {
                this.mLastX = this.hueToPoint(this.mHSV[0]);
                this.mLastY = this.saturationToPoint(this.mHSV[1]);
            } else {
                this.mLastX = this.brightnessToPoint(this.mHSV[2]);
            }
        }
    }

    public void setOnColorChangedListener(OnColorChangedListener onColorChangedListener) {
        this.mOnColorChangedListener = onColorChangedListener;
    }

    private float pointToHue(float x) {
        return (x -= this.mGradientRect.left) * 360.0f / this.mGradientRect.width();
    }

    private int hueToPoint(float hue) {
        return (int)(this.mGradientRect.left + hue * this.mGradientRect.width() / 360.0f);
    }

    private float pointToSaturation(float y) {
        return 1.0f - 1.0f / this.mGradientRect.height() * (y -= this.mGradientRect.top);
    }

    private int saturationToPoint(float sat) {
        sat = 1.0f - sat;
        return (int)(this.mGradientRect.top + this.mGradientRect.height() * sat);
    }

    private float pointToValueBrightness(float x) {
        return 1.0f - 1.0f / this.mGradientRect.width() * (x -= this.mGradientRect.left);
    }

    private int brightnessToPoint(float val) {
        val = 1.0f - val;
        return (int)(this.mGradientRect.left + this.mGradientRect.width() * val);
    }

    public void setPointerDrawable(Drawable pointerDrawable) {
        if (this.mPointerDrawable != pointerDrawable) {
            this.mPointerDrawable = pointerDrawable;
            this.requestLayout();
        }
    }

    public void recycle() {
        Bitmap bitmap;
        this.mPaint = null;
        this.mPaintBackground = null;
        if (this.mPointerDrawable instanceof BitmapDrawable && null != (bitmap = ((BitmapDrawable)this.mPointerDrawable).getBitmap()) && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
    }

    public void setLockPointerInBounds(boolean lockPointerInBounds) {
        if (lockPointerInBounds != this.mLockPointerInBounds) {
            this.mLockPointerInBounds = lockPointerInBounds;
            this.invalidate();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isBrightnessGradient = this.mIsBrightnessGradient;
        ss.color = this.mSelectedColor;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mIsBrightnessGradient = ss.isBrightnessGradient;
        this.setColor(ss.color, true);
    }

    private static class SavedState
    extends View.BaseSavedState {
        int color;
        boolean isBrightnessGradient;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.color = in.readInt();
            this.isBrightnessGradient = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.color);
            out.writeInt(this.isBrightnessGradient ? 1 : 0);
        }
    }

    public static interface OnColorChangedListener {
        public void onColorChanged(ColorPanelView var1, int var2);
    }
}

