/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.util;

import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void flushQuietly(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {}
        }
    }

    public static BufferedInputStream toBufferedInputStream(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            inputStream = (BufferedInputStream)inputStream;
        } else {
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(inputStream);
            inputStream = bufferedInputStream2;
        }
        return inputStream;
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream outputStream) {
        if (outputStream instanceof BufferedOutputStream) {
            outputStream = (BufferedOutputStream)outputStream;
        } else {
            BufferedOutputStream bufferedOutputStream;
            BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            outputStream = bufferedOutputStream2;
        }
        return outputStream;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            reader = (BufferedReader)reader;
        } else {
            BufferedReader bufferedReader;
            BufferedReader bufferedReader2 = bufferedReader;
            bufferedReader = new BufferedReader(reader);
            reader = bufferedReader2;
        }
        return reader;
    }

    public static BufferedWriter toBufferedWriter(Writer writer) {
        if (writer instanceof BufferedWriter) {
            writer = (BufferedWriter)writer;
        } else {
            BufferedWriter bufferedWriter;
            BufferedWriter bufferedWriter2 = bufferedWriter;
            bufferedWriter = new BufferedWriter(writer);
            writer = bufferedWriter2;
        }
        return writer;
    }

    public static InputStream toInputStream(CharSequence charSequence) {
        return new ByteArrayInputStream(charSequence.toString().getBytes());
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charset.forName(string));
    }

    public static InputStream toInputStream(CharSequence object, Charset charset) {
        object = object.toString().getBytes(charset);
        return new ByteArrayInputStream((byte[])object);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return new String(IOUtils.toByteArray(inputStream));
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return new String(IOUtils.toByteArray(inputStream), string);
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        return new String(IOUtils.toByteArray(inputStream), charset);
    }

    public static String toString(Reader reader) throws IOException {
        return new String(IOUtils.toByteArray(reader));
    }

    public static String toString(Reader reader, String string) throws IOException {
        return new String(IOUtils.toByteArray(reader), string);
    }

    public static String toString(Reader reader, Charset charset) throws IOException {
        return new String(IOUtils.toByteArray(reader), charset);
    }

    public static String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static String toString(byte[] byArray, String string) {
        return IOUtils.toString(byArray, Charset.forName(string));
    }

    public static String toString(byte[] byArray, Charset charset) {
        return new String(byArray, charset);
    }

    public static byte[] toByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return new byte[0];
        }
        return charSequence.toString().getBytes();
    }

    public static byte[] toByteArray(CharSequence charSequence, String string) {
        return IOUtils.toByteArray(charSequence, Charset.forName(string));
    }

    public static byte[] toByteArray(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            return new byte[0];
        }
        return charSequence.toString().getBytes(charset);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.write(inputStream, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) throws IOException {
        if (n2 >= 0) {
            int n3;
            int n4;
            if (n2 == 0) {
                return new byte[0];
            }
            byte[] byArray = new byte[n2];
            for (n3 = 0; n3 < n2; n3 += n4) {
                n4 = n2 - n3;
                if ((n4 = inputStream.read(byArray, n3, n4)) == -1) break;
            }
            if (n3 == n2) {
                return byArray;
            }
            throw new IOException("Unexpected byte count size. current: " + n3 + ", excepted: " + n2);
        }
        throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.write(reader, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        return IOUtils.toByteArray(reader, Charset.forName(string));
    }

    public static byte[] toByteArray(Reader reader, Charset charset) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.write(reader, (OutputStream)byteArrayOutputStream, charset);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static char[] toCharArray(CharSequence charSequence) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.write((Writer)charArrayWriter, charSequence);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream closeable) throws IOException {
        CharArrayWriter charArrayWriter;
        InputStream inputStream = closeable;
        closeable = charArrayWriter;
        IOUtils.write(inputStream, (Writer)new CharArrayWriter());
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        return IOUtils.toCharArray(inputStream, Charset.forName(string));
    }

    public static char[] toCharArray(InputStream closeable, Charset charset) throws IOException {
        CharArrayWriter charArrayWriter;
        InputStream inputStream = closeable;
        closeable = charArrayWriter;
        IOUtils.write(inputStream, (Writer)new CharArrayWriter(), charset);
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static char[] toCharArray(Reader closeable) throws IOException {
        CharArrayWriter charArrayWriter;
        Reader reader = closeable;
        closeable = charArrayWriter;
        IOUtils.write(reader, (Writer)new CharArrayWriter());
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static List<String> readLines(InputStream inputStream, String string) throws IOException {
        return IOUtils.readLines(inputStream, Charset.forName(string));
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        return IOUtils.readLines(new InputStreamReader(inputStream, charset));
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        return IOUtils.readLines(new InputStreamReader(inputStream));
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList;
        reader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        String string = ((BufferedReader)reader).readLine();
        while (string != null) {
            arrayList2.add(string);
            string = ((BufferedReader)reader).readLine();
        }
        return arrayList2;
    }

    public static void write(OutputStream outputStream, byte[] byArray) throws IOException {
        if (byArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(byArray);
            outputStream2.flush();
        }
    }

    public static void write(Writer object, byte[] byArray) throws IOException {
        if (byArray != null) {
            String string;
            Writer writer = object;
            object = string;
            string = new String(byArray);
            writer.write((String)object);
            writer.flush();
        }
    }

    public static void write(Writer writer, byte[] byArray, String string) throws IOException {
        IOUtils.write(writer, byArray, Charset.forName(string));
    }

    public static void write(Writer object, byte[] byArray, Charset charset) throws IOException {
        if (byArray != null) {
            String string;
            Writer writer = object;
            object = string;
            string = new String(byArray, charset);
            writer.write((String)object);
            writer.flush();
        }
    }

    public static void write(Writer writer, char[] cArray) throws IOException {
        if (cArray != null) {
            Writer writer2 = writer;
            writer2.write(cArray);
            writer2.flush();
        }
    }

    public static void write(OutputStream outputStream, char[] cArray) throws IOException {
        if (cArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(new String(cArray).getBytes());
            outputStream2.flush();
        }
    }

    public static void write(OutputStream outputStream, char[] cArray, String string) throws IOException {
        IOUtils.write(outputStream, cArray, Charset.forName(string));
    }

    public static void write(OutputStream outputStream, char[] cArray, Charset charset) throws IOException {
        if (cArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(new String(cArray).getBytes(charset));
            outputStream2.flush();
        }
    }

    public static void write(Writer writer, CharSequence charSequence) throws IOException {
        if (charSequence != null) {
            Writer writer2 = writer;
            writer2.write(charSequence.toString());
            writer2.flush();
        }
    }

    public static void write(OutputStream outputStream, CharSequence charSequence) throws IOException {
        if (charSequence != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(charSequence.toString().getBytes());
            outputStream2.flush();
        }
    }

    public static void write(OutputStream outputStream, CharSequence charSequence, String string) throws IOException {
        IOUtils.write(outputStream, charSequence, Charset.forName(string));
    }

    public static void write(OutputStream outputStream, CharSequence charSequence, Charset charset) throws IOException {
        if (charSequence != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(charSequence.toString().getBytes(charset));
            outputStream2.flush();
        }
    }

    public static void write(Reader closeable, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Reader reader = closeable;
        closeable = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtils.write(reader, (Writer)closeable);
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(byArray, 0, n2);
            outputStream2.flush();
        }
    }

    public static void write(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.write((Reader)new InputStreamReader(inputStream), writer);
    }

    public static void write(Reader reader, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(reader, outputStream, Charset.forName(string));
    }

    public static void write(Reader closeable, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Reader reader = closeable;
        closeable = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        IOUtils.write(reader, (Writer)closeable);
    }

    public static void write(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(inputStream, outputStream, Charset.forName(string));
    }

    public static void write(InputStream inputStream, OutputStream outputStream, Charset charset) throws IOException {
        IOUtils.write((Reader)new InputStreamReader(inputStream, charset), outputStream);
    }

    public static void write(InputStream inputStream, Writer writer, String string) throws IOException {
        IOUtils.write(inputStream, writer, Charset.forName(string));
    }

    public static void write(InputStream inputStream, Writer writer, Charset charset) throws IOException {
        IOUtils.write((Reader)new InputStreamReader(inputStream, charset), writer);
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        while (-1 != (n2 = reader.read(cArray))) {
            Writer writer2 = writer;
            writer2.write(cArray, 0, n2);
            writer2.flush();
        }
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        inputStream = IOUtils.toBufferedInputStream(inputStream);
        inputStream2 = IOUtils.toBufferedInputStream(inputStream2);
        int n2 = inputStream.read();
        while (-1 != n2) {
            if (n2 != inputStream2.read()) {
                return false;
            }
            n2 = inputStream.read();
        }
        return inputStream2.read() == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        int n2 = reader.read();
        while (-1 != n2) {
            if (n2 != reader2.read()) {
                return false;
            }
            n2 = reader.read();
        }
        return reader2.read() == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) throws IOException {
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        String string = ((BufferedReader)reader).readLine();
        String string2 = ((BufferedReader)reader2).readLine();
        while (string != null && string2 != null && string.equals(string2)) {
            string = ((BufferedReader)reader).readLine();
            string2 = ((BufferedReader)reader2).readLine();
        }
        return string != null && (string2 == null || string.equals(string2));
    }

    public static long getDirSize(String string) {
        StatFs statFs;
        block3: {
            StatFs statFs2;
            statFs = statFs2;
            try {
                statFs2 = new StatFs(string);
                if (Build.VERSION.SDK_INT < 18) break block3;
            }
            catch (Exception exception) {
                return 0L;
            }
            return statFs.getBlockSizeLong() * statFs.getAvailableBlocksLong();
        }
        return (long)statFs.getBlockSize() * (long)statFs.getAvailableBlocks();
    }

    public static boolean canWrite(String string) {
        return new File(string).canWrite();
    }

    public static boolean canRead(String string) {
        return new File(string).canRead();
    }

    public static boolean createFolder(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return IOUtils.createFolder(new File(string));
        }
        return false;
    }

    public static boolean createFolder(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            file.delete();
        }
        return file.mkdirs();
    }

    public static boolean createNewFolder(String string) {
        return IOUtils.delFileOrFolder(string) && IOUtils.createFolder(string);
    }

    public static boolean createNewFolder(File file) {
        return IOUtils.delFileOrFolder(file) && IOUtils.createFolder(file);
    }

    public static boolean createFile(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return IOUtils.createFile(new File(string));
        }
        return false;
    }

    public static boolean createFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return true;
            }
            IOUtils.delFileOrFolder(file);
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean createNewFile(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return IOUtils.createNewFile(new File(string));
        }
        return false;
    }

    public static boolean createNewFile(File file) {
        if (file.exists()) {
            IOUtils.delFileOrFolder(file);
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean delFileOrFolder(String string) {
        return IOUtils.delFileOrFolder(new File(string));
    }

    public static boolean delFileOrFolder(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    int n2 = fileArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        IOUtils.delFileOrFolder(fileArray[i2]);
                    }
                }
                file.delete();
            }
        }
        return true;
    }
}

