/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.urlconnect;

import android.text.TextUtils;
import com.meihu.kalle.connect.Connection;
import com.meihu.kalle.connect.stream.NullStream;
import com.meihu.kalle.connect.stream.SourceStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class URLConnection
implements Connection {
    private HttpURLConnection mConnection;

    public URLConnection(HttpURLConnection httpURLConnection) {
        this.mConnection = httpURLConnection;
    }

    private static InputStream getInputStream(String object, InputStream object2) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)object) && ((String)object).contains("gzip")) {
            GZIPInputStream gZIPInputStream;
            object = gZIPInputStream;
            gZIPInputStream = new GZIPInputStream((InputStream)object2);
            object2 = object;
        }
        return object2;
    }

    private static boolean hasBody(String string, int n2) {
        return !"HEAD".equalsIgnoreCase(string) && URLConnection.hasBody(n2);
    }

    private static boolean hasBody(int n2) {
        return n2 > 100 && n2 != 204 && n2 != 205 && (n2 < 300 || n2 >= 400);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.mConnection.getOutputStream();
    }

    @Override
    public int getCode() throws IOException {
        return this.mConnection.getResponseCode();
    }

    @Override
    public Map<String, List<String>> getHeaders() throws IOException {
        return this.mConnection.getHeaderFields();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = this;
        int n2 = uRLConnection.mConnection.getResponseCode();
        if (!URLConnection.hasBody(uRLConnection.mConnection.getRequestMethod(), n2)) {
            return new NullStream(this);
        }
        if (n2 >= 400) {
            URLConnection uRLConnection2 = this;
            return URLConnection.getInputStream(this.mConnection.getContentEncoding(), new SourceStream(uRLConnection2, uRLConnection2.mConnection.getErrorStream()));
        }
        URLConnection uRLConnection3 = this;
        return URLConnection.getInputStream(this.mConnection.getContentEncoding(), new SourceStream(uRLConnection3, uRLConnection3.mConnection.getInputStream()));
    }

    @Override
    public void disconnect() {
        HttpURLConnection httpURLConnection = ((URLConnection)((Object)httpURLConnection)).mConnection;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
    }

    @Override
    public void close() throws IOException {
        HttpURLConnection httpURLConnection = ((URLConnection)((Object)httpURLConnection)).mConnection;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
    }
}

