/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.cookie;

import android.text.TextUtils;
import com.meihu.kalle.cookie.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CookieManager {
    private CookieStore cookieJar;

    public CookieManager(CookieStore cookieStore) {
        this.cookieJar = cookieStore;
    }

    private static int getPort(URI uRI) {
        int n2 = uRI.getPort();
        if (n2 == -1) {
            n2 = "https".equals(uRI.getScheme()) ? 443 : 80;
        }
        return n2;
    }

    private static boolean containsPort(String stringArray, int n2) {
        if (stringArray.contains(",")) {
            stringArray = stringArray.split(",");
            String string = Integer.toString(n2);
            int n3 = stringArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!stringArray[i2].equals(string)) continue;
                return true;
            }
            return false;
        }
        return stringArray.equalsIgnoreCase(Integer.toString(n2));
    }

    private static boolean pathMatches(URI uRI, HttpCookie httpCookie) {
        return CookieManager.normalizePath(uRI.getPath()).startsWith(CookieManager.normalizePath(httpCookie.getPath()));
    }

    private static String normalizePath(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    private String sortByPath(List<HttpCookie> list) {
        StringBuilder stringBuilder;
        CookiePathComparator cookiePathComparator;
        List<HttpCookie> list2 = list;
        Object object = cookiePathComparator;
        cookiePathComparator = new CookiePathComparator();
        Collections.sort(list2, object);
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = 1;
        for (HttpCookie httpCookie : list2) {
            if (httpCookie.getVersion() >= n2) continue;
            n2 = httpCookie.getVersion();
        }
        if (n2 == 1) {
            ((StringBuilder)object).append("$Version=\"1\"; ");
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            if (n2 != 0) {
                ((StringBuilder)object).append("; ");
            }
            ((StringBuilder)object).append(list.get(n2).toString());
        }
        return ((StringBuilder)object).toString();
    }

    public List<String> get(URI serializable) {
        ArrayList arrayList;
        ArrayList<HttpCookie> arrayList2;
        boolean bl = "https".equalsIgnoreCase(serializable.getScheme());
        ArrayList<HttpCookie> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<HttpCookie>();
        for (HttpCookie httpCookie : this.cookieJar.get((URI)serializable)) {
            if (!CookieManager.pathMatches(serializable, httpCookie) || !bl && httpCookie.getSecure()) continue;
            String string = httpCookie.getPortlist();
            int n2 = CookieManager.getPort(serializable);
            if (!TextUtils.isEmpty((CharSequence)string) && !CookieManager.containsPort(string, n2)) continue;
            arrayList3.add(httpCookie);
        }
        if (arrayList3.isEmpty()) {
            return Collections.emptyList();
        }
        serializable = arrayList;
        ((ArrayList)serializable)();
        arrayList.add(this.sortByPath(arrayList3));
        return arrayList;
    }

    public void add(URI uRI, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            for (HttpCookie httpCookie : HttpCookie.parse((String)object.next())) {
                if (httpCookie.getPath() == null) {
                    httpCookie.setPath(CookieManager.normalizePath(uRI.getPath()));
                } else if (!CookieManager.pathMatches(uRI, httpCookie)) continue;
                if (httpCookie.getDomain() == null) {
                    httpCookie.setDomain(uRI.getHost());
                }
                String string = httpCookie.getPortlist();
                int n2 = CookieManager.getPort(uRI);
                if (!TextUtils.isEmpty((CharSequence)string) && !CookieManager.containsPort(string, n2)) continue;
                this.cookieJar.add(uRI, httpCookie);
            }
        }
    }

    private static class CookiePathComparator
    implements Comparator<HttpCookie> {
        private CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie object, HttpCookie httpCookie) {
            if (object == httpCookie) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (httpCookie == null) {
                return 1;
            }
            if (!((HttpCookie)object).getName().equals(httpCookie.getName())) {
                return 0;
            }
            String string = CookieManager.normalizePath(((HttpCookie)object).getPath());
            if (string.startsWith((String)(object = CookieManager.normalizePath(httpCookie.getPath())))) {
                return -1;
            }
            if (((String)object).startsWith(string)) {
                return 1;
            }
            return 0;
        }
    }
}

