/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle.connect;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;

public class NetworkChecker {
    private ConnectivityManager mManager;

    public NetworkChecker(Context context) {
        this.mManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    private static boolean isConnected(NetType netType, NetworkInfo networkInfo) {
        if (networkInfo == null) {
            return false;
        }
        switch (1.$SwitchMap$com$meihu$kalle$connect$NetworkChecker$NetType[netType.ordinal()]) {
            default: {
                return false;
            }
            case 6: {
                if (!NetworkChecker.isConnected(NetType.Mobile, networkInfo)) {
                    return false;
                }
                return NetworkChecker.isMobileSubType(NetType.Mobile4G, networkInfo);
            }
            case 5: {
                if (!NetworkChecker.isConnected(NetType.Mobile, networkInfo)) {
                    return false;
                }
                return NetworkChecker.isMobileSubType(NetType.Mobile3G, networkInfo);
            }
            case 4: {
                if (!NetworkChecker.isConnected(NetType.Mobile, networkInfo)) {
                    return false;
                }
                return NetworkChecker.isMobileSubType(NetType.Mobile2G, networkInfo);
            }
            case 3: {
                if (!NetworkChecker.isConnected(networkInfo)) {
                    return false;
                }
                return networkInfo.getType() == 0;
            }
            case 2: {
                if (!NetworkChecker.isConnected(networkInfo)) {
                    return false;
                }
                if (Build.VERSION.SDK_INT >= 13) {
                    return networkInfo.getType() == 9;
                }
                return false;
            }
            case 1: 
        }
        if (!NetworkChecker.isConnected(networkInfo)) {
            return false;
        }
        return networkInfo.getType() == 1;
    }

    private static boolean isConnected(NetworkInfo networkInfo) {
        return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
    }

    private static boolean isMobileSubType(NetType netType, NetworkInfo object) {
        block5: {
            switch (object.getType()) {
                default: {
                    object = object.getSubtypeName();
                    if (!((String)object).equalsIgnoreCase("TD-SCDMA") && !((String)object).equalsIgnoreCase("WCDMA") && !((String)object).equalsIgnoreCase("CDMA2000")) break;
                    break block5;
                }
                case 13: 
                case 18: {
                    return netType == NetType.Mobile4G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    return netType == NetType.Mobile3G;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return netType == NetType.Mobile2G;
                }
            }
            return false;
        }
        return netType == NetType.Mobile3G;
    }

    public boolean isAvailable() {
        return this.isWifiConnected() || this.isWiredConnected() || this.isMobileConnected();
    }

    public final boolean isWifiConnected() {
        return this.isAvailable(NetType.Wifi);
    }

    public final boolean isWiredConnected() {
        return this.isAvailable(NetType.Wired);
    }

    public final boolean isMobileConnected() {
        return this.isAvailable(NetType.Mobile);
    }

    public final boolean isMobile2GConnected() {
        return this.isAvailable(NetType.Mobile2G);
    }

    public final boolean isMobile3GConnected() {
        return this.isAvailable(NetType.Mobile3G);
    }

    public final boolean isMobile4GConnected() {
        return this.isAvailable(NetType.Mobile4G);
    }

    public final boolean isAvailable(NetType netType) {
        return NetworkChecker.isConnected(netType, this.mManager.getActiveNetworkInfo());
    }

    public static final class NetType
    extends Enum<NetType> {
        public static final /* enum */ NetType Wifi;
        public static final /* enum */ NetType Wired;
        public static final /* enum */ NetType Mobile;
        public static final /* enum */ NetType Mobile2G;
        public static final /* enum */ NetType Mobile3G;
        public static final /* enum */ NetType Mobile4G;
        private static final /* synthetic */ NetType[] $VALUES;

        public static NetType[] values() {
            return (NetType[])$VALUES.clone();
        }

        public static NetType valueOf(String string) {
            return Enum.valueOf(NetType.class, string);
        }

        static {
            NetType netType;
            NetType netType2;
            NetType netType3;
            NetType netType4;
            NetType netType5;
            NetType netType6;
            NetType netType7 = netType6;
            Wifi = new NetType();
            NetType netType8 = netType5;
            Wired = new NetType();
            NetType netType9 = netType4;
            Mobile = new NetType();
            NetType netType10 = netType3;
            Mobile2G = new NetType();
            NetType netType11 = netType2;
            Mobile3G = new NetType();
            NetType netType12 = netType;
            Mobile4G = new NetType();
            $VALUES = new NetType[]{netType7, netType8, netType9, netType10, netType11, netType12};
        }
    }
}

