/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.text.TextUtils;
import com.meihu.kalle.BaseContent;
import com.meihu.kalle.Kalle;
import com.meihu.kalle.Params;
import com.meihu.kalle.RequestBody;
import com.meihu.kalle.StringBody;
import com.meihu.kalle.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

public class UrlBody
extends BaseContent<StringBody>
implements RequestBody {
    private final Params mParams;
    private final Charset mCharset;
    private final String mContentType;

    public static Builder newBuilder() {
        return new Builder();
    }

    private UrlBody(Builder object) {
        this.mParams = ((Builder)object).mParams.build();
        Charset charset = ((Builder)object).mCharset == null ? Kalle.getConfig().getCharset() : ((Builder)object).mCharset;
        this.mCharset = charset;
        object = TextUtils.isEmpty((CharSequence)((Builder)object).mContentType) ? "application/x-www-form-urlencoded" : ((Builder)object).mContentType;
        this.mContentType = object;
    }

    public Params copyParams() {
        return this.mParams;
    }

    @Override
    public long contentLength() {
        return IOUtils.toByteArray((CharSequence)this.mParams.toString(true), this.mCharset).length;
    }

    @Override
    public String contentType() {
        return this.mContentType + "; charset=" + this.mCharset.name();
    }

    @Override
    protected void onWrite(OutputStream outputStream) throws IOException {
        UrlBody urlBody = string;
        String string = urlBody.mParams.toString(true);
        IOUtils.write(outputStream, (CharSequence)string, urlBody.mCharset);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return this.mParams.toString(bl);
    }

    public static class Builder {
        private Charset mCharset;
        private String mContentType;
        private Params.Builder mParams = Params.newBuilder();

        private Builder() {
        }

        public Builder charset(Charset charset) {
            this.mCharset = charset;
            return this;
        }

        public Builder contentType(String string) {
            this.mContentType = string;
            return this;
        }

        public Builder param(String string, int n2) {
            Builder builder = this;
            builder.mParams.add(string, n2);
            return builder;
        }

        public Builder param(String string, long l2) {
            Builder builder = this;
            builder.mParams.add(string, l2);
            return builder;
        }

        public Builder param(String string, boolean bl) {
            Builder builder = this;
            builder.mParams.add(string, bl);
            return builder;
        }

        public Builder param(String string, char c2) {
            Builder builder = this;
            builder.mParams.add(string, c2);
            return builder;
        }

        public Builder param(String string, double d2) {
            Builder builder = this;
            builder.mParams.add(string, d2);
            return builder;
        }

        public Builder param(String string, float f2) {
            Builder builder = this;
            builder.mParams.add(string, f2);
            return builder;
        }

        public Builder param(String string, short s2) {
            Builder builder = this;
            builder.mParams.add(string, s2);
            return builder;
        }

        public Builder param(String string, CharSequence charSequence) {
            Builder builder = this;
            builder.mParams.add(string, charSequence);
            return builder;
        }

        public Builder param(String string, String string2) {
            Builder builder = this;
            builder.mParams.add(string, string2);
            return builder;
        }

        public Builder param(String string, List<String> list) {
            Builder builder = this;
            builder.mParams.add(string, list);
            return builder;
        }

        public Builder params(Params params) {
            Builder builder = this;
            builder.mParams.add(params);
            return builder;
        }

        public Builder removeParam(String string) {
            Builder builder = this;
            builder.mParams.remove(string);
            return builder;
        }

        public Builder clearParams() {
            Builder builder = this;
            builder.mParams.clear();
            return builder;
        }

        public UrlBody build() {
            return new UrlBody(this);
        }
    }
}

