/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.meihu.kalle.Params;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Url {
    private final String TAG = Url.class.getName();
    private final String mScheme;
    private final String mHost;
    private final int mPort;
    private final String mPath;
    private final String mQuery;
    private final String mFragment;

    public static Builder newBuilder(String string) {
        return new Builder(string);
    }

    private Url(Builder builder) {
        this.mScheme = builder.mScheme;
        this.mHost = builder.mHost;
        this.mPort = builder.mPort;
        this.mPath = Url.wrapPath(builder.mPath, false);
        this.mQuery = builder.mQuery.build().toString(false);
        this.mFragment = builder.mFragment;
    }

    private static int convertPort(int n2) {
        if (n2 <= 0) {
            n2 = 80;
        }
        return n2;
    }

    private static List<String> convertPath(String string) {
        LinkedList<String> linkedList;
        LinkedList<String> linkedList2 = linkedList;
        linkedList = new LinkedList<String>();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            while (string.endsWith("/")) {
                String string2 = string;
                string = string2.substring(0, string2.length() - 1);
            }
            Collections.addAll(linkedList2, string.split("/"));
        }
        return linkedList2;
    }

    private static Params convertQuery(String stringArray) {
        Params.Builder builder = Params.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)stringArray)) {
            if (stringArray.startsWith("?")) {
                stringArray = stringArray.substring(1);
            }
            for (String string : stringArray.split("&")) {
                String string2 = "";
                int n2 = string.indexOf("=");
                if (n2 > 0) {
                    String string3 = string;
                    String string4 = string3.substring(0, n2);
                    if (n2 < string3.length() - 1) {
                        string2 = string.substring(n2 + 1);
                        string = string4;
                    } else {
                        string = string4;
                    }
                }
                builder.add(string, string2);
            }
        }
        return builder.build();
    }

    private static String wrapPort(int n2) {
        String string;
        if (n2 > 0 && n2 != 80) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            string = String.format(Locale.getDefault(), ":%d", objectArray2);
        } else {
            string = "";
        }
        return string;
    }

    private static String wrapPath(List<String> object, boolean bl) {
        StringBuilder stringBuilder;
        if (object.isEmpty()) {
            return "/";
        }
        List<String> list = object;
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        for (String string : list) {
            StringBuilder stringBuilder2 = ((StringBuilder)object).append("/");
            if (bl) {
                string = Uri.encode((String)string);
            }
            stringBuilder2.append(string);
        }
        return ((StringBuilder)object).toString();
    }

    private static String wrapQuery(Params object, boolean bl) {
        String string;
        if (TextUtils.isEmpty((CharSequence)(object = ((Params)object).toString(bl)))) {
            string = "";
        } else {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            string = String.format("?%s", objectArray2);
        }
        return string;
    }

    private static String wrapFragment(String string, boolean bl) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "";
        } else {
            String string3 = "#%s";
            Object[] objectArray = new Object[1];
            int n2 = 0;
            if (bl) {
                string = Uri.encode((String)string);
            }
            objectArray[n2] = string;
            string2 = String.format(string3, objectArray);
        }
        return string2;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getPath() {
        return this.mPath;
    }

    public List<String> copyPath() {
        return Url.convertPath(this.mPath);
    }

    public String getQuery() {
        return this.mQuery;
    }

    @Deprecated
    public Params copyQuery() {
        return this.getParams();
    }

    public Params getParams() {
        return Url.convertQuery(this.mQuery);
    }

    public String getFragment() {
        return this.mFragment;
    }

    public Builder builder() {
        return Url.newBuilder(this.toString());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        Url url = this;
        String string = Url.wrapPath(Url.convertPath(url.mPath), bl);
        String string2 = Url.wrapQuery(Url.convertQuery(url.mQuery), bl);
        return this.mScheme + "://" + this.mHost + Url.wrapPort(this.mPort) + string + string2 + Url.wrapFragment(url.mFragment, bl);
    }

    public Url location(String object) {
        Object object2;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        if (URLUtil.isNetworkUrl((String)object)) {
            return Url.newBuilder((String)object).build();
        }
        String string = object;
        URI uRI = URI.create(string);
        if (string.startsWith("/")) {
            return ((Url)object2).builder().setPath(uRI.getPath()).setQuery(uRI.getQuery()).setFragment(uRI.getFragment()).build();
        }
        if (((String)object).contains("../")) {
            object = Url.convertPath(((Url)object2).getPath());
            List<String> list = Url.convertPath(uRI.getPath());
            int n2 = list.lastIndexOf("..");
            int n3 = n2 + 1;
            List<String> list2 = list.subList(n3, list.size());
            if (!object.isEmpty()) {
                List<String> list3 = object2;
                Object object3 = object;
                object2 = object3.subList(0, object3.size() - n2 - 2);
                object2.addAll(list2);
                object2 = TextUtils.join((CharSequence)"/", object2);
                return ((Url)((Object)list3)).builder().setPath((String)object2).setQuery(uRI.getQuery()).setFragment(uRI.getFragment()).build();
            }
            List<String> list4 = object2;
            object2 = TextUtils.join((CharSequence)"/", list2);
            return ((Url)((Object)list4)).builder().setPath((String)object2).setQuery(uRI.getQuery()).setFragment(uRI.getFragment()).build();
        }
        Url url = object2;
        object2 = Url.convertPath(url.getPath());
        object2.addAll(Url.convertPath(uRI.getPath()));
        object2 = TextUtils.join((CharSequence)"/", (Iterable)object2);
        return url.builder().setPath((String)object2).setQuery(uRI.getQuery()).setFragment(uRI.getFragment()).build();
    }

    public static class Builder {
        private String mScheme;
        private String mHost;
        private int mPort;
        private List<String> mPath;
        private Params.Builder mQuery;
        private String mFragment;

        private Builder(String string) {
            Builder builder = uRI;
            URI uRI = URI.create(string);
            builder.mScheme = uRI.getScheme();
            builder.mHost = uRI.getHost();
            builder.mPort = Url.convertPort(uRI.getPort());
            builder.mPath = Url.convertPath(uRI.getPath());
            builder.mQuery = Url.convertQuery(uRI.getQuery()).builder();
            builder.mFragment = uRI.getFragment();
        }

        public Builder setScheme(String string) {
            this.mScheme = string;
            return this;
        }

        public Builder setHost(String string) {
            this.mHost = string;
            return this;
        }

        public Builder setPort(int n2) {
            this.mPort = n2;
            return this;
        }

        public Builder addPath(int n2) {
            return this.addPath(Integer.toString(n2));
        }

        public Builder addPath(long l2) {
            return this.addPath(Long.toString(l2));
        }

        public Builder addPath(boolean bl) {
            return this.addPath(Boolean.toString(bl));
        }

        public Builder addPath(char c2) {
            return this.addPath(String.valueOf(c2));
        }

        public Builder addPath(double d2) {
            return this.addPath(Double.toString(d2));
        }

        public Builder addPath(float f2) {
            return this.addPath(Float.toString(f2));
        }

        public Builder addPath(String string) {
            Builder builder = this;
            builder.mPath.add(string);
            return builder;
        }

        public Builder setPath(String string) {
            this.mPath = Url.convertPath(string);
            return this;
        }

        public Builder clearPath() {
            Builder builder = this;
            builder.mPath.clear();
            return builder;
        }

        public Builder addQuery(String string, int n2) {
            return this.addQuery(string, Integer.toString(n2));
        }

        public Builder addQuery(String string, long l2) {
            return this.addQuery(string, Long.toString(l2));
        }

        public Builder addQuery(String string, boolean bl) {
            return this.addQuery(string, Boolean.toString(bl));
        }

        public Builder addQuery(String string, char c2) {
            return this.addQuery(string, String.valueOf(c2));
        }

        public Builder addQuery(String string, double d2) {
            return this.addQuery(string, Double.toString(d2));
        }

        public Builder addQuery(String string, float f2) {
            return this.addQuery(string, Float.toString(f2));
        }

        public Builder addQuery(String string, short s2) {
            return this.addQuery(string, Integer.toString(s2));
        }

        public Builder addQuery(String string, String string2) {
            Builder builder = this;
            builder.mQuery.add(string, string2);
            return builder;
        }

        public Builder addQuery(String string, List<String> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.addQuery(string, (String)object.next());
            }
            return this;
        }

        public Builder addQuery(Params object) {
            for (Map.Entry<String, List<Object>> entry : ((Params)((Object)object)).entrySet()) {
                String string = entry.getKey();
                for (Object e2 : entry.getValue()) {
                    if (!(e2 instanceof CharSequence)) continue;
                    this.addQuery(string, e2.toString());
                }
            }
            return this;
        }

        public Builder setQuery(String string) {
            this.mQuery = Url.convertQuery(string).builder();
            return this;
        }

        public Builder setQuery(Params params) {
            this.mQuery = params.builder();
            return this;
        }

        public Builder removeQuery(String string) {
            Builder builder = this;
            builder.mQuery.remove(string);
            return builder;
        }

        public Builder clearQuery() {
            Builder builder = this;
            builder.mQuery.clear();
            return builder;
        }

        public Builder setFragment(String string) {
            this.mFragment = string;
            return this;
        }

        public Url build() {
            return new Url(this);
        }
    }
}

