/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import com.meihu.kalle.Headers;
import com.meihu.kalle.ResponseBody;
import com.meihu.kalle.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;

public final class Response
implements Closeable {
    private final int mCode;
    private final Headers mHeaders;
    private final ResponseBody mBody;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Response(Builder builder) {
        this.mCode = builder.mCode;
        this.mHeaders = builder.mHeaders;
        this.mBody = builder.mBody;
    }

    public int code() {
        return this.mCode;
    }

    public Headers headers() {
        return this.mHeaders;
    }

    public ResponseBody body() {
        return this.mBody;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.mBody);
    }

    public boolean isRedirect() {
        switch (this.mCode) {
            default: {
                return false;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: 
        }
        return true;
    }

    public static final class Builder {
        private int mCode;
        private Headers mHeaders;
        private ResponseBody mBody;

        public Builder code(int n2) {
            this.mCode = n2;
            return this;
        }

        public Builder headers(Headers headers) {
            this.mHeaders = headers;
            return this;
        }

        public Builder body(ResponseBody responseBody) {
            this.mBody = responseBody;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

