/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import com.meihu.kalle.Headers;
import com.meihu.kalle.Params;
import com.meihu.kalle.connect.ConnectFactory;
import com.meihu.kalle.connect.Interceptor;
import com.meihu.kalle.connect.Network;
import com.meihu.kalle.cookie.CookieStore;
import com.meihu.kalle.simple.Converter;
import com.meihu.kalle.simple.cache.CacheStore;
import com.meihu.kalle.ssl.SSLUtils;
import com.meihu.kalle.urlconnect.URLConnectionFactory;
import com.meihu.kalle.util.MainExecutor;
import com.meihu.kalle.util.WorkExecutor;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class KalleConfig {
    private final Executor mWorkExecutor;
    private final Executor mMainExecutor;
    private final Charset mCharset;
    private final Headers mHeaders;
    private final Proxy mProxy;
    private final SSLSocketFactory mSSLSocketFactory;
    private final HostnameVerifier mHostnameVerifier;
    private final int mConnectTimeout;
    private final int mReadTimeout;
    private final Params mParams;
    private final CacheStore mCacheStore;
    private final Network mNetwork;
    private final ConnectFactory mConnectFactory;
    private final CookieStore mCookieStore;
    private final List<Interceptor> mInterceptors;
    private final Converter mConverter;

    public static Builder newBuilder() {
        return new Builder();
    }

    private KalleConfig(Builder object) {
        Object object2;
        if (((Builder)object).mWorkExecutor == null) {
            WorkExecutor workExecutor;
            object2 = workExecutor;
            workExecutor = new WorkExecutor();
        } else {
            object2 = ((Builder)object).mWorkExecutor;
        }
        this.mWorkExecutor = object2;
        if (((Builder)object).mMainExecutor == null) {
            MainExecutor mainExecutor;
            object2 = mainExecutor;
            mainExecutor = new MainExecutor();
        } else {
            object2 = ((Builder)object).mMainExecutor;
        }
        this.mMainExecutor = object2;
        object2 = ((Builder)object).mCharset == null ? Charset.defaultCharset() : ((Builder)object).mCharset;
        this.mCharset = object2;
        this.mHeaders = ((Builder)object).mHeaders;
        this.mProxy = ((Builder)object).mProxy;
        object2 = ((Builder)object).mSSLSocketFactory == null ? SSLUtils.SSL_SOCKET_FACTORY : ((Builder)object).mSSLSocketFactory;
        this.mSSLSocketFactory = object2;
        object2 = ((Builder)object).mHostnameVerifier == null ? SSLUtils.HOSTNAME_VERIFIER : ((Builder)object).mHostnameVerifier;
        this.mHostnameVerifier = object2;
        int n2 = ((Builder)object).mConnectTimeout <= 0 ? 15000 : ((Builder)object).mConnectTimeout;
        this.mConnectTimeout = n2;
        n2 = ((Builder)object).mReadTimeout <= 0 ? 15000 : ((Builder)object).mReadTimeout;
        this.mReadTimeout = n2;
        this.mParams = ((Builder)object).mParams.build();
        Object object3 = ((Builder)object).mCacheStore == null ? CacheStore.DEFAULT : ((Builder)object).mCacheStore;
        this.mCacheStore = object3;
        object3 = ((Builder)object).mNetwork == null ? Network.DEFAULT : ((Builder)object).mNetwork;
        this.mNetwork = object3;
        object3 = ((Builder)object).mConnectFactory == null ? URLConnectionFactory.newBuilder().build() : ((Builder)object).mConnectFactory;
        this.mConnectFactory = object3;
        object3 = ((Builder)object).mCookieStore == null ? CookieStore.DEFAULT : ((Builder)object).mCookieStore;
        this.mCookieStore = object3;
        this.mInterceptors = Collections.unmodifiableList(((Builder)object).mInterceptors);
        object = ((Builder)object).mConverter == null ? Converter.DEFAULT : ((Builder)object).mConverter;
        this.mConverter = object;
    }

    public Executor getWorkExecutor() {
        return this.mWorkExecutor;
    }

    public Executor getMainExecutor() {
        return this.mMainExecutor;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public Headers getHeaders() {
        return this.mHeaders;
    }

    public Proxy getProxy() {
        return this.mProxy;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.mHostnameVerifier;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public Params getParams() {
        return this.mParams;
    }

    public CacheStore getCacheStore() {
        return this.mCacheStore;
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public ConnectFactory getConnectFactory() {
        return this.mConnectFactory;
    }

    public CookieStore getCookieStore() {
        return this.mCookieStore;
    }

    public List<Interceptor> getInterceptor() {
        return this.mInterceptors;
    }

    public Converter getConverter() {
        return this.mConverter;
    }

    public static final class Builder {
        private Executor mWorkExecutor;
        private Executor mMainExecutor;
        private Charset mCharset;
        private Headers mHeaders;
        private Proxy mProxy;
        private SSLSocketFactory mSSLSocketFactory;
        private HostnameVerifier mHostnameVerifier;
        private int mConnectTimeout;
        private int mReadTimeout;
        private Params.Builder mParams;
        private CacheStore mCacheStore;
        private Network mNetwork;
        private ConnectFactory mConnectFactory;
        private CookieStore mCookieStore;
        private List<Interceptor> mInterceptors;
        private Converter mConverter;

        private Builder() {
            Builder builder = this;
            builder.mHeaders = new Headers();
            builder.mParams = Params.newBuilder();
            builder.mInterceptors = new ArrayList<Interceptor>();
            builder.mHeaders.set("Accept", "*/*");
            builder.mHeaders.set("Accept-Encoding", "gzip, deflate");
            builder.mHeaders.set("Content-Type", "application/x-www-form-urlencoded");
            builder.mHeaders.set("Connection", "keep-alive");
            builder.mHeaders.set("User-Agent", Headers.VALUE_USER_AGENT);
            builder.mHeaders.set("Accept-Language", Headers.VALUE_ACCEPT_LANGUAGE);
        }

        public Builder workThreadExecutor(Executor executor) {
            this.mWorkExecutor = executor;
            return this;
        }

        public Builder mainThreadExecutor(Executor executor) {
            this.mMainExecutor = executor;
            return this;
        }

        public Builder charset(Charset charset) {
            this.mCharset = charset;
            return this;
        }

        public Builder addHeader(String string, String string2) {
            Builder builder = this;
            builder.mHeaders.add(string, string2);
            return builder;
        }

        public Builder setHeader(String string, String string2) {
            Builder builder = this;
            builder.mHeaders.set(string, string2);
            return builder;
        }

        public Builder proxy(Proxy proxy) {
            this.mProxy = proxy;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.mSSLSocketFactory = sSLSocketFactory;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.mHostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder connectionTimeout(int n2, TimeUnit timeUnit) {
            this.mConnectTimeout = (int)Math.min(timeUnit.toMillis(n2), Integer.MAX_VALUE);
            return this;
        }

        public Builder readTimeout(int n2, TimeUnit timeUnit) {
            this.mReadTimeout = (int)Math.min(timeUnit.toMillis(n2), Integer.MAX_VALUE);
            return this;
        }

        public Builder addParam(String string, String string2) {
            Builder builder = this;
            builder.mParams.add(string, string2);
            return builder;
        }

        public Builder cacheStore(CacheStore cacheStore) {
            this.mCacheStore = cacheStore;
            return this;
        }

        public Builder network(Network network) {
            this.mNetwork = network;
            return this;
        }

        public Builder connectFactory(ConnectFactory connectFactory) {
            this.mConnectFactory = connectFactory;
            return this;
        }

        public Builder cookieStore(CookieStore cookieStore) {
            this.mCookieStore = cookieStore;
            return this;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            Builder builder = this;
            builder.mInterceptors.add(interceptor);
            return builder;
        }

        public Builder addInterceptors(List<Interceptor> list) {
            Builder builder = this;
            builder.mInterceptors.addAll(list);
            return builder;
        }

        public Builder converter(Converter converter) {
            this.mConverter = converter;
            return this;
        }

        public KalleConfig build() {
            return new KalleConfig(this);
        }
    }
}

