/*
 * Decompiled with CFR 0.152.
 */
package com.meihu.kalle;

import android.os.Build;
import android.text.TextUtils;
import com.meihu.kalle.util.ListMap;
import java.net.HttpCookie;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Headers
extends ListMap<String, String> {
    public static final String TIME_FORMAT_HTTP = "EEE, dd MMM y HH:mm:ss 'GMT'";
    public static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    public static final String KEY_ACCEPT = "Accept";
    public static final String VALUE_ACCEPT_ALL = "*/*";
    public static final String KEY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String VALUE_ACCEPT_ENCODING = "gzip, deflate";
    public static final String KEY_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String VALUE_ACCEPT_LANGUAGE = Headers.getLanguage();
    public static final String KEY_ACCEPT_RANGE = "Accept-Range";
    public static final String KEY_COOKIE = "Cookie";
    public static final String KEY_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String KEY_CONTENT_ENCODING = "Content-Encoding";
    public static final String KEY_CONTENT_LENGTH = "Content-Length";
    public static final String KEY_CONTENT_RANGE = "Content-Range";
    public static final String KEY_CONTENT_TYPE = "Content-Type";
    public static final String VALUE_APPLICATION_URLENCODED = "application/x-www-form-urlencoded";
    public static final String VALUE_APPLICATION_FORM = "multipart/form-data";
    public static final String VALUE_APPLICATION_STREAM = "application/octet-stream";
    public static final String VALUE_APPLICATION_JSON = "application/json";
    public static final String VALUE_APPLICATION_XML = "application/xml";
    public static final String KEY_CACHE_CONTROL = "Cache-Control";
    public static final String KEY_CONNECTION = "Connection";
    public static final String VALUE_KEEP_ALIVE = "keep-alive";
    public static final String VALUE_CLOSE = "close";
    public static final String KEY_DATE = "Date";
    public static final String KEY_EXPIRES = "Expires";
    public static final String KEY_E_TAG = "ETag";
    public static final String KEY_HOST = "Host";
    public static final String KEY_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String KEY_IF_NONE_MATCH = "If-None-Match";
    public static final String KEY_LAST_MODIFIED = "Last-Modified";
    public static final String KEY_LOCATION = "Location";
    public static final String KEY_RANGE = "Range";
    public static final String KEY_SET_COOKIE = "Set-Cookie";
    public static final String KEY_USER_AGENT = "User-Agent";
    public static final String VALUE_USER_AGENT = Headers.getUserAgent();

    public Headers() {
        Comparator<String> comparator;
        TreeMap treeMap;
        Headers headers = treeMap2;
        TreeMap treeMap2 = treeMap;
        Comparator<String> comparator2 = comparator;
        comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        };
        treeMap = new TreeMap(comparator2);
        super(treeMap2);
    }

    private long getDateField(String string) {
        if (!TextUtils.isEmpty((CharSequence)(this = ((Headers)this).getFirst(string)))) {
            try {
                return Headers.formatGMTToMillis((String)this);
            }
            catch (ParseException parseException) {}
        }
        return 0L;
    }

    public static String formatKey(String stringArray) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return null;
        }
        stringArray = stringArray.toLowerCase(Locale.ENGLISH).split("-");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            String string2 = string;
            string2 = string2.substring(1);
            stringBuilder2.append(string.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(string2).append("-");
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.deleteCharAt(stringBuilder3.lastIndexOf("-"));
        }
        return stringBuilder2.toString();
    }

    public static Headers fromJSONString(String object) throws JSONException {
        JSONObject jSONObject;
        Headers headers;
        Headers headers2 = headers;
        headers = new Headers();
        JSONObject jSONObject2 = jSONObject;
        object = new JSONObject((String)object).keys();
        while (object.hasNext()) {
            JSONArray jSONArray;
            String string = (String)object.next();
            String string2 = jSONObject2.optString(string);
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray(string2);
            for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                headers2.add(string, jSONArray2.optString(i2));
            }
        }
        return headers2;
    }

    public static String toJSONString(Headers headers) {
        JSONObject jSONObject;
        Headers headers2 = headers;
        headers = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry entry : headers2.entrySet()) {
            Object object = entry;
            object = object.getValue();
            try {
                headers.put((String)entry.getKey(), new JSONArray((Collection)object));
            }
            catch (JSONException jSONException) {
            }
        }
        return headers.toString();
    }

    public static Map<String, String> getRequestHeaders(Headers object) {
        LinkedHashMap linkedHashMap;
        Headers headers = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : headers.entrySet()) {
            object.put((String)entry.getKey(), TextUtils.join((CharSequence)"; ", entry.getValue()));
        }
        return object;
    }

    public static List<HttpCookie> getHttpCookieList(Headers headers) {
        ArrayList<HttpCookie> arrayList;
        ArrayList<HttpCookie> arrayList2 = arrayList;
        arrayList = new ArrayList<HttpCookie>();
        for (Object object : headers.keySet()) {
            if (!((String)object).equalsIgnoreCase(KEY_SET_COOKIE)) continue;
            object = headers.get((String)object).iterator();
            while (object.hasNext()) {
                arrayList2.addAll(HttpCookie.parse((String)object.next()));
            }
        }
        return arrayList2;
    }

    public static String parseSubValue(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            StringTokenizer stringTokenizer;
            StringTokenizer stringTokenizer2 = stringTokenizer;
            stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer2.hasMoreElements()) {
                string = stringTokenizer2.nextToken();
                int n2 = string.indexOf(61);
                if (n2 <= 0 || !string2.equalsIgnoreCase(string.substring(0, n2).trim())) continue;
                string3 = string.substring(n2 + 1).trim();
                break;
            }
        }
        return string3;
    }

    public static long formatGMTToMillis(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_HTTP, Locale.US);
        simpleDateFormat.setTimeZone(TIME_ZONE_GMT);
        return simpleDateFormat.parse(string).getTime();
    }

    public static String formatMillisToGMT(long l2) {
        Date date;
        Date date2 = date;
        date = new Date(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_HTTP, Locale.US);
        simpleDateFormat.setTimeZone(TIME_ZONE_GMT);
        return simpleDateFormat.format(date2);
    }

    public static long analysisCacheExpires(Headers headers) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        String string = headers.getCacheControl();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            StringTokenizer stringTokenizer;
            StringTokenizer stringTokenizer2 = stringTokenizer;
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken().trim().toLowerCase(Locale.getDefault());
                if (!string2.equals("no-cache") && !string2.equals("no-store")) {
                    if (string2.startsWith("max-age=")) {
                        l3 = Long.parseLong(string2.substring(8)) * 1000L;
                        continue;
                    }
                    if (string2.startsWith("must-revalidate")) {
                        return 0L;
                    }
                    if (!string2.startsWith("stale-while-revalidate=")) continue;
                    l4 = Long.parseLong(string2.substring(23)) * 1000L;
                    continue;
                }
                return 0L;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            l2 += l3;
            if (l4 > 0L) {
                l2 += l4;
            }
            return l2;
        }
        l3 = headers.getExpires();
        if (l3 > (l4 = headers.getDate())) {
            return l2 + l3 - l4;
        }
        return 0L;
    }

    public static String getLanguage() {
        StringBuilder stringBuilder;
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder2.append('-').append(string2).append(',').append(string);
        }
        return stringBuilder2.toString();
    }

    public static String getUserAgent() {
        StringBuffer stringBuffer;
        String string = "Mozilla/5.0 (Linux; U; Android %s) AppleWebKit/534.30 (KHTML, like Gecko) Version/5.0 %sSafari/534.30";
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append(Build.VERSION.RELEASE).append("; ");
        Object object = Locale.getDefault();
        String string2 = ((Locale)object).getLanguage();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            stringBuffer2.append(string2.toLowerCase((Locale)object));
            string2 = ((Locale)object).getCountry();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                stringBuffer2.append("-");
                stringBuffer2.append(string2.toLowerCase((Locale)object));
            }
        } else {
            stringBuffer2.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && ((String)(object = Build.MODEL)).length() > 0) {
            StringBuffer stringBuffer3 = stringBuffer2;
            stringBuffer3.append("; ");
            stringBuffer3.append((String)object);
        }
        if (Build.ID.length() > 0) {
            StringBuffer stringBuffer4 = stringBuffer2;
            stringBuffer4.append(" Api/");
            stringBuffer4.append(Build.ID);
        }
        return String.format(string, stringBuffer2, "Mobile ");
    }

    @Override
    public void add(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            super.add(Headers.formatKey(string), string2);
        }
    }

    @Override
    public void set(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            super.set(Headers.formatKey(string), string2);
        }
    }

    @Override
    public void add(String string, List<String> list) {
        if (!TextUtils.isEmpty((CharSequence)string) && !list.isEmpty()) {
            super.add(Headers.formatKey(string), list);
        }
    }

    @Override
    public void set(String string, List<String> list) {
        if (!TextUtils.isEmpty((CharSequence)string) && !list.isEmpty()) {
            super.set(Headers.formatKey(string), list);
        }
    }

    public void add(Headers object) {
        for (Map.Entry entry : ((ListMap)((Object)object)).entrySet()) {
            String string = (String)entry.getKey();
            Iterator iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                this.add(string, (String)iterator.next());
            }
        }
    }

    @Override
    public List<String> remove(String string) {
        return super.remove(Headers.formatKey(string));
    }

    @Override
    public List<String> get(String string) {
        return super.get(Headers.formatKey(string));
    }

    @Override
    public String getFirst(String string) {
        return (String)super.getFirst(Headers.formatKey(string));
    }

    @Override
    public boolean containsKey(String string) {
        return super.containsKey(Headers.formatKey(string));
    }

    public void set(Headers object) {
        for (Map.Entry entry : ((ListMap)((Object)object)).entrySet()) {
            this.set((String)entry.getKey(), entry.getValue());
        }
    }

    public String getCacheControl() {
        if ((list = ((Headers)((Object)list)).get(KEY_CACHE_CONTROL)) == null) {
            List list = Collections.emptyList();
        }
        return TextUtils.join((CharSequence)",", list);
    }

    public String getContentDisposition() {
        return this.getFirst(KEY_CONTENT_DISPOSITION);
    }

    public String getContentEncoding() {
        return this.getFirst(KEY_CONTENT_ENCODING);
    }

    public long getContentLength() {
        if (TextUtils.isEmpty((CharSequence)(object = ((Headers)object).getFirst(KEY_CONTENT_LENGTH)))) {
            Object object = "0";
        }
        return Long.parseLong((String)object);
    }

    public String getContentType() {
        return this.getFirst(KEY_CONTENT_TYPE);
    }

    public String getContentRange() {
        return this.getFirst(KEY_CONTENT_RANGE);
    }

    public long getDate() {
        return this.getDateField(KEY_DATE);
    }

    public String getETag() {
        return this.getFirst(KEY_E_TAG);
    }

    public long getExpires() {
        return this.getDateField(KEY_EXPIRES);
    }

    public long getLastModified() {
        return this.getDateField(KEY_LAST_MODIFIED);
    }

    public String getLocation() {
        return this.getFirst(KEY_LOCATION);
    }
}

